/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.plc.instruction;

import com.neep.neepmeat.api.plc.PLC;
import com.neep.neepmeat.api.plc.recipe.Workpiece;
import com.neep.neepmeat.api.plc.robot.AtomicAction;
import com.neep.neepmeat.api.plc.robot.DelayAction;
import com.neep.neepmeat.api.plc.robot.GroupedRobotAction;
import com.neep.neepmeat.api.plc.robot.RobotAction;
import com.neep.neepmeat.api.storage.LazyBlockApiCache;
import com.neep.neepmeat.init.NMComponents;
import com.neep.neepmeat.init.NMSounds;
import com.neep.neepmeat.neepasm.NeepASM;
import com.neep.neepmeat.plc.Instructions;
import com.neep.neepmeat.plc.block.entity.ImplanterActuator;
import com.neep.neepmeat.plc.block.entity.ImplanterBlockEntity;
import com.neep.neepmeat.plc.component.MutateInPlace;
import com.neep.neepmeat.plc.instruction.Argument;
import com.neep.neepmeat.plc.instruction.InstructionProvider;
import com.neep.neepmeat.plc.instruction.PlcInstruction;
import com.neep.neepmeat.plc.recipe.EntityMutateRecipe;
import com.neep.neepmeat.plc.recipe.ImplantStep;
import com.neep.neepmeat.plc.recipe.PLCRecipes;
import com.neep.neepmeat.plc.robot.PLCActuator;
import com.neep.neepmeat.plc.robot.RobotMoveToAction;
import java.util.List;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.ResourceAmount;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3419;
import org.jetbrains.annotations.NotNull;

public class ImplantInstruction
implements PlcInstruction {
    private final Supplier<class_1937> world;
    private final LazyBlockApiCache<MutateInPlace<class_1297>, Void> toCache;
    private final Argument from;
    private final Argument to;
    private final GroupedRobotAction group;

    public ImplantInstruction(Supplier<class_1937> world, List<Argument> arguments) {
        this.world = world;
        this.from = arguments.get(0);
        this.to = arguments.get(1);
        this.toCache = LazyBlockApiCache.of(MutateInPlace.ENTITY, this.to.pos(), world, () -> null);
        this.group = GroupedRobotAction.of(new RobotMoveToAction(this.from.pos()), AtomicAction.of(this::takeFrom), new Glue(), AtomicAction.of(this::playSound), new DelayAction(40), AtomicAction.of(this::install));
    }

    private void playSound(PLC plc) {
        PLCActuator robot = plc.getActuator();
        this.world.get().method_8465(null, robot.getX(), robot.getY(), robot.getZ(), NMSounds.IMPLANT_INSTRUCTION_APPLY, class_3419.field_15254, 1.0f, 1.0f, 1L);
    }

    public ImplantInstruction(Supplier<class_1937> world, class_2487 compound) {
        this(world, List.of(Argument.fromNbt(compound.method_10562("from")), Argument.fromNbt(compound.method_10562("to"))));
        this.group.readNbt(compound.method_10562("action"));
    }

    @Override
    public class_2487 writeNbt(class_2487 nbt) {
        nbt.method_10566("from", (class_2520)this.from.toNbt());
        nbt.method_10566("to", (class_2520)this.to.toNbt());
        nbt.method_10566("action", (class_2520)this.group.writeNbt(new class_2487()));
        return nbt;
    }

    @Override
    public void start(PLC plc) throws NeepASM.RuntimeException {
        PLCActuator pLCActuator = plc.getActuator();
        if (!(pLCActuator instanceof ImplanterActuator)) {
            throw new NeepASM.RuntimeException("Actuator is not an Implanter");
        }
        ImplanterActuator implanter = (ImplanterActuator)pLCActuator;
        plc.addRobotAction(this.group, this::finish);
    }

    @Override
    public void cancel(PLC plc) {
        this.group.end(plc);
        plc.getActuator().dumpStored(plc);
        PLCActuator pLCActuator = plc.getActuator();
        if (pLCActuator instanceof ImplanterBlockEntity) {
            ImplanterBlockEntity implanter = (ImplanterBlockEntity)pLCActuator;
            implanter.targetRestPos();
        }
    }

    private void takeFrom(PLC plc) {
        ResourceAmount<ItemVariant> takenAmount = Instructions.takeItem(this.from, this.world, 1, Pattern.compile(".*"));
        if (takenAmount != null) {
            plc.getActuator().dumpStored(plc);
            plc.getActuator().setStored(plc, takenAmount);
            PLCActuator robot = plc.getActuator();
            this.world.get().method_8465(null, robot.getX(), robot.getY(), robot.getZ(), NMSounds.EXTRACT_ITEM, class_3419.field_15245, 1.0f, 1.0f, 1L);
        } else {
            this.cancel(plc);
            plc.raiseError(new PLC.Error("implant: No item in input storage"));
        }
    }

    private void install(PLC plc) {
        ImplantStep step;
        MutateInPlace<class_1297> mip = this.toCache.find();
        PLCActuator actuator = plc.getActuator();
        ResourceAmount<ItemVariant> stored = actuator.getStored(plc);
        if (mip != null && stored != null && ImplantInstruction.install(step = new ImplantStep(((ItemVariant)stored.resource()).getItem()), mip)) {
            stored = null;
        }
        if (stored != null) {
            actuator.dumpStored(plc);
        } else {
            actuator.setStored(plc, null);
        }
        if (actuator instanceof ImplanterBlockEntity) {
            ImplanterBlockEntity implanter = (ImplanterBlockEntity)actuator;
            implanter.targetRestPos();
        }
    }

    public static boolean install(ImplantStep step, MutateInPlace<class_1297> mip) {
        Workpiece workpiece;
        class_1297 entity = mip.get();
        if (entity != null && (workpiece = (Workpiece)NMComponents.WORKPIECE.getNullable((Object)entity)) != null) {
            step.mutate(entity);
            EntityMutateRecipe recipe = PLCRecipes.matchEntityMutate(mip);
            if (recipe != null) {
                recipe.ejectOutputs(mip, null);
                workpiece.clearSteps();
            }
            return true;
        }
        return false;
    }

    private void finish(PLC plc) {
        plc.advanceCounter();
    }

    public static double getTargetY(class_1297 target) {
        return target.method_23318() + (double)(target.method_17682() / 2.0f);
    }

    private void setImplanterTarget(PLC plc, ImplanterActuator implanter) {
        MutateInPlace<class_1297> mip = this.toCache.find();
        if (mip != null && mip.get() != null) {
            class_1297 entity = mip.get();
            if (entity != null && NMComponents.WORKPIECE.isProvidedBy((Object)entity)) {
                class_243 v = new class_243(entity.method_23317(), ImplantInstruction.getTargetY(entity), entity.method_23321());
                implanter.setImplantTarget(plc, v, entity);
            }
        } else {
            plc.raiseError(new PLC.Error("No surgery platform with entity found"));
            this.cancel(plc);
            implanter.targetRestPos();
        }
    }

    @Override
    @NotNull
    public InstructionProvider getOpcode() {
        return Instructions.IMPLANT;
    }

    class Glue
    implements RobotAction {
        Glue() {
        }

        @Override
        public boolean finished(PLC plc) {
            return plc.getActuator().reachedTarget(plc);
        }

        @Override
        public void start(PLC plc) {
            plc.controlActuator(ImplanterActuator.class, implanter -> ImplantInstruction.this.setImplanterTarget(plc, (ImplanterActuator)implanter));
        }

        @Override
        public void tick(PLC plc) {
        }

        @Override
        public void end(PLC plc) {
        }
    }
}

