/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.plc.memory;

import com.neep.neepbus.util.message.DataVariant;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import net.minecraft.class_3532;

public class ResizableByteBuffer {
    private ByteBuffer bb;
    private int size;

    public ResizableByteBuffer(int capacity) {
        this.size = class_3532.method_15339((int)capacity);
        this.bb = ByteBuffer.allocate(this.size);
    }

    public ResizableByteBuffer(ByteBuffer bb) {
        this.size = bb.capacity();
        this.bb = bb;
    }

    public ResizableByteBuffer(ResizableByteBuffer other) {
        this(other.bb.duplicate());
    }

    public void assureSize(int i, int elementSize) {
        int requiredCapacity = i + elementSize;
        if (requiredCapacity > this.bb.capacity()) {
            ByteBuffer newBuffer = ByteBuffer.allocate(class_3532.method_15339((int)requiredCapacity));
            newBuffer.put(this.bb);
            this.bb = newBuffer;
        }
        if (requiredCapacity > this.size) {
            this.size = requiredCapacity;
        }
    }

    public void assureSize(int size) {
        this.assureSize(size, 0);
    }

    public void putByte(int offset, byte value) {
        this.assureSize(offset, 1);
        this.bb.put(offset, value);
    }

    public void putFloat(int i, float val) {
        this.assureSize(i, 4);
        this.bb.putFloat(i, val);
    }

    public void putInt(int i, int val) {
        this.assureSize(i, 4);
        this.bb.putInt(i, val);
    }

    public void putString(int i, String val) {
        byte[] bytes = val.getBytes(StandardCharsets.ISO_8859_1);
        this.assureSize(i, bytes.length);
        this.bb.put(i, bytes);
    }

    public float getFloat(int i) {
        return this.bb.getFloat(i);
    }

    public int getInt(int i) {
        return this.bb.getInt(i);
    }

    public byte getByte(int i) {
        return this.bb.get(i);
    }

    public CharSequence getString(int offset, int bytes) {
        return StandardCharsets.ISO_8859_1.decode(ByteBuffer.wrap(this.bb.array(), offset, bytes));
    }

    public void clear() {
        this.bb.clear();
    }

    public int capacity() {
        return this.bb.capacity();
    }

    public int size() {
        return this.size;
    }

    public void erase(int offset, int size) {
        Arrays.fill(this.bb.array(), offset, offset + size, (byte)0);
        if (offset + size >= this.size) {
            this.size -= size;
        }
    }

    public byte[] trimmed() {
        byte[] array = new byte[this.size];
        this.bb.get(array);
        return array;
    }

    public static class StringEntry
    extends Entry {
        private final int size;

        protected StringEntry(ResizableByteBuffer bb, int offset, String s) {
            super(bb, offset);
            this.size = s.length();
            bb.putString(offset, s);
        }

        @Override
        public float floatValue() {
            return DataVariant.toFloat(this.stringValue());
        }

        @Override
        public String stringValue() {
            return this.bb.getString(this.offset, this.size).toString();
        }

        @Override
        public void erase() {
            this.bb.erase(this.offset, this.size);
        }
    }

    public static class IntEntry
    extends Entry {
        public IntEntry(ResizableByteBuffer bb, int offset, int value) {
            super(bb, offset);
            bb.putInt(offset, value);
        }

        @Override
        public int intValue() {
            return this.bb.getInt(this.offset);
        }

        @Override
        public float floatValue() {
            return this.intValue();
        }

        @Override
        public String stringValue() {
            return Integer.toString(this.intValue());
        }

        @Override
        public void erase() {
            this.bb.erase(this.offset, 4);
        }
    }

    public static class FloatEntry
    extends Entry {
        protected FloatEntry(ResizableByteBuffer bb, int offset, float value) {
            super(bb, offset);
            bb.putFloat(offset, value);
        }

        @Override
        public float floatValue() {
            return this.bb.getFloat(this.offset);
        }

        @Override
        public String stringValue() {
            return Float.toString(this.floatValue());
        }

        @Override
        public void erase() {
            this.bb.erase(this.offset, 4);
        }
    }

    public static abstract class Entry
    implements DataVariant {
        protected final ResizableByteBuffer bb;
        public final int offset;

        protected Entry(ResizableByteBuffer bb, int offset) {
            this.bb = bb;
            this.offset = offset;
        }

        public float eraseFloat() {
            float value = this.floatValue();
            this.erase();
            return value;
        }

        public int eraseInt() {
            int value = this.intValue();
            this.erase();
            return value;
        }

        public String eraseString() {
            String value = this.stringValue();
            this.erase();
            return value;
        }

        public abstract void erase();
    }
}

