/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.plc.processor;

import com.neep.meatlib.util.NbtSerialisable;
import com.neep.neepmeat.neepasm.NeepASM;
import com.neep.neepmeat.neepasm.vm.DataStack;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.BitSet;
import java.util.List;
import net.minecraft.class_2487;

public class VariableStack
implements DataStack,
NbtSerialisable {
    private final IntArrayList entries = new IntArrayList();
    private BitSet pointers = new BitSet();
    private final int maxSize;

    public VariableStack(int maxSize) {
        this.maxSize = maxSize;
    }

    public IntArrayList getInts() {
        return this.entries;
    }

    @Override
    public void push(int entry) throws NeepASM.RuntimeException {
        if (this.size() >= this.maxSize) {
            throw new NeepASM.RuntimeException("data stack overflow");
        }
        this.entries.push(entry);
    }

    @Override
    public void push(int entry, boolean pointer) throws NeepASM.RuntimeException {
        if (this.size() >= this.maxSize) {
            throw new NeepASM.RuntimeException("data stack overflow");
        }
        this.pointers.set(this.entries.size(), pointer);
        this.entries.push(entry);
    }

    @Override
    public int popInt() throws NeepASM.RuntimeException {
        if (this.isEmpty()) {
            throw new NeepASM.RuntimeException("data stack underflow");
        }
        this.pointers.clear(this.entries.size() - 1);
        return this.entries.popInt();
    }

    @Override
    public DataStack.Entry pop() throws NeepASM.RuntimeException {
        if (this.isEmpty()) {
            throw new NeepASM.RuntimeException("data stack underflow");
        }
        int lastIndex = this.entries.size() - 1;
        return new DataStack.Entry(this.entries.popInt(), this.pointers.get(lastIndex));
    }

    @Override
    public DataStack.Entry peek(int i) throws NeepASM.RuntimeException {
        if (i >= this.size() || i < 0) {
            throw new NeepASM.RuntimeException("data stack underflow");
        }
        return new DataStack.Entry(this.entries.peekInt(i), this.pointers.get(this.entries.size() - 1 - i));
    }

    @Override
    public int peekInt(int i) throws NeepASM.RuntimeException {
        return this.peek(i).value();
    }

    public boolean peekPointer(int i) throws NeepASM.RuntimeException {
        return this.peek(i).pointer();
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    @Override
    public class_2487 writeNbt(class_2487 nbt) {
        nbt.method_10572("entries", (List)this.entries);
        nbt.method_10570("pointers", this.pointers.toByteArray());
        return nbt;
    }

    public void clear() {
        this.entries.clear();
    }

    @Override
    public void push(DataStack.Entry entry) throws NeepASM.RuntimeException {
        if (this.size() >= this.maxSize) {
            throw new NeepASM.RuntimeException("data stack overflow");
        }
        this.pointers.set(this.entries.size(), entry.pointer());
        this.entries.push(entry.value());
    }

    @Override
    public void readNbt(class_2487 nbt) {
        this.entries.clear();
        int[] ints = nbt.method_10561("entries");
        this.entries.size(ints.length);
        this.entries.setElements(ints);
        byte[] bytes = nbt.method_10547("pointers");
        this.pointers = BitSet.valueOf(bytes);
    }
}

