/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.plc.recipe;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.neep.meatlib.recipe.MeatRecipeSerialiser;
import com.neep.meatlib.recipe.MeatRecipeType;
import com.neep.meatlib.recipe.ingredient.RecipeOutput;
import com.neep.meatlib.recipe.ingredient.RecipeOutputImpl;
import com.neep.meatlib.recipe.ingredient.RecipeOutputs;
import com.neep.meatlib.util.MeatLibCodecs;
import com.neep.neepmeat.api.plc.recipe.ManufactureStep;
import com.neep.neepmeat.api.plc.recipe.Workpiece;
import com.neep.neepmeat.init.NMComponents;
import com.neep.neepmeat.plc.component.MutateInPlace;
import com.neep.neepmeat.plc.recipe.ManufactureRecipe;
import com.neep.neepmeat.plc.recipe.PLCRecipes;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2359;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public class ItemManufactureRecipe
implements ManufactureRecipe<MutateInPlace<class_1799>, class_1792> {
    protected final class_2960 id;
    protected final class_1792 base;
    protected final RecipeOutput<class_1792> output;
    protected List<ManufactureStep<?>> steps;

    public ItemManufactureRecipe(class_2960 id, class_1792 base, RecipeOutput<class_1792> output, List<ManufactureStep<?>> steps) {
        this.id = id;
        this.base = base;
        this.output = output;
        this.steps = steps;
    }

    @Override
    public class_1792 getBase() {
        return this.base;
    }

    @Override
    public List<ManufactureStep<?>> getSteps() {
        return this.steps;
    }

    @Override
    public boolean matches(MutateInPlace<class_1799> context) {
        class_1799 stack = context.get();
        if (stack == null || !stack.method_31574(this.base)) {
            return false;
        }
        Workpiece workpiece = NMComponents.WORKPIECE.maybeGet((Object)stack).orElse(null);
        if (workpiece != null) {
            List<ManufactureStep<?>> workSteps = workpiece.getSteps();
            if (workSteps.size() != this.steps.size()) {
                return false;
            }
            for (int i = 0; i < workSteps.size(); ++i) {
                ManufactureStep<?> step = workSteps.get(i);
                if (ManufactureStep.equals(step, this.steps.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean takeInputs(MutateInPlace<class_1799> context, TransactionContext transaction) {
        return false;
    }

    @Override
    public boolean ejectOutputs(MutateInPlace<class_1799> context, TransactionContext transaction) {
        class_1799 outputStack = new class_1799((class_1935)this.output.resource(), Math.toIntExact(this.output.randomAmount(0.0f)));
        context.setResult(1, outputStack);
        return true;
    }

    public RecipeOutput<class_1792> getRecipeOutput() {
        return this.output;
    }

    public MeatRecipeType<?> getType() {
        return PLCRecipes.MANUFACTURE;
    }

    @Override
    public MeatRecipeSerialiser<?> getSerializer() {
        return PLCRecipes.MANUFACTURE_SERIALISER;
    }

    @Override
    public class_2960 method_8114() {
        return this.id;
    }

    public static class Serialiser
    implements MeatRecipeSerialiser<ItemManufactureRecipe> {
        private final Codec<MeatRecipeSerialiser.RecipeFunction<ItemManufactureRecipe>> codec = RecordCodecBuilder.create(instance -> instance.group((App)class_2378.field_11142.method_39673().fieldOf("id").fieldOf("base").forGetter(MeatLibCodecs::notImplemented), (App)ManufactureStep.LIST_CODEC.fieldOf("steps").forGetter(MeatLibCodecs::notImplemented), (App)RecipeOutputs.ITEM.fieldOf("result").forGetter(MeatLibCodecs::notImplemented)).apply((Applicative)instance, (b, s, r) -> id -> new ItemManufactureRecipe(id, (class_1792)b, (RecipeOutput<class_1792>)r, (List<ManufactureStep<?>>)s)));

        @Override
        public Codec<MeatRecipeSerialiser.RecipeFunction<ItemManufactureRecipe>> codec() {
            return this.codec;
        }

        public static void writeSteps(List<ManufactureStep<?>> steps, class_2540 buf) {
            buf.writeInt(steps.size());
            for (ManufactureStep<?> step : steps) {
                buf.method_10794(step.toNbt());
                buf.method_42065(ManufactureStep.REGISTRY, (Object)((ManufactureStep.Provider)ManufactureStep.REGISTRY.method_10223(step.getId())));
            }
        }

        public static List<ManufactureStep<?>> readSteps(class_2540 buf) {
            int size = buf.readInt();
            ArrayList steps = Lists.newArrayList();
            for (int i = 0; i < size; ++i) {
                class_2487 data = buf.method_10798();
                ManufactureStep step = ((ManufactureStep.Provider)buf.method_42064(ManufactureStep.REGISTRY)).create(data);
                steps.add(step);
            }
            return steps;
        }

        @Override
        public ItemManufactureRecipe read(class_2960 id, class_2540 buf) {
            class_1792 base = (class_1792)buf.method_42064((class_2359)class_2378.field_11142);
            List<ManufactureStep<?>> steps = Serialiser.readSteps(buf);
            RecipeOutputImpl<class_1792> output = RecipeOutputImpl.read(class_2378.field_11142, buf);
            return new ItemManufactureRecipe(id, base, output, steps);
        }

        @Override
        public void write(class_2540 buf, ItemManufactureRecipe recipe) {
            buf.method_42065((class_2359)class_2378.field_11142, (Object)recipe.base);
            Serialiser.writeSteps(recipe.getSteps(), buf);
            recipe.output.write(buf);
        }
    }
}

