/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.neep.meatlib.recipe.MeatRecipeSerialiser;
import com.neep.meatlib.recipe.MeatRecipeType;
import com.neep.meatlib.recipe.MeatlibRecipe;
import com.neep.meatlib.recipe.ingredient.RecipeInputs;
import com.neep.meatlib.recipe.ingredient.RecipeOutput;
import com.neep.meatlib.recipe.ingredient.RecipeOutputImpl;
import com.neep.meatlib.recipe.ingredient.RecipeOutputs;
import com.neep.meatlib.recipe.ingredient.RegistryRecipeInput;
import com.neep.meatlib.util.MeatLibCodecs;
import com.neep.neepmeat.init.NMrecipeTypes;
import com.neep.neepmeat.machine.alloy_kiln.AlloyKilnStorage;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public class AlloyKilnRecipe
implements MeatlibRecipe<AlloyKilnStorage> {
    protected class_2960 id;
    protected RegistryRecipeInput<class_1792> itemInput1;
    protected RegistryRecipeInput<class_1792> itemInput2;
    protected RecipeOutput<class_1792> itemOutput;
    protected int processTime;

    public AlloyKilnRecipe(class_2960 id, RegistryRecipeInput<class_1792> itemInput1, RegistryRecipeInput<class_1792> itemInput2, RecipeOutput<class_1792> itemOutput, int processTime) {
        this.itemInput1 = itemInput1;
        this.itemInput2 = itemInput2;
        this.itemOutput = itemOutput;
        this.processTime = processTime;
        this.id = id;
    }

    @Override
    public boolean matches(AlloyKilnStorage context) {
        List<SingleSlotStorage<ItemVariant>> slots = List.of(context.getSlot(AlloyKilnStorage.INPUT_1), context.getSlot(AlloyKilnStorage.INPUT_2));
        LinkedList<RegistryRecipeInput<class_1792>> queue = new LinkedList<RegistryRecipeInput<class_1792>>(List.of(this.itemInput1, this.itemInput2));
        ListIterator it = queue.listIterator();
        block0: while (it.hasNext()) {
            RegistryRecipeInput ingredient = (RegistryRecipeInput)it.next();
            for (StorageView storageView : slots) {
                if (!ingredient.test(storageView)) continue;
                it.remove();
                continue block0;
            }
        }
        return queue.size() == 0;
    }

    public RegistryRecipeInput<class_1792> getItemInput1() {
        return this.itemInput1;
    }

    public RegistryRecipeInput<class_1792> getItemInput2() {
        return this.itemInput2;
    }

    public RecipeOutput<class_1792> getItemOutput() {
        return this.itemOutput;
    }

    public int getProcessTime() {
        return this.processTime;
    }

    @Override
    public class_2960 method_8114() {
        return this.id;
    }

    public MeatRecipeType<?> getType() {
        return NMrecipeTypes.ALLOY_SMELTING;
    }

    @Override
    public MeatRecipeSerialiser<?> getSerializer() {
        return NMrecipeTypes.ALLOY_KILN_SERIALIZER;
    }

    public int getTime() {
        return this.processTime;
    }

    @Override
    public boolean takeInputs(AlloyKilnStorage storage, TransactionContext transaction) {
        try (Transaction inner = transaction.openNested();){
            Storage<ItemVariant> inputStorage = storage.getInputStorage();
            Optional<class_1792> item1 = this.itemInput1.getFirstMatching(inputStorage, (TransactionContext)inner);
            Optional<class_1792> item2 = this.itemInput2.getFirstMatching(inputStorage, (TransactionContext)inner);
            if (item1.isEmpty() || item2.isEmpty()) {
                inner.abort();
                boolean bl = false;
                return bl;
            }
            long extracted1 = inputStorage.extract((Object)ItemVariant.of((class_1935)((class_1935)item1.get())), this.itemInput1.amount(), transaction);
            long extracted2 = inputStorage.extract((Object)ItemVariant.of((class_1935)((class_1935)item2.get())), this.itemInput2.amount(), transaction);
            if (extracted1 == this.itemInput1.amount() && extracted2 == this.itemInput2.amount()) {
                inner.commit();
                storage.markDirty();
                boolean bl = true;
                return bl;
            }
            inner.abort();
        }
        return false;
    }

    @Override
    public boolean ejectOutputs(AlloyKilnStorage context, TransactionContext transaction) {
        return false;
    }

    public boolean ejectOutput(AlloyKilnStorage storage, TransactionContext transaction) {
        try (Transaction inner = transaction.openNested();){
            boolean bl1 = this.itemOutput.insertInto(storage.getOutputStorage(), ItemVariant::of, (TransactionContext)inner);
            if (bl1) {
                inner.commit();
                storage.markDirty();
                boolean bl = true;
                return bl;
            }
            inner.abort();
        }
        return false;
    }

    public static class Serializer
    implements MeatRecipeSerialiser<AlloyKilnRecipe> {
        private final Codec<MeatRecipeSerialiser.RecipeFunction<AlloyKilnRecipe>> codec;
        RecipeFactory<AlloyKilnRecipe> factory;
        int processTIme;

        public Serializer(RecipeFactory<AlloyKilnRecipe> recipeFactory, int processTime) {
            this.factory = recipeFactory;
            this.processTIme = processTime;
            this.codec = RecordCodecBuilder.create(instance -> instance.group((App)RecipeInputs.ITEM.codec().fieldOf("input1").forGetter(MeatLibCodecs::notImplemented), (App)RecipeInputs.ITEM.codec().fieldOf("input2").forGetter(MeatLibCodecs::notImplemented), (App)RecipeOutputs.ITEM.fieldOf("output").forGetter(MeatLibCodecs::notImplemented), (App)Codec.INT.optionalFieldOf("processtime", (Object)processTime).forGetter(MeatLibCodecs::notImplemented)).apply((Applicative)instance, (i1, i2, o, t) -> id -> this.factory.create(id, (RegistryRecipeInput<class_1792>)i1, (RegistryRecipeInput<class_1792>)i2, (RecipeOutput<class_1792>)o, (int)t)));
        }

        @Override
        public Codec<MeatRecipeSerialiser.RecipeFunction<AlloyKilnRecipe>> codec() {
            return this.codec;
        }

        @Override
        public AlloyKilnRecipe read(class_2960 id, class_2540 buf) {
            RegistryRecipeInput<class_1792> itemInput1 = RegistryRecipeInput.fromBuffer(buf);
            RegistryRecipeInput<class_1792> itemInput2 = RegistryRecipeInput.fromBuffer(buf);
            RecipeOutputImpl<class_1792> itemOutput = RecipeOutputImpl.read(class_2378.field_11142, buf);
            int time = buf.method_10816();
            return this.factory.create(id, itemInput1, itemInput2, itemOutput, time);
        }

        @Override
        public void write(class_2540 buf, AlloyKilnRecipe recipe) {
            recipe.itemInput1.write(buf);
            recipe.itemInput2.write(buf);
            recipe.itemOutput.write(buf);
            buf.method_10804(recipe.processTime);
        }

        @FunctionalInterface
        public static interface RecipeFactory<T extends AlloyKilnRecipe> {
            public T create(class_2960 var1, RegistryRecipeInput<class_1792> var2, RegistryRecipeInput<class_1792> var3, RecipeOutput<class_1792> var4, int var5);
        }
    }
}

