/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.neep.meatlib.recipe.MeatRecipeSerialiser;
import com.neep.meatlib.recipe.MeatRecipeType;
import com.neep.meatlib.recipe.ingredient.RecipeInputs;
import com.neep.meatlib.recipe.ingredient.RecipeOutput;
import com.neep.meatlib.recipe.ingredient.RecipeOutputImpl;
import com.neep.meatlib.recipe.ingredient.RecipeOutputs;
import com.neep.meatlib.recipe.ingredient.RegistryRecipeInput;
import com.neep.meatlib.util.MeatLibCodecs;
import com.neep.neepmeat.init.NMrecipeTypes;
import com.neep.neepmeat.machine.small_trommel.TrommelRecipe;
import com.neep.neepmeat.machine.small_trommel.TrommelStorage;
import java.util.Optional;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1792;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import org.jetbrains.annotations.Nullable;

public class NormalTrommelRecipe
implements TrommelRecipe {
    protected final class_2960 id;
    protected final RegistryRecipeInput<class_3611> fluidInput;
    protected final RecipeOutput<class_3611> fluidOutput;
    protected final RecipeOutput<class_1792> itemOutput;

    public NormalTrommelRecipe(class_2960 id, RegistryRecipeInput<class_3611> fluidInput, RecipeOutput<class_3611> fluidOutput, @Nullable RecipeOutput<class_1792> itemOutput) {
        this.fluidInput = fluidInput;
        this.fluidOutput = fluidOutput;
        this.itemOutput = itemOutput;
        this.id = id;
    }

    @Override
    public boolean matches(TrommelStorage inventory) {
        SingleVariantStorage<FluidVariant> storage = inventory.input();
        return this.fluidInput.test((StorageView<TransferVariant<?>>)storage) && this.fluidInput.amount() <= storage.getAmount();
    }

    public RegistryRecipeInput<class_3611> getFluidInput() {
        return this.fluidInput;
    }

    public RecipeOutput<class_3611> getFluidOutput() {
        return this.fluidOutput;
    }

    public RecipeOutput<class_1792> getAuxOutput() {
        return this.itemOutput;
    }

    @Override
    public class_2960 method_8114() {
        return this.id;
    }

    public MeatRecipeType<?> getType() {
        return NMrecipeTypes.TROMMEL;
    }

    @Override
    public MeatRecipeSerialiser<?> getSerializer() {
        return NMrecipeTypes.TROMMEL_SERIALIZER;
    }

    @Override
    public boolean takeInputs(TrommelStorage storage, TransactionContext transaction) {
        try (Transaction inner = transaction.openNested();){
            SingleVariantStorage<FluidVariant> fluidStorage = storage.input();
            Optional<class_3611> fluid = this.fluidInput.getFirstMatching((Storage<TransferVariant<?>>)fluidStorage, (TransactionContext)inner);
            if (fluid.isEmpty()) {
                throw new IllegalStateException("Storage contents do not conform to recipe");
            }
            long ex2 = fluidStorage.extract((Object)FluidVariant.of((class_3611)fluid.get()), this.fluidInput.amount(), (TransactionContext)inner);
            if (ex2 == this.fluidInput.amount()) {
                inner.commit();
                boolean bl = true;
                return bl;
            }
            inner.abort();
        }
        return false;
    }

    @Override
    public boolean ejectOutputs(TrommelStorage context, TransactionContext transaction) {
        try (Transaction inner = transaction.openNested();){
            boolean bl1 = this.fluidOutput.insertInto(context.output(), FluidVariant::of, (TransactionContext)inner);
            if (this.itemOutput != null) {
                this.itemOutput.insertInto(context.itemOutput(), ItemVariant::of, (TransactionContext)inner);
            }
            if (bl1) {
                inner.commit();
                boolean bl = true;
                return bl;
            }
            inner.abort();
        }
        return false;
    }

    public static class Serializer
    implements MeatRecipeSerialiser<NormalTrommelRecipe> {
        private final RecipeFactory<NormalTrommelRecipe> factory;
        private final Codec<MeatRecipeSerialiser.RecipeFunction<NormalTrommelRecipe>> codec;

        public Serializer(RecipeFactory<NormalTrommelRecipe> recipeFactory) {
            this.factory = recipeFactory;
            this.codec = RecordCodecBuilder.create(instance -> instance.group((App)RecipeInputs.FLUID.codec().fieldOf("input").forGetter(MeatLibCodecs::notImplemented), (App)RecipeOutputs.FLUID.fieldOf("output").forGetter(MeatLibCodecs::notImplemented), (App)RecipeOutputs.ITEM.optionalFieldOf("aux_output").forGetter(MeatLibCodecs::notImplemented)).apply((Applicative)instance, (i, o1, o2) -> id -> new NormalTrommelRecipe(id, (RegistryRecipeInput<class_3611>)i, (RecipeOutput<class_3611>)o1, o2.orElse(null))));
        }

        @Override
        public Codec<MeatRecipeSerialiser.RecipeFunction<NormalTrommelRecipe>> codec() {
            return this.codec;
        }

        @Override
        public NormalTrommelRecipe read(class_2960 id, class_2540 buf) {
            RegistryRecipeInput<class_3611> fluidInput = RegistryRecipeInput.fromBuffer(buf);
            RecipeOutputImpl<class_3611> fluidOutput = RecipeOutputImpl.read(class_2378.field_11154, buf);
            Optional itemOutput = buf.method_37436(b -> RecipeOutputImpl.read(class_2378.field_11142, b));
            return this.factory.create(id, fluidInput, fluidOutput, itemOutput.orElse(null));
        }

        @Override
        public void write(class_2540 buf, NormalTrommelRecipe recipe) {
            recipe.fluidInput.write(buf);
            recipe.fluidOutput.write(buf);
            buf.method_37435(Optional.ofNullable(recipe.itemOutput), (b, o) -> o.write((class_2540)b));
        }

        @FunctionalInterface
        public static interface RecipeFactory<T extends NormalTrommelRecipe> {
            public T create(class_2960 var1, RegistryRecipeInput<class_3611> var2, RecipeOutput<class_3611> var3, RecipeOutput<class_1792> var4);
        }
    }
}

