/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.neep.meatlib.recipe.MeatRecipeSerialiser;
import com.neep.meatlib.recipe.ingredient.RecipeInputs;
import com.neep.meatlib.recipe.ingredient.RecipeOutput;
import com.neep.meatlib.recipe.ingredient.RecipeOutputImpl;
import com.neep.meatlib.recipe.ingredient.RecipeOutputs;
import com.neep.meatlib.recipe.ingredient.RegistryRecipeInput;
import com.neep.meatlib.util.MeatLibCodecs;
import com.neep.neepmeat.api.storage.WritableSingleFluidStorage;
import com.neep.neepmeat.init.NMrecipeTypes;
import com.neep.neepmeat.machine.casting_basin.CastingBasinStorage;
import com.neep.neepmeat.recipe.AbstractPressingRecipe;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1792;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_3956;

public class PressingRecipe
extends AbstractPressingRecipe<CastingBasinStorage> {
    protected class_2960 id;
    protected RegistryRecipeInput<class_3611> fluidInput;
    protected RecipeOutput<class_1792> itemOutput;

    public PressingRecipe(class_2960 id, RegistryRecipeInput<class_3611> fluidInput, RecipeOutput<class_1792> itemOutput) {
        this.fluidInput = fluidInput;
        this.itemOutput = itemOutput;
        this.id = id;
    }

    @Override
    public boolean matches(CastingBasinStorage inventory) {
        WritableSingleFluidStorage storage = inventory.fluid(null);
        return this.fluidInput.test(storage) && storage.getAmount() == this.fluidInput.amount();
    }

    public RegistryRecipeInput<class_3611> getFluidInput() {
        return this.fluidInput;
    }

    @Override
    public class_2960 method_8114() {
        return this.id;
    }

    @Override
    public MeatRecipeSerialiser<?> getSerializer() {
        return NMrecipeTypes.PRESSING_SERIALIZER;
    }

    public class_3956<?> method_17716() {
        return NMrecipeTypes.PRESSING;
    }

    @Override
    public boolean takeInputs(CastingBasinStorage storage, TransactionContext transaction) {
        try (Transaction inner = transaction.openNested();){
            WritableSingleFluidStorage fluidStorage = storage.fluid(null);
            FluidVariant fluidVariant = (FluidVariant)fluidStorage.getResource();
            class_3611 fluid = this.fluidInput.getFirstMatching(fluidStorage).orElse(null);
            if (fluid == null) {
                boolean bl = false;
                return bl;
            }
            storage.unlock();
            long ex2 = fluidStorage.extract((TransferVariant)((FluidVariant)fluidStorage.getResource()), this.fluidInput.amount(), (TransactionContext)inner);
            storage.lock();
            if (ex2 != this.fluidInput.amount()) {
                inner.abort();
                boolean bl = false;
                return bl;
            }
            boolean transferred = this.itemOutput.insertInto(storage.item(null), ItemVariant::of, transaction);
            if (transferred) {
                inner.commit();
                boolean bl = true;
                return bl;
            }
            inner.abort();
        }
        return false;
    }

    public RecipeOutput<class_1792> getItemOutput() {
        return this.itemOutput;
    }

    public static class Serializer
    implements MeatRecipeSerialiser<PressingRecipe> {
        private final Codec<MeatRecipeSerialiser.RecipeFunction<PressingRecipe>> codec = RecordCodecBuilder.create(instance -> instance.group((App)RecipeInputs.FLUID.codec().fieldOf("fluid_input").forGetter(MeatLibCodecs::notImplemented), (App)RecipeOutputs.ITEM.fieldOf("output").forGetter(MeatLibCodecs::notImplemented)).apply((Applicative)instance, (i, o) -> id -> new PressingRecipe(id, (RegistryRecipeInput<class_3611>)i, (RecipeOutput<class_1792>)o)));

        @Override
        public Codec<MeatRecipeSerialiser.RecipeFunction<PressingRecipe>> codec() {
            return this.codec;
        }

        @Override
        public PressingRecipe read(class_2960 id, class_2540 buf) {
            RegistryRecipeInput<class_3611> fluidInput = RegistryRecipeInput.fromBuffer(buf);
            RecipeOutputImpl<class_1792> itemOutput = RecipeOutputImpl.read(class_2378.field_11142, buf);
            return new PressingRecipe(id, fluidInput, itemOutput);
        }

        @Override
        public void write(class_2540 buf, PressingRecipe recipe) {
            recipe.fluidInput.write(buf);
            recipe.itemOutput.write(buf);
        }

        @FunctionalInterface
        public static interface RecipeFactory<T extends PressingRecipe> {
            public T create(class_2960 var1, RegistryRecipeInput<class_3611> var2, RecipeOutputImpl<class_1792> var3);
        }
    }
}

