/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.recipe;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.neep.meatlib.recipe.ImplementedRecipe;
import com.neep.meatlib.recipe.ingredient.Ingredients;
import com.neep.meatlib.recipe.ingredient.RecipeInputs;
import com.neep.meatlib.recipe.ingredient.RecipeOutput;
import com.neep.meatlib.recipe.ingredient.RecipeOutputImpl;
import com.neep.meatlib.recipe.ingredient.RegistryRecipeInput;
import com.neep.neepmeat.init.NMFluids;
import com.neep.neepmeat.init.NMrecipeTypes;
import com.neep.neepmeat.machine.crucible.CrucibleStorage;
import java.util.Optional;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1792;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3611;
import net.minecraft.class_3956;

public class RenderingRecipe
extends ImplementedRecipe<CrucibleStorage> {
    protected class_2960 id;
    protected RegistryRecipeInput<class_1792> itemInput;
    protected RegistryRecipeInput<class_3611> fluidInput;
    protected RecipeOutput<class_3611> fluidOutput;

    public RenderingRecipe(class_2960 id, RegistryRecipeInput<class_1792> itemInput, RegistryRecipeInput<class_3611> fluidInput, RecipeOutput<class_3611> fluidOutput) {
        this.itemInput = itemInput;
        this.fluidInput = fluidInput;
        this.fluidOutput = fluidOutput;
        this.id = id;
    }

    public boolean matches(CrucibleStorage inventory, class_1937 world) {
        return this.itemInput.test((StorageView<TransferVariant<?>>)inventory.getItemStorage(null)) && this.fluidInput.test((StorageView<TransferVariant<?>>)inventory.getStorage(null));
    }

    @Override
    public boolean method_8113(int width, int height) {
        return false;
    }

    public RegistryRecipeInput<class_1792> getItemInput() {
        return this.itemInput;
    }

    public RegistryRecipeInput<class_3611> getFluidInput() {
        return this.fluidInput;
    }

    public RecipeOutput<class_3611> getFluidOutput() {
        return this.fluidOutput;
    }

    public class_2960 method_8114() {
        return this.id;
    }

    public class_1865<?> method_8119() {
        return NMrecipeTypes.RENDERING_SERIALIZER;
    }

    public class_3956<?> method_17716() {
        return NMrecipeTypes.RENDERING;
    }

    public class_1792 takeInputs(CrucibleStorage storage, int amount, TransactionContext transaction) {
        try (Transaction inner = transaction.openNested();){
            SingleSlotStorage<ItemVariant> itemStorage = storage.getItemStorage(null);
            SingleSlotStorage<FluidVariant> fluidStorage = storage.getStorage(null);
            Optional<class_1792> item = this.itemInput.getFirstMatching((Storage<TransferVariant<?>>)itemStorage, (TransactionContext)inner);
            Optional<class_3611> fluid = this.fluidInput.getFirstMatching((Storage<TransferVariant<?>>)fluidStorage, (TransactionContext)inner);
            if (item.isEmpty() || fluid.isEmpty()) {
                throw new IllegalStateException("Storage contents do not conform to recipe");
            }
            long ex1 = itemStorage.extract((Object)ItemVariant.of((class_1935)((class_1935)item.get())), this.itemInput.amount() * (long)amount, (TransactionContext)inner);
            long ex2 = fluidStorage.extract((Object)FluidVariant.of((class_3611)fluid.get()), this.fluidInput.amount() * (long)amount, (TransactionContext)inner);
            if (ex1 == this.itemInput.amount() * (long)amount && ex2 == this.fluidInput.amount() * (long)amount) {
                inner.commit();
                class_1792 class_17922 = item.get();
                return class_17922;
            }
            inner.abort();
        }
        return null;
    }

    public boolean ejectOutput(CrucibleStorage storage, int amount, TransactionContext transaction) {
        try (Transaction inner = transaction.openNested();){
            boolean bl1 = true;
            for (int i = 0; i < amount; ++i) {
                bl1 = bl1 && this.fluidOutput.insertInto(storage.getFluidOutput(), FluidVariant::of, (TransactionContext)inner);
            }
            if (bl1) {
                inner.commit();
                boolean bl = true;
                return bl;
            }
            inner.abort();
        }
        return false;
    }

    public static class Serializer
    implements class_1865<RenderingRecipe> {
        RecipeFactory<RenderingRecipe> factory;

        public Serializer(RecipeFactory<RenderingRecipe> recipeFactory) {
            this.factory = recipeFactory;
        }

        public RenderingRecipe read(class_2960 id, JsonObject json) {
            JsonObject inputElement = class_3518.method_15296((JsonObject)json, (String)"item_input");
            RegistryRecipeInput<class_1792> itemInput = RegistryRecipeInput.fromJson(RecipeInputs.ITEM, inputElement);
            JsonObject fluidInputElement = class_3518.method_15296((JsonObject)json, (String)"fluid_input");
            RegistryRecipeInput<class_3611> fluidInput = RegistryRecipeInput.fromJson(RecipeInputs.FLUID, fluidInputElement);
            JsonObject outputElement = class_3518.method_15296((JsonObject)json, (String)"output");
            RecipeOutput<class_3611> fluidOutput = RecipeOutputImpl.fromJson(Ingredients.FLUID, outputElement);
            if (outputElement.has("fat_item")) {
                if (!fluidOutput.resource().equals(NMFluids.STILL_DIRTY_ORE_FAT)) {
                    throw new IllegalStateException("Fluid '" + String.valueOf(fluidOutput.resource()) + "' is not an Ore Fat fluid");
                }
                class_2487 nbt = new class_2487();
                class_2960 rawId = new class_2960(class_3518.method_15265((JsonObject)outputElement, (String)"fat_item"));
                class_2378.field_11142.method_17966(rawId).orElseThrow(() -> new JsonSyntaxException("Unknown item '" + String.valueOf(rawId) + "'"));
                nbt.method_10582("item", rawId.toString());
                fluidOutput.setNbt(nbt);
            }
            return this.factory.create(id, itemInput, fluidInput, fluidOutput);
        }

        public RenderingRecipe read(class_2960 id, class_2540 buf) {
            RegistryRecipeInput<class_1792> itemInput = RegistryRecipeInput.fromBuffer(buf);
            RegistryRecipeInput<class_3611> fluidInput = RegistryRecipeInput.fromBuffer(buf);
            RecipeOutputImpl<class_3611> fluidOutput = RecipeOutputImpl.read(class_2378.field_11154, buf);
            return this.factory.create(id, itemInput, fluidInput, fluidOutput);
        }

        public void write(class_2540 buf, RenderingRecipe recipe) {
            recipe.itemInput.write(buf);
            recipe.fluidInput.write(buf);
            recipe.fluidOutput.write(buf);
        }

        @FunctionalInterface
        public static interface RecipeFactory<T extends RenderingRecipe> {
            public T create(class_2960 var1, RegistryRecipeInput<class_1792> var2, RegistryRecipeInput<class_3611> var3, RecipeOutput<class_3611> var4);
        }
    }
}

