/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.screen_handler;

import com.neep.meatlib.screen.ScreenReadyListener;
import com.neep.meatlib.screen.WidgetHandler;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_3913;
import net.minecraft.class_3917;
import org.jetbrains.annotations.Nullable;

public abstract class BasicScreenHandler
extends class_1703
implements ScreenReadyListener {
    protected final class_1263 inventory;
    protected class_1661 playerInventory;
    @Nullable
    protected class_3913 propertyDelegate;
    private final List<WidgetHandler> widgetHandlers = new ObjectArrayList();
    protected boolean ready;

    protected BasicScreenHandler(@Nullable class_3917<?> type, class_1661 playerInventory, int syncId) {
        this(type, playerInventory, null, syncId, null);
    }

    protected BasicScreenHandler(@Nullable class_3917<?> type, class_1661 playerInventory, @Nullable class_1263 inventory, int syncId, @Nullable class_3913 delegate) {
        super(type, syncId);
        this.propertyDelegate = delegate;
        this.inventory = inventory == null ? new class_1277(0) : inventory;
        this.playerInventory = playerInventory;
        if (inventory != null) {
            inventory.method_5435(playerInventory.field_7546);
        }
        if (this.propertyDelegate != null) {
            this.method_17360(delegate);
        }
    }

    protected <T extends WidgetHandler> T addWidgetHandler(T handler) {
        this.widgetHandlers.add(handler);
        return handler;
    }

    public int getProperty(int i) {
        if (this.propertyDelegate != null) {
            return this.propertyDelegate.method_17390(i);
        }
        return 0;
    }

    public boolean isClient() {
        return this.playerInventory.field_7546.method_37908().method_8608();
    }

    public void method_7606(int i, int value) {
        if (this.propertyDelegate != null) {
            this.propertyDelegate.method_17391(i, value);
        }
    }

    public static int playerInvH() {
        return 78;
    }

    public static int playerSlotsW() {
        return 164;
    }

    protected void createPlayerSlots(int startX, int startY, class_1661 playerInventory) {
        this.createInventory(startX, startY, playerInventory);
        this.createHotbar(startX, startY + 58, playerInventory);
    }

    protected void createInventory(int startX, int startY, class_1661 playerInventory) {
        for (int m = 0; m < 3; ++m) {
            for (int l = 0; l < 9; ++l) {
                this.method_7621(new class_1735((class_1263)playerInventory, l + m * 9 + 9, startX + l * 18, startY + m * 18));
            }
        }
    }

    protected void createHotbar(int startX, int startY, class_1661 playerInventory) {
        for (int m = 0; m < 9; ++m) {
            this.method_7621(new class_1735((class_1263)playerInventory, m, startX + m * 18, startY));
        }
    }

    protected void createSlotBlock(int startX, int startY, int nx, int ny, class_1263 inventory, int startIndex, SlotConstructor constructor) {
        for (int m = 0; m < ny; ++m) {
            for (int l = 0; l < nx; ++l) {
                this.method_7621(constructor.construct(inventory, startIndex + l + m * nx, startX + l * 18, startY + m * 18));
            }
        }
    }

    public class_1799 method_7601(class_1657 player, int index) {
        class_1799 originalCopy = class_1799.field_8037;
        class_1735 slot = (class_1735)this.field_7761.get(index);
        if (slot.method_7681()) {
            class_1799 mutableStack = slot.method_7677();
            originalCopy = mutableStack.method_7972();
            if (index < this.inventory.method_5439()) {
                if (!this.method_7616(mutableStack, this.inventory.method_5439(), this.field_7761.size(), true)) {
                    return class_1799.field_8037;
                }
                slot.method_7670(mutableStack, originalCopy);
                slot.method_7671(64);
                slot.method_7668();
            } else if (!this.method_7616(mutableStack, 0, this.inventory.method_5439(), false)) {
                return class_1799.field_8037;
            }
            if (mutableStack.method_7960()) {
                slot.method_7673(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
        }
        return originalCopy;
    }

    public void method_7623() {
        super.method_7623();
        if (this.ready) {
            for (WidgetHandler handler : this.widgetHandlers) {
                handler.sendUpdates();
            }
        }
    }

    public void method_7595(class_1657 player) {
        super.method_7595(player);
        for (WidgetHandler handler : this.widgetHandlers) {
            handler.close();
        }
    }

    public boolean method_7597(class_1657 player) {
        return true;
    }

    @Override
    public void onScreenReady() {
        this.ready = true;
    }

    @FunctionalInterface
    public static interface SlotConstructor {
        public class_1735 construct(class_1263 var1, int var2, int var3, int var4);
    }
}

