/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.thord.parser;

import com.neep.neepmeat.neepasm.NeepASM;
import com.neep.neepmeat.neepasm.compiler.NeepAsmParser;
import com.neep.neepmeat.neepasm.compiler.ParsedFunction;
import com.neep.neepmeat.neepasm.compiler.alias.ParsedAlias;
import com.neep.neepmeat.neepasm.compiler.alias.ParsedArgumentAlias;
import com.neep.neepmeat.neepasm.program.Label;
import com.neep.neepmeat.plc.instruction.Instruction;
import com.neep.neepmeat.plc.instruction.InstructionProvider;
import com.neep.neepmeat.plc.instruction.PushInstruction;
import com.neep.neepmeat.thord.parser.ThordDictionary;
import com.neep.neepmeat.thord.parser.ThordParsedSource;
import com.neep.neepmeat.thord.parser.ThordProgramTree;
import com.neep.neepmeat.thord.parser.TreeVisitorImpl;
import com.neep.neepmeat.thord.parser.node.ArrayNode;
import com.neep.neepmeat.thord.parser.node.ImmediateWordDefinitionNode;
import com.neep.neepmeat.thord.parser.node.InlineNode;
import com.neep.neepmeat.thord.parser.node.LabelNode;
import com.neep.neepmeat.thord.parser.node.NonameWordDefinitionNode;
import com.neep.neepmeat.thord.parser.node.NumberLiteralNode;
import com.neep.neepmeat.thord.parser.node.PostponeNode;
import com.neep.neepmeat.thord.parser.node.TickNode;
import com.neep.neepmeat.thord.parser.node.TreeNode;
import com.neep.neepmeat.thord.parser.node.VariableDeclareNode;
import com.neep.neepmeat.thord.parser.node.WordDefinitionNode;
import com.neep.neepmeat.thord.parser.node.WordNode;
import com.neep.neepmeat.thord.parser.node.WorldTargetAliasToken;
import com.neep.neepmeat.thord.token.CoordsToken;
import com.neep.neepmeat.thord.token.IdentifierToken;
import com.neep.neepmeat.thord.token.InlineToken;
import com.neep.neepmeat.thord.token.IntLiteralToken;
import com.neep.neepmeat.thord.token.KeywordToken;
import com.neep.neepmeat.thord.token.LexerContext;
import com.neep.neepmeat.thord.token.NewlineToken;
import com.neep.neepmeat.thord.token.ScopeEndToken;
import com.neep.neepmeat.thord.token.StringToken;
import com.neep.neepmeat.thord.token.ThordLexer;
import com.neep.neepmeat.thord.token.ThordToken;
import com.neep.neepmeat.thord.token.ThordTokenView;
import com.neep.neepmeat.thord.token.TokenVisitor;
import com.neep.neepmeat.thord.word.FunctionWord;
import com.neep.neepmeat.thord.word.VariableWord;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public class ThordParser {
    private final Map<String, InstructionProvider> instructions;
    private final ThordLexer lexer;
    private NeepAsmParser neepAsmParser;

    public ThordParser(ThordLexer lexer, Map<String, InstructionProvider> instructions) {
        this.instructions = instructions;
        this.lexer = lexer;
        this.neepAsmParser = new NeepAsmParser(instructions);
    }

    public ThordParsedSource parse(String source, ThordDictionary dictionary) throws NeepASM.ProgramBuildException {
        this.neepAsmParser = new NeepAsmParser(this.instructions);
        ThordTokenView view = new ThordTokenView(source);
        try {
            ThordProgramTree tree = new ThordProgramTree(dictionary);
            new TokenVisitorImpl(view, tree, this.lexer, this.instructions::get, a -> this.neepAsmParser.getParsedSource().alias((ParsedAlias)a)).process();
            ThordParsedSource parsedSource = new ThordParsedSource();
            TreeVisitorImpl visitor = new TreeVisitorImpl(tree, parsedSource, this.neepAsmParser);
            visitor.process();
            parsedSource.instruction((abelLookup, program) -> Instruction.EMPTY, view.line() + 1);
            for (ParsedFunction function : parsedSource.functions()) {
                function.expand(parsedSource);
            }
            return parsedSource;
        }
        catch (NeepASM.ParseException e) {
            throw new NeepASM.ProgramBuildException(view.line(), view.linePos(), e.getMessage());
        }
    }

    private static class TokenVisitorImpl
    implements TokenVisitor {
        private final LexerContext context;
        private final ThordTokenView view;
        private final ThordProgramTree tree;
        private final ThordLexer lexer;
        private final Function<String, InstructionProvider> lookup;
        private final Consumer<ParsedAlias> aliasConsumer;
        private final Deque<TreeNode> path = new ArrayDeque<TreeNode>();

        public TokenVisitorImpl(ThordTokenView view, ThordProgramTree tree, ThordLexer lexer, Function<String, InstructionProvider> lookup, Consumer<ParsedAlias> aliasConsumer) {
            this.view = view;
            this.tree = tree;
            this.lexer = lexer;
            this.lookup = lookup;
            this.aliasConsumer = aliasConsumer;
            this.context = new LexerContext(this.view);
            this.path.push(tree.root());
        }

        @Nullable
        private ThordToken nextToken() throws NeepASM.ParseException {
            return this.lexer.nextToken(this.context);
        }

        public void process() throws NeepASM.ProgramBuildException, NeepASM.ParseException {
            int line = 0;
            while (this.lexer.hasNext(this.context)) {
                ThordToken token = this.nextToken();
                if (token == null) continue;
                line = this.view.line();
                try {
                    token.visit(this);
                    if (!this.path.isEmpty()) continue;
                    throw new NeepASM.ParseException("too many ;");
                }
                catch (NeepASM.ParseException e) {
                    throw new NeepASM.ProgramBuildException(line, 0, e.getMessage());
                }
            }
            if (this.path.size() != 1) {
                throw new NeepASM.ProgramBuildException(line, 0, "missing ;");
            }
        }

        private TreeNode peek() throws NeepASM.ParseException {
            if (this.path.peek() == null) {
                throw new NeepASM.ParseException("too many ;");
            }
            return this.path.peek();
        }

        private void append(TreeNode node) throws NeepASM.ParseException {
            this.peek().add(node);
        }

        private void pushScope(TreeNode node) throws NeepASM.ParseException {
            this.peek().add(node);
            this.path.push(node);
        }

        private void popScope() {
            this.path.pop();
        }

        @Override
        public void visit(KeywordToken token) throws NeepASM.ParseException {
            switch (token.value()) {
                case WORD: {
                    ThordToken next = this.nextToken();
                    if (next instanceof IdentifierToken) {
                        IdentifierToken identifierToken = (IdentifierToken)next;
                        String word = identifierToken.value();
                        this.tree.dictionary().put(word, new FunctionWord(word));
                        this.pushScope(new WordDefinitionNode(word, token.line()));
                        return;
                    }
                    throw new NeepASM.ParseException("expected word name");
                }
                case WORD_NONAME: {
                    this.pushScope(new NonameWordDefinitionNode(token.line()));
                    break;
                }
                case IMMEDIATE_WORD: {
                    ThordToken next = this.nextToken();
                    if (next instanceof IdentifierToken) {
                        IdentifierToken identifierToken = (IdentifierToken)next;
                        String word = identifierToken.value();
                        ImmediateWordDefinitionNode node = new ImmediateWordDefinitionNode(word, token.line());
                        this.tree.root().addPre(node);
                        this.path.push(node);
                        return;
                    }
                    throw new NeepASM.ParseException("expected word name");
                }
                case LABEL: {
                    ThordToken next = this.nextToken();
                    if (next instanceof IdentifierToken) {
                        IdentifierToken identifierToken = (IdentifierToken)next;
                        String name = identifierToken.value();
                        this.append(new LabelNode(name, token.line()));
                        int line = token.line();
                        this.tree.dictionary().put(name, (acceptor, stack, line1) -> acceptor.instruction((labelLookup, program) -> {
                            program.setDebugLine(line1);
                            Label found = labelLookup.findLabel(name);
                            if (found == null) {
                                throw new NeepASM.CompilationException("label '" + name + "' does not exist");
                            }
                            return new PushInstruction(found.index());
                        }, line));
                        return;
                    }
                    throw new NeepASM.ParseException("expected label name");
                }
                case TICK: {
                    ThordToken next = this.nextToken();
                    if (next instanceof IdentifierToken) {
                        IdentifierToken identifierToken = (IdentifierToken)next;
                        this.append(new TickNode(identifierToken.value(), token.line()));
                        break;
                    }
                    throw new NeepASM.ParseException("expected word");
                }
                case VARIABLE: {
                    ThordToken next = this.nextToken();
                    if (next instanceof IdentifierToken) {
                        IdentifierToken identifierToken = (IdentifierToken)next;
                        String name = identifierToken.value();
                        this.append(new VariableDeclareNode(name, token.line()));
                        this.tree.dictionary().put(name, new VariableWord(name));
                        break;
                    }
                    throw new NeepASM.ParseException("expected variable name");
                }
                case ARRAY: {
                    ThordToken identifierToken = this.nextToken();
                    if (identifierToken instanceof IdentifierToken) {
                        IdentifierToken identifierToken2 = (IdentifierToken)identifierToken;
                        Object name = this.nextToken();
                        if (name instanceof IntLiteralToken) {
                            IntLiteralToken intLiteralToken = (IntLiteralToken)name;
                            name = identifierToken2.value();
                            this.append(new ArrayNode((String)name, intLiteralToken.value(), token.line()));
                            this.tree.dictionary().put((String)name, new VariableWord((String)name));
                            break;
                        }
                        throw new NeepASM.ParseException("expected array length");
                    }
                    throw new NeepASM.ParseException("expected variable name");
                }
                case POSTPONE: {
                    this.pushScope(new PostponeNode(token.line()));
                }
            }
        }

        @Override
        public void visit(IdentifierToken token) throws NeepASM.ParseException {
            this.append(new WordNode(token.value().toLowerCase(), token.line()));
        }

        @Override
        public void visit(IntLiteralToken token) throws NeepASM.ParseException {
            this.append(new NumberLiteralNode(token.value(), token.line()));
        }

        @Override
        public void visit(InlineToken token) throws NeepASM.ParseException {
            InstructionProvider provider = this.lookup.apply(token.name().toLowerCase());
            if (provider == null) {
                throw new NeepASM.ParseException("unrecognised operation '" + token.name() + "'");
            }
            this.append(new InlineNode(provider, token.arguments(), token.line()));
        }

        @Override
        public void visit(NewlineToken token) {
        }

        @Override
        public void visit(CoordsToken token) throws NeepASM.ParseException {
            this.append(token);
        }

        @Override
        public void visit(WorldTargetAliasToken token) {
            this.aliasConsumer.accept(new ParsedArgumentAlias(token.name(), token.argument()));
        }

        @Override
        public void visit(StringToken token) throws NeepASM.ParseException {
            this.append(token);
        }

        @Override
        public void visit(ScopeEndToken token) {
            this.popScope();
        }
    }
}

