/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.transport.block.fluid_transport.machine;

import com.neep.meatlib.blockentity.SyncableBlockEntity;
import com.neep.meatlib.util.LazySupplier;
import com.neep.neepmeat.api.storage.WritableSingleFluidStorage;
import com.neep.neepmeat.network.TankMessagePacket;
import com.neep.neepmeat.transport.block.fluid_transport.TankBlock;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiCache;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiLookup;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

public class TankBlockEntity
extends SyncableBlockEntity {
    protected final InternalBuffer buffer;
    protected LazySupplier<BlockApiCache<TankBlockEntity, class_2591<?>>> downCache = LazySupplier.of(() -> BlockApiCache.create(LOOKUP, (class_3218)((class_3218)this.method_10997()), (class_2338)this.method_11016().method_10074()));
    protected LazySupplier<BlockApiCache<TankBlockEntity, class_2591<?>>> upCache = LazySupplier.of(() -> BlockApiCache.create(LOOKUP, (class_3218)((class_3218)this.method_10997()), (class_2338)this.method_11016().method_10084()));
    public static final BlockApiLookup<TankBlockEntity, class_2591<?>> LOOKUP = BlockApiLookup.get((class_2960)new class_2960("neepmeat", "tank_lookup"), TankBlockEntity.class, class_2591.class);

    public TankBlockEntity(class_2591 type, class_2338 pos, class_2680 state, long amount) {
        super(type, pos, state);
        this.buffer = new InternalBuffer(amount, this::sync);
    }

    public WritableSingleFluidStorage getStorage(class_2350 direction) {
        return this.buffer;
    }

    @Override
    public void method_11007(class_2487 tag) {
        super.method_11007(tag);
        this.buffer.toNbt(tag);
    }

    @Override
    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.buffer.readNbt(tag);
    }

    public void method_38240(class_1799 stack) {
        super.method_38240(stack);
    }

    public boolean onUse(class_1657 player, class_1268 hand) {
        if (WritableSingleFluidStorage.handleInteract((Storage<FluidVariant>)this.buffer, this.field_11863, player, hand)) {
            return true;
        }
        if (!this.field_11863.method_8608()) {
            TankBlockEntity.showContents((class_3222)player, this.field_11863, this.method_11016(), this.buffer);
            return true;
        }
        return true;
    }

    @Override
    public void method_5431() {
        super.method_5431();
    }

    public static void showContents(class_3222 player, class_1937 world, class_2338 pos, StorageView<FluidVariant> buffer) {
        world.method_8396(null, pos, class_3417.field_14819, class_3419.field_15245, 1.0f, 1.5f);
        TankMessagePacket.send(player, pos, buffer.getAmount(), (FluidVariant)buffer.getResource());
    }

    public static <T extends class_2586> TankBlockEntity find(T be, class_2591<?> type) {
        if (be.method_11017().equals(type) && ((class_2350.class_2351)be.method_11010().method_11654((class_2769)TankBlock.field_11459)).method_10178()) {
            return (TankBlockEntity)be;
        }
        return null;
    }

    protected class InternalBuffer
    extends WritableSingleFluidStorage {
        public InternalBuffer(long capacity, Runnable finalCallback) {
            super(capacity, finalCallback);
        }

        public long extract(FluidVariant extractedVariant, long maxAmount, TransactionContext transaction) {
            TankBlockEntity upStorage = (TankBlockEntity)TankBlockEntity.this.upCache.get().find((Object)TankBlockEntity.this.method_11017());
            long upExtracted = 0L;
            if (upStorage != null) {
                upExtracted = upStorage.getStorage(null).extract((TransferVariant)extractedVariant, maxAmount, transaction);
            }
            if (upExtracted < maxAmount) {
                long extracted = super.extract((TransferVariant)extractedVariant, maxAmount - upExtracted, transaction);
                return upExtracted + extracted;
            }
            return upExtracted;
        }

        @Override
        public long insert(FluidVariant insertedVariant, long maxAmount, TransactionContext transaction) {
            TankBlockEntity downStorage = (TankBlockEntity)TankBlockEntity.this.downCache.get().find((Object)TankBlockEntity.this.method_11017());
            long downInserted = 0L;
            if (downStorage != null) {
                downInserted = downStorage.getStorage(null).insert(insertedVariant, maxAmount, transaction);
            }
            long inserted = 0L;
            if (maxAmount - downInserted > 0L) {
                inserted = super.insert(insertedVariant, maxAmount - downInserted, transaction);
            }
            return downInserted + inserted;
        }
    }
}

