/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.transport.block.item_transport;

import com.neep.meatlib.block.BaseBlock;
import com.neep.meatlib.blockentity.SyncableBlockEntity;
import com.neep.meatlib.item.ItemSettings;
import com.neep.meatlib.registry.RegistrationContext;
import com.neep.meatlib.util.graph.PipeVertex;
import com.neep.neepmeat.plc.robot.PLCActuator;
import com.neep.neepmeat.transport.ItemTransport;
import com.neep.neepmeat.transport.api.item_network.RoutingNetwork;
import com.neep.neepmeat.transport.api.pipe.ItemPipe;
import com.neep.neepmeat.transport.api.pipe.PipeConnections;
import com.neep.neepmeat.transport.block.item_transport.RoutingNetworkImpl;
import com.neep.neepmeat.transport.item_network.ItemInPipe;
import com.neep.neepmeat.transport.item_network.ItemPipeVertex;
import com.neep.neepmeat.util.MiscUtil;
import java.util.ArrayDeque;
import java.util.HashSet;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.ResourceAmount;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1264;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import org.jetbrains.annotations.Nullable;

public class PipeDriverBlock
extends BaseBlock
implements class_2343,
ItemPipe {
    public static final class_2746 VALID = class_2746.method_11825((String)"valid");

    public PipeDriverBlock(RegistrationContext ctx, ItemSettings itemSettings, class_4970.class_2251 settings) {
        super(ctx, itemSettings, settings);
        this.method_9590((class_2680)this.method_9564().method_11657((class_2769)VALID, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public long insert(class_1937 world, class_2338 pos, class_2680 state, class_2350 direction, ItemInPipe item, TransactionContext transaction) {
        return 0L;
    }

    @Override
    public boolean isConnected(class_1922 blockView, class_2338 pos, class_2680 state, class_2350 face) {
        return true;
    }

    @Override
    public boolean canItemEnter(ItemVariant variant, long amount, class_1937 world, class_2338 pos, class_2680 state, class_2350 inFace) {
        return false;
    }

    @Override
    public boolean canItemLeave(ResourceAmount<ItemVariant> item, class_1937 world, class_2338 pos, class_2680 state, class_2350 outFace) {
        return false;
    }

    @Override
    public PipeConnections getConnections(class_2680 state, @Nullable class_2350 forbidden) {
        return PipeConnections.ALL;
    }

    public void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean notify) {
        super.method_9615(state, world, pos, oldState, notify);
        if (!world.method_8608()) {
            world.method_35230(pos, ItemTransport.PIPE_DRIVER_BE).ifPresent(be -> be.getNetwork(null).invalidate());
        }
    }

    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 block, class_2338 fromPos, boolean notify) {
        super.method_9612(state, world, pos, block, fromPos, notify);
        if (!world.method_8608()) {
            world.method_35230(pos, ItemTransport.PIPE_DRIVER_BE).ifPresent(be -> be.getNetwork(null).invalidate());
        }
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        super.method_9536(state, world, pos, newState, moved);
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            PipeDriverBlockEntity.emitUpdate(serverWorld, pos, 800);
        }
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{VALID});
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return MiscUtil.checkType(type, ItemTransport.PIPE_DRIVER_BE, PipeDriverBlockEntity::serverTick, null, world);
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return ItemTransport.PIPE_DRIVER_BE.method_11032(pos, state);
    }

    @Override
    public PipeVertex getPipeVertex(class_3218 world, class_2338 pos, class_2680 state) {
        return ItemPipeVertex.NULL;
    }

    public static class PipeDriverBlockEntity
    extends SyncableBlockEntity
    implements PLCActuator,
    PLCActuator.Provider {
        protected final RoutingNetwork network;

        public PipeDriverBlockEntity(class_2338 pos, class_2680 state) {
            this(ItemTransport.PIPE_DRIVER_BE, pos, state);
        }

        public PipeDriverBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
            super(type, pos, state);
            this.network = new RoutingNetworkImpl(this.field_11867, () -> (class_3218)this.method_10997());
        }

        public RoutingNetwork getNetwork(Void ctx) {
            return this.network;
        }

        public static void emitUpdate(class_3218 world, class_2338 origin, int maxDepth) {
            HashSet<Long> visited = new HashSet<Long>();
            ArrayDeque<class_2338> queue = new ArrayDeque<class_2338>(20);
            int depth = 0;
            queue.add(origin);
            while (!queue.isEmpty() && depth < maxDepth) {
                ++depth;
                class_2338 current = (class_2338)queue.poll();
                class_2338.class_2339 mutable = current.method_25503();
                for (class_2350 direction : class_2350.values()) {
                    mutable.method_25505((class_2382)current, direction);
                    if (visited.contains(mutable.method_10063())) continue;
                    visited.add(mutable.method_10063());
                    RoutingNetwork net = (RoutingNetwork)RoutingNetwork.LOOKUP.find((class_1937)world, (class_2338)mutable, null);
                    if (net != null) {
                        net.update();
                        return;
                    }
                    ItemPipe nextPipe = (ItemPipe)ItemTransport.ITEM_PIPE_LOOKUP.find((class_1937)world, (class_2338)mutable, (Object)direction.method_10153());
                    if (nextPipe == null) continue;
                    queue.add(mutable.method_10062());
                }
            }
        }

        public static void serverTick(class_1937 world, class_2338 pos, class_2680 state, PipeDriverBlockEntity be) {
            if (be.network.needsUpdate()) {
                be.network.update();
                world.method_8501(pos, (class_2680)state.method_11657((class_2769)VALID, (Comparable)Boolean.valueOf(be.network.isValid())));
            }
        }

        @Override
        public PLCActuator getPlcActuator() {
            return this;
        }

        @Override
        public class_2338 getBasePos() {
            return this.field_11867;
        }

        @Override
        public void spawnItem(@Nullable ResourceAmount<ItemVariant> stored) {
            if (stored == null) {
                return;
            }
            class_1264.method_5449((class_1937)this.field_11863, (double)((double)this.field_11867.method_10263() + 0.5), (double)((double)this.field_11867.method_10264() + 1.25), (double)((double)this.field_11867.method_10260() + 0.5), (class_1799)((ItemVariant)stored.resource()).toStack((int)stored.amount()));
        }

        @Override
        public boolean actuatorRemoved() {
            return this.method_11015();
        }
    }
}

