/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.transport.block.item_transport.machine;

import com.neep.meatlib.blockentity.SyncableBlockEntity;
import com.neep.meatlib.storage.MeatlibStorageUtil;
import com.neep.meatlib.storage.ResourcePredicate;
import com.neep.neepmeat.api.storage.DynamicLazyBlockApiCache;
import com.neep.neepmeat.api.storage.LazyBlockApiCache;
import com.neep.neepmeat.init.NMBlockEntities;
import com.neep.neepmeat.plc.instruction.PlcInstruction;
import com.neep.neepmeat.transport.block.fluid_transport.PumpBlock;
import com.neep.neepmeat.transport.block.item_transport.machine.EjectorBlock;
import com.neep.neepmeat.transport.block.item_transport.machine.ItemPumpBlock;
import com.neep.neepmeat.transport.block.item_transport.machine.PipeItemMemory;
import com.neep.neepmeat.transport.item_network.ItemInPipe;
import com.neep.neepmeat.transport.util.ItemPipeUtil;
import com.neep.neepmeat.util.MiscUtil;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.ResourceAmount;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1263;
import net.minecraft.class_1693;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_5575;
import org.jetbrains.annotations.Nullable;

public class EjectorBlockEntity
extends SyncableBlockEntity {
    public static final String NBT_COOLDOWN = "cooldown";
    protected final LazyBlockApiCache<Storage<ItemVariant>, class_2350> insertionCache = this.addListener(DynamicLazyBlockApiCache.facing(ItemStorage.SIDED, (class_2586)this, () -> (class_2350)this.method_11010().method_11654((class_2769)EjectorBlock.field_10927)));
    protected final LazyBlockApiCache<Storage<ItemVariant>, class_2350> extractionCache = this.addListener(DynamicLazyBlockApiCache.facing(ItemStorage.SIDED, (class_2586)this, () -> ((class_2350)this.method_11010().method_11654((class_2769)EjectorBlock.field_10927)).method_10153()));
    public int cooldown;
    @Nullable
    protected ResourceAmount<ItemVariant> stored;
    public int shuttle;
    protected boolean activeWithoutRedstone = false;
    public double offset;
    private final PipeItemMemory rememberer = new PipeItemMemory();

    public EjectorBlockEntity(class_2338 pos, class_2680 state) {
        this(NMBlockEntities.EJECTOR, pos, state);
    }

    public EjectorBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Override
    public void fromClientTag(class_2487 tag) {
        this.shuttle = tag.method_10550("shuttle_ticks");
    }

    @Override
    public void toClientTag(class_2487 tag) {
        tag.method_10569("shuttle_ticks", this.shuttle);
    }

    @Override
    public void method_11007(class_2487 tag) {
        super.method_11007(tag);
        tag.method_10569(NBT_COOLDOWN, this.cooldown);
        tag.method_10566("stored", (class_2520)PlcInstruction.writeItem(this.stored));
        tag.method_10556("active_without_redstone", this.activeWithoutRedstone);
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.cooldown = nbt.method_10550(NBT_COOLDOWN);
        this.stored = PlcInstruction.readItem(nbt.method_10562("stored"));
        this.activeWithoutRedstone = nbt.method_10577("active_without_redstone");
    }

    public void serverTick() {
        this.cooldown = Math.max(this.cooldown - 1, 0);
        if (this.shuttle > 0) {
            --this.shuttle;
            if (this.shuttle == 0) {
                this.sync();
            }
        }
        this.eject();
        if (this.cooldown == 0 && ((Boolean)this.method_11010().method_11654((class_2769)EjectorBlock.ACTIVE)).booleanValue() && this.stored == null) {
            this.cooldown = 10;
            this.tryTransfer();
        }
    }

    protected void tryTransfer() {
        Storage<ItemVariant> storage = this.extractionCache.find();
        if (storage != null) {
            try (Transaction transaction = Transaction.openOuter();){
                Storage<ItemVariant> facingStorage = this.insertionCache.find();
                ResourcePredicate<ItemVariant> predicate = MeatlibStorageUtil.insertionPredicate(facingStorage);
                ResourceAmount<ItemVariant> ra = MeatlibStorageUtil.findAndExtractContent(storage, 1L, (TransactionContext)transaction, predicate);
                if (ra == null || ra.amount() != 1L) {
                    transaction.abort();
                    return;
                }
                long canInsert = ra.amount();
                if (facingStorage != null) {
                    canInsert = Math.min(canInsert, MeatlibStorageUtil.simulateInsert(facingStorage, (ItemVariant)ra.resource(), canInsert, (TransactionContext)transaction));
                }
                if (canInsert <= 0L) {
                    transaction.abort();
                    return;
                }
                long extracted = ra.amount();
                if (extracted == canInsert) {
                    this.succeed();
                    this.stored = new ResourceAmount((Object)((ItemVariant)ra.resource()), extracted);
                    transaction.commit();
                    return;
                }
                transaction.abort();
            }
        }
    }

    protected void eject() {
        if (this.stored == null) {
            return;
        }
        try (Transaction transaction = Transaction.openOuter();){
            long forwarded = this.forwardItem((ResourceAmount<ItemVariant>)new ResourceAmount((Object)((ItemVariant)this.stored.resource()), Math.min(16L, this.stored.amount())), (TransactionContext)transaction);
            this.stored = forwarded == this.stored.amount() ? null : new ResourceAmount((Object)((ItemVariant)this.stored.resource()), this.stored.amount() - forwarded);
            transaction.commit();
        }
    }

    public long forwardItem(ResourceAmount<ItemVariant> amount, TransactionContext transaction) {
        return this.forwardItem(new ItemInPipe(amount, this.field_11863.method_8510()), transaction);
    }

    public long forwardItem(ItemInPipe item, TransactionContext transaction) {
        Storage<ItemVariant> storage;
        class_2350 facing = (class_2350)this.method_11010().method_11654((class_2769)ItemPumpBlock.field_10927);
        if (this.insertionCache != null && (storage = this.insertionCache.find()) != null) {
            Transaction nested = transaction.openNested();
            long transferred = storage.insert((Object)item.resource(), item.amount(), (TransactionContext)nested);
            nested.commit();
            return transferred;
        }
        return ItemPipeUtil.EjectOperation.of(this.field_11863, this.method_11016(), facing, this.rememberer).useRouting(true).pipeToAny(item, transaction).amount();
    }

    public long forwardToEntity(ResourceAmount<ItemVariant> resource, Transaction transaction) {
        class_2338 pos1 = this.method_11016().method_10093((class_2350)this.method_11010().method_11654((class_2769)EjectorBlock.field_10927));
        class_238 toBox = class_238.method_30048((class_243)class_243.method_24953((class_2382)pos1), (double)1.0, (double)1.0, (double)1.0);
        class_243 centre = class_243.method_24953((class_2382)pos1);
        List toMinecarts = this.field_11863.method_18023(class_5575.method_31795(class_1693.class), toBox, entity -> true);
        class_1693 minecart = (class_1693)MiscUtil.closestEntity(toMinecarts, centre);
        if (minecart != null) {
            InventoryStorage storage = InventoryStorage.of((class_1263)minecart, null);
            return storage.insert((Object)((ItemVariant)resource.resource()), resource.amount(), (TransactionContext)transaction);
        }
        return 0L;
    }

    public void succeed() {
        this.shuttle = 3;
        this.sync();
    }

    public void changeMode() {
        this.activeWithoutRedstone = !this.activeWithoutRedstone;
        this.updatePowered(this.method_10997().method_8479(this.field_11867));
        this.method_5431();
    }

    public void updatePowered(boolean powered) {
        boolean active = powered != this.activeWithoutRedstone;
        class_2680 newState = (class_2680)this.method_11010().method_11657((class_2769)PumpBlock.ACTIVE, (Comparable)Boolean.valueOf(active));
        this.field_11863.method_8501(this.field_11867, newState);
    }
}

