/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.transport.blood_network;

import com.neep.neepmeat.api.processing.PowerUtils;
import com.neep.neepmeat.transport.api.pipe.BalancingBloodAcceptor;
import com.neep.neepmeat.transport.api.pipe.BloodAcceptor;
import com.neep.neepmeat.transport.api.pipe.VascularConduit;
import com.neep.neepmeat.transport.api.pipe.VascularConduitEntity;
import com.neep.neepmeat.transport.blood_network.BloodNetGraph;
import com.neep.neepmeat.transport.blood_network.BloodNetwork;
import com.neep.neepmeat.transport.blood_network.PosDirectionMap;
import com.neep.neepmeat.transport.blood_network.SortedPosDirectionMap;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import org.apache.commons.lang3.NotImplementedException;
import org.jetbrains.annotations.Nullable;

public class ConduitBloodNetwork
implements BloodNetwork {
    protected final class_3218 world;
    protected final UUID uuid;
    protected final BloodNetGraph conduits;
    protected AcceptorManager acceptors = new AcceptorManager(this);
    protected boolean updateSinks = false;
    protected long stored = 0L;
    protected long lastInternal = 0L;
    protected boolean removed = false;
    protected boolean dirty = false;

    public ConduitBloodNetwork(UUID uuid, class_3218 world) {
        this.uuid = uuid;
        this.world = world;
        this.conduits = new BloodNetGraph((class_1937)world, this.acceptors);
    }

    protected boolean validate() {
        if (this.conduits.isEmpty()) {
            this.conduits.clear();
            this.acceptors.clear();
            this.removed = true;
            return false;
        }
        return true;
    }

    @Override
    public void rebuild(class_2338 pos, VascularConduitEntity.UpdateReason reason) {
        this.conduits.getConduits().values().forEach(c -> c.setNetwork(null));
        this.acceptors.stream().forEach(this::removeAcceptor);
        this.acceptors.clear();
        this.updateSinks = false;
        this.conduits.rebuild(pos);
        if (!this.validate()) {
            return;
        }
        this.conduits.getConduits().values().forEach(c -> c.setNetwork(this));
        this.dirty = true;
    }

    @Override
    public void tick() {
        long internal = 0L;
        if (this.acceptors.sort) {
            this.acceptors.sort();
        }
        Iterator it = this.acceptors.sources().iterator();
        while (it.hasNext()) {
            BloodAcceptor acceptor = (BloodAcceptor)it.next();
            internal += acceptor.getOutput();
        }
        for (BalancingBloodAcceptor balancer : this.acceptors.balancers().asList()) {
            internal += balancer.update(internal);
        }
        int size = this.acceptors.sinks().asList().size();
        if (internal != this.lastInternal) {
            this.updateSinks = true;
            this.lastInternal = internal;
        }
        if (this.updateSinks) {
            float outputPU = (float)internal / (float)PowerUtils.referencePower();
            for (BloodAcceptor consumer : this.acceptors.activeSinks().asList()) {
                float inserted = consumer.updateInflux(outputPU);
                outputPU = Math.max(0.0f, outputPU - inserted);
            }
            float perSink = size != 0 ? outputPU / (float)size : 0.0f;
            for (BloodAcceptor sink : this.acceptors.sinks().asList()) {
                sink.updateInflux(perSink);
            }
            this.updateSinks = false;
        }
    }

    @Override
    public void updateTransfer(@Nullable BloodAcceptor changed) {
        this.updateSinks = true;
    }

    @Override
    public void add(class_2338 pos, VascularConduitEntity newPart) {
        this.insert(pos.method_10063(), newPart);
    }

    @Override
    public void insert(Collection<VascularConduitEntity> pipes) {
        pipes.forEach(p -> {
            this.conduits.insert(p.getBlockPos().method_10063(), (VascularConduitEntity)p);
            p.setNetwork(this);
        });
    }

    public void insert(long pos, VascularConduitEntity newPart) {
        this.conduits.insert(pos, newPart);
        newPart.setNetwork(this);
        this.updateSinks = true;
        this.dirty = true;
    }

    @Override
    public void remove(class_2338 pos, VascularConduitEntity part) {
        this.acceptors.get(pos).forEach(this::removeAcceptor);
        this.acceptors.remove(pos);
        this.conduits.remove(pos.method_10063());
        this.updateSinks = true;
        this.validate();
        this.dirty = true;
    }

    @Override
    public void unload(class_2338 pos, VascularConduitEntity part) {
        this.acceptors.remove(pos);
        this.conduits.remove(pos.method_10063());
    }

    @Override
    public void update(class_2338 pos, VascularConduitEntity part) {
        this.acceptors.get(pos).forEach(this::removeAcceptor);
        this.acceptors.remove(pos);
        this.conduits.remove(pos.method_10063());
        this.conduits.insert(pos.method_10063(), part);
        this.updateSinks = true;
        this.validate();
        this.dirty = true;
    }

    private void removeAcceptor(BloodAcceptor acceptor) {
        if (acceptor == null) {
            return;
        }
        acceptor.updateInflux(0.0f);
        acceptor.setChangeListener(null);
    }

    @Override
    public void mergeInto(BloodNetwork network) {
        if (!(network instanceof ConduitBloodNetwork)) {
            throw new NotImplementedException();
        }
        ConduitBloodNetwork other = (ConduitBloodNetwork)network;
        this.conduits.getConduits().forEach(other::insert);
        this.acceptors.mergeInto(other.acceptors);
        this.conduits.clear();
        this.acceptors.clear();
        this.removed = true;
    }

    @Override
    public void merge(List<BloodNetwork> adjNetworks) {
        for (BloodNetwork network : adjNetworks) {
            if (network == this) continue;
            network.mergeInto(this);
        }
        this.acceptors.sort();
        this.updateSinks = true;
        this.dirty = true;
    }

    @Override
    public boolean isRemoved() {
        return this.removed;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void resetDirty() {
        this.dirty = false;
    }

    @Override
    public UUID getUUID() {
        return this.uuid;
    }

    protected class AcceptorManager {
        private final ConduitBloodNetwork network;
        protected PosDirectionMap<BloodAcceptor> acceptors = new PosDirectionMap<BloodAcceptor>(BloodAcceptor.class);
        protected PosDirectionMap<BloodAcceptor> sources = new PosDirectionMap<BloodAcceptor>(BloodAcceptor.class);
        protected PosDirectionMap<BloodAcceptor> sinks = new PosDirectionMap<BloodAcceptor>(BloodAcceptor.class);
        protected PosDirectionMap<BloodAcceptor> activeSinks = new PosDirectionMap<BloodAcceptor>(BloodAcceptor.class);
        protected PosDirectionMap<BalancingBloodAcceptor> balancers = new SortedPosDirectionMap<BalancingBloodAcceptor>(BalancingBloodAcceptor.class, Comparator.comparingInt(BalancingBloodAcceptor::priority).reversed());
        public boolean sort = false;

        public AcceptorManager(ConduitBloodNetwork network) {
            this.network = network;
        }

        public void discover(class_1937 world, class_2338 pos, class_2680 state, VascularConduit conduit) {
            class_2338.class_2339 mutable = pos.method_25503();
            for (class_2350 direction : class_2350.values()) {
                if (!conduit.isConnectedIn((class_1922)world, pos, state, direction)) continue;
                mutable.method_25505((class_2382)pos, direction);
                BloodAcceptor acceptor = (BloodAcceptor)BloodAcceptor.SIDED.find(world, (class_2338)mutable, (Object)direction.method_10153());
                if (acceptor == null) continue;
                this.add(pos.method_10063(), direction.method_10146(), acceptor);
                ConduitBloodNetwork.this.updateSinks = true;
            }
        }

        public Iterable<BloodAcceptor> get(class_2338 pos) {
            return this.acceptors.get(pos.method_10063());
        }

        public Stream<BloodAcceptor> stream() {
            return this.acceptors.flatStream();
        }

        public void mergeInto(AcceptorManager other) {
            this.acceptors.fastForEach(entry -> {
                for (int dir = 0; dir < 6; ++dir) {
                    BloodAcceptor[] a = (BloodAcceptor[])entry.getValue();
                    if (a[dir] != null) {
                        a[dir].setChangeListener(other.network);
                    }
                    other.acceptors.put(entry.getLongKey(), dir, a[dir]);
                }
            });
            this.clear();
            other.sort = true;
        }

        public void add(long pos, int dir, BloodAcceptor acceptor) {
            this.acceptors.put(pos, dir, acceptor);
            acceptor.setChangeListener(ConduitBloodNetwork.this);
            this.sortAcceptor(pos, dir, acceptor);
        }

        public void sort() {
            this.sources.clear();
            this.sinks.clear();
            this.activeSinks.clear();
            this.balancers.clear();
            this.acceptors.fastForEach(entry -> {
                for (int dir = 0; dir < 6; ++dir) {
                    BloodAcceptor acceptor = ((BloodAcceptor[])entry.getValue())[dir];
                    if (acceptor == null) continue;
                    long pos = entry.getLongKey();
                    this.sortAcceptor(pos, dir, acceptor);
                }
            });
            this.sort = false;
        }

        private void sortAcceptor(long pos, int dir, BloodAcceptor acceptor) {
            switch (acceptor.getMode()) {
                case SOURCE: {
                    this.sources.put(pos, dir, acceptor);
                    break;
                }
                case SINK: {
                    this.sinks.put(pos, dir, acceptor);
                    break;
                }
                case ACTIVE_SINK: {
                    this.activeSinks.put(pos, dir, acceptor);
                    break;
                }
                case BALANCE: {
                    this.balancers.put(pos, dir, (BalancingBloodAcceptor)acceptor);
                }
            }
        }

        public void remove(class_2338 pos) {
            long lpos = pos.method_10063();
            this.acceptors.remove(lpos);
            this.sources.remove(lpos);
            this.sinks.remove(lpos);
            this.activeSinks.remove(lpos);
            this.balancers.remove(lpos);
        }

        public void clear() {
            this.acceptors.clear();
            this.sources.clear();
            this.sinks.clear();
            this.activeSinks.clear();
            this.balancers.clear();
        }

        public Stream<BloodAcceptor> sources() {
            return this.sources.flatStream();
        }

        public PosDirectionMap<BloodAcceptor> sinks() {
            return this.sinks;
        }

        public PosDirectionMap<BloodAcceptor> activeSinks() {
            return this.activeSinks;
        }

        public PosDirectionMap<BalancingBloodAcceptor> balancers() {
            return this.balancers;
        }
    }
}

