/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.transport.client.screen.filter;

import com.neep.meatlib.client.screen.auto.Panel;
import com.neep.meatlib.client.screen.primitive.Rectangle;
import com.neep.neepmeat.api.plc.PLCCols;
import com.neep.neepmeat.client.screen.util.BorderScrollRight;
import com.neep.neepmeat.item.filter.Filter;
import com.neep.neepmeat.item.filter.FilterList;
import com.neep.neepmeat.item.filter.ItemFilter;
import com.neep.neepmeat.item.filter.TagFilter;
import com.neep.neepmeat.transport.client.screen.filter.EmptyFilterWidget;
import com.neep.neepmeat.transport.client.screen.filter.FilterEntryWidget;
import com.neep.neepmeat.transport.client.screen.filter.ItemFilterWidget;
import com.neep.neepmeat.transport.client.screen.filter.TagFilterWidget;
import com.neep.neepmeat.transport.screen.FilterWidgetHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_1799;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4587;

public class FilterPanel
extends Panel {
    private final FilterWidgetHandler handler;
    private final Supplier<class_1799> cursorStack;
    private final List<FilterEntryWidget<?>> entries = new ArrayList();
    private float scroll;
    private BorderScrollRight entriesBorder;

    public FilterPanel(FilterWidgetHandler handler, Supplier<class_1799> cursorStack) {
        this.handler = handler;
        this.cursorStack = cursorStack;
        handler.updateToClient.receiver(this::updateOnClient);
    }

    @Override
    public void init() {
        Rectangle.Immutable entriesBounds = new Rectangle.Immutable(this.x(), this.y(), this.w(), this.h());
        this.entriesBorder = new BorderScrollRight(entriesBounds, 0, () -> PLCCols.BORDER.col);
        this.createEntries();
    }

    private void createEntries() {
        FilterList filters = this.handler.getFilters();
        int yOff = (int)((float)this.entriesBorder.y() + this.scroll) + 2;
        int xOff = this.entriesBorder.x() + 2;
        for (int i = 0; i < filters.size(); ++i) {
            FilterEntryWidget<?> widget;
            FilterList.Entry entry2 = filters.getEntries().get(i);
            Filter filter = entry2.getFilter();
            if (i < this.entries.size() && this.entries.get((int)i).filter.getType() != filter.getType()) {
                widget = this.createWidget(i, entry2);
                this.entries.set(i, widget);
                widget.init();
            } else if (i == this.entries.size()) {
                widget = this.createWidget(i, entry2);
                this.entries.add(i, widget);
                widget.init();
            } else {
                widget = this.entries.get(i);
                widget.updateFilter(entry2);
            }
            widget.setPos(xOff, yOff);
            yOff += widget.h() - 1;
        }
        this.entries.removeIf(entry -> entry.index >= filters.size());
    }

    private FilterEntryWidget<?> createWidget(int index, FilterList.Entry entry) {
        int w = this.entriesBorder.w() - 4;
        Filter filter = entry.getFilter();
        if (filter instanceof ItemFilter) {
            ItemFilter itemFilter = (ItemFilter)filter;
            return new ItemFilterWidget(w, index, entry, itemFilter, this.handler, this.cursorStack);
        }
        filter = entry.getFilter();
        if (filter instanceof TagFilter) {
            TagFilter tagFilter = (TagFilter)filter;
            return new TagFilterWidget(w, index, entry, tagFilter, this.handler);
        }
        return new EmptyFilterWidget(w, index, this.handler);
    }

    @Override
    protected List<class_4068> drawables() {
        return List.of();
    }

    @Override
    public List<class_364> method_25396() {
        return List.of();
    }

    private float maxScroll() {
        return -100.0f;
    }

    public void updateOnClient(FilterList filter) {
        this.handler.updateOnClient(filter);
        this.createEntries();
    }

    @Override
    public void method_25394(class_4587 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        this.entriesBorder.render(context, mouseX, mouseY, delta, this.scroll / this.maxScroll());
        FilterPanel.method_44379((int)this.entriesBorder.x(), (int)(this.entriesBorder.y() + 2), (int)(this.entriesBorder.x() + this.entriesBorder.w()), (int)(this.entriesBorder.y() + this.entriesBorder.h() - 2));
        for (FilterEntryWidget<?> entry : this.entries) {
            entry.method_25394(context, mouseX, mouseY, delta);
        }
        FilterPanel.method_44380();
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        for (FilterEntryWidget<?> entry : this.entries) {
            if (!entry.method_25402(mouseX, mouseY, button)) continue;
            this.method_25395(entry);
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 261) {
            for (FilterEntryWidget<?> entry : this.entries) {
                if (!entry.isFocused()) continue;
                this.handler.removeFilter.emitter().apply(entry.index);
            }
        }
        for (FilterEntryWidget<?> entry : this.entries) {
            if (!entry.method_25404(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        return false;
    }

    public boolean method_25400(char chr, int modifiers) {
        for (FilterEntryWidget<?> entry : this.entries) {
            if (!entry.method_25400(chr, modifiers)) continue;
            return true;
        }
        return super.method_25400(chr, modifiers);
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        this.scroll = (float)class_3532.method_15350((double)((double)this.scroll + amount * 2.0), (double)this.maxScroll(), (double)0.0);
        int yOff = (int)((float)this.entriesBorder.y() + this.scroll) + 2;
        int xOff = this.entriesBorder.x() + 2;
        for (FilterEntryWidget<?> entry : this.entries) {
            entry.setPos(xOff, yOff);
            yOff += entry.h() - 1;
        }
        return true;
    }
}

