/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.transport.util;

import com.google.common.collect.Iterables;
import com.neep.neepmeat.transport.api.pipe.ItemPipe;
import com.neep.neepmeat.transport.api.pipe.PipeConnections;
import com.neep.neepmeat.transport.block.item_transport.entity.ItemPipeBlockEntity;
import com.neep.neepmeat.transport.block.item_transport.machine.ItemPumpBlock;
import com.neep.neepmeat.transport.block.item_transport.machine.PipeItemMemory;
import com.neep.neepmeat.transport.item_network.ItemInPipe;
import com.neep.neepmeat.transport.item_network.PipeRouteFinder;
import com.neep.neepmeat.transport.item_network.RetrievalTarget;
import com.neep.neepmeat.transport.item_network.ShittyRoutingListener;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiCache;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiLookup;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.base.ResourceAmount;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class ItemPipeUtil {
    public static boolean storageToAny(class_3218 world, Storage<ItemVariant> storage, class_2338 pos, class_2350 facing, TransactionContext transaction) {
        for (StorageView view : storage) {
            Transaction inner = transaction.openNested();
            try {
                long extracted;
                if (view.isResourceBlank()) {
                    inner.abort();
                    continue;
                }
                long ejected = EjectOperation.of((class_1937)world, pos, facing).stackToAny((ItemVariant)view.getResource(), view.getAmount(), (TransactionContext)inner).amount();
                if (ejected == (extracted = view.extract((Object)((ItemVariant)view.getResource()), ejected, (TransactionContext)inner))) {
                    inner.commit();
                    boolean bl = ejected != 0L;
                    return bl;
                }
                inner.abort();
            }
            finally {
                if (inner == null) continue;
                inner.close();
            }
        }
        return false;
    }

    public static long itemToStorage(ItemInPipe item, Storage<ItemVariant> storage, TransactionContext transaction) {
        try (Transaction nested = transaction.openNested();){
            long transferred = storage.insert((Object)item.resource(), item.amount(), (TransactionContext)nested);
            if (transferred > 0L) {
                nested.commit();
                item.decrement((int)transferred);
                long l = transferred;
                return l;
            }
            nested.abort();
        }
        return 0L;
    }

    public static long itemToWorld(ItemInPipe item, double offset, float speed, class_1937 world, class_2338 toPos, class_2350 out, TransactionContext transaction) {
        transaction.addOuterCloseCallback(r -> {
            if (!r.wasCommitted()) {
                return;
            }
            class_1799 stack = item.toItemStack();
            item.zero();
            class_1542 itemEntity = new class_1542(world, (double)toPos.method_10263() + 0.5 - offset * (double)out.method_10148(), (double)toPos.method_10264() + 0.2 - offset * (double)out.method_10164(), (double)toPos.method_10260() + 0.5 - offset * (double)out.method_10165(), stack, (double)((float)out.method_10148() * speed), (double)((float)out.method_10164() * speed), (double)((float)out.method_10165() * speed));
            world.method_8649((class_1297)itemEntity);
        });
        return item.amount();
    }

    public static long itemToPipe(ItemInPipe item, ItemPipe pipe, class_3218 world, class_2338 toPos, class_2680 toState, class_2350 out, @Nullable PipeRouteFinder pathfinding, @Nullable PipeItemMemory memory, Predicate<Storage<ItemVariant>> exclude, TransactionContext transaction) {
        long amountInserted = 0L;
        long maxAmount = item.amount();
        if (pipe.canItemEnter(item.resource(), item.amount(), (class_1937)world, toPos, toState, out.method_10153())) {
            if (pathfinding != null) {
                PipeRouteFinder.Operation result = pathfinding.run(item.toResourceAmount(), exclude, out.method_10153(), transaction);
                if (memory != null) {
                    int memoryAmount = memory.get(item.resource());
                    maxAmount = Math.min(maxAmount, result.maxAmount() - (long)memoryAmount);
                } else {
                    maxAmount = Math.min(maxAmount, result.maxAmount());
                }
            }
            if (maxAmount != 0L) {
                ItemInPipe newItem = item.split((int)maxAmount);
                if (memory != null) {
                    memory.register(newItem);
                }
                amountInserted = pipe.insert((class_1937)world, toPos, toState, out.method_10153(), newItem, transaction);
            }
        }
        return amountInserted;
    }

    public static long itemToPipe(ItemInPipe item, ItemPipe pipe, class_3218 world, class_2338 toPos, class_2680 toState, class_2350 out, TransactionContext transaction) {
        long amountInserted = 0L;
        long maxAmount = item.amount();
        if (pipe.canItemEnter(item.resource(), item.amount(), (class_1937)world, toPos, toState, out.method_10153()) && maxAmount != 0L) {
            ItemInPipe newItem = item.split((int)maxAmount);
            amountInserted = pipe.insert((class_1937)world, toPos, toState, out.method_10153(), newItem, transaction);
        }
        return amountInserted;
    }

    public static void bounce(ItemInPipe item, class_1937 world, class_2680 state) {
        class_2350 in = item.out;
        PipeConnections connections = ((ItemPipe)state.method_26204()).getConnections(state, in);
        class_5819 rand = world.method_8409();
        class_2350 out = !connections.isEmpty() ? (class_2350)Iterables.get((Iterable)connections, (int)rand.method_43048(connections.size())) : in;
        item.reset(in, out, world.method_8510());
    }

    public static List<RetrievalTarget<ItemVariant>> floodSearch(ShittyRoutingListener listener, class_2338 startPos, class_2350 face, class_1937 world, int depth) {
        ArrayDeque<Object> pipeQueue = new ArrayDeque<Object>();
        ArrayList<class_2338> nextSet = new ArrayList<class_2338>();
        HashSet<class_2338> visited = new HashSet<class_2338>();
        ArrayList<ItemPipeBlockEntity> relevantPipes = new ArrayList<ItemPipeBlockEntity>();
        ArrayList<RetrievalTarget<ItemVariant>> output = new ArrayList<RetrievalTarget<ItemVariant>>();
        pipeQueue.add(startPos.method_10093(face));
        visited.add(startPos.method_10093(face));
        for (int i = 0; i < depth; ++i) {
            nextSet.clear();
            while (!pipeQueue.isEmpty()) {
                class_2338 current = (class_2338)pipeQueue.poll();
                class_2680 currentState = world.method_8320(current);
                class_2586 class_25862 = world.method_8321(current);
                if (class_25862 instanceof ItemPipeBlockEntity) {
                    ItemPipeBlockEntity be = (ItemPipeBlockEntity)class_25862;
                    relevantPipes.add(be);
                }
                for (class_2350 direction : class_2350.values()) {
                    class_2338 next = current.method_10093(direction);
                    class_2680 nextState = world.method_8320(next);
                    if (!ItemPipe.isConnectedIn(world, current, currentState, direction) || visited.contains(next)) continue;
                    visited.add(next);
                    if (nextState.method_26204() instanceof ItemPipe && !(nextState.method_26204() instanceof ItemPumpBlock) && ItemPipe.isConnectedIn(world, next, nextState, direction.method_10153())) {
                        nextSet.add(next);
                    }
                    if (ItemStorage.SIDED.find(world, next, (Object)direction.method_10153()) == null) continue;
                    BlockApiCache cache = BlockApiCache.create((BlockApiLookup)ItemStorage.SIDED, (class_3218)((class_3218)world), (class_2338)next);
                    output.add(new RetrievalTarget(cache, direction.method_10153()));
                }
            }
            pipeQueue.addAll(nextSet);
        }
        for (ItemPipeBlockEntity pipe : relevantPipes) {
            pipe.getCallbacks().addListener(listener);
        }
        return output;
    }

    public static boolean canDumpInto(class_1937 world, class_2338 pos, class_2680 state) {
        return state.method_26215() || !state.method_26227().method_15769();
    }

    public static class EjectOperation {
        private final class_3218 world;
        private final class_2338 pos;
        private final class_2350 out;
        @Nullable
        private final PipeItemMemory memory;
        private PipeRouteFinder pathfinding;
        private final Predicate<Storage<ItemVariant>> exclude = s -> true;
        private long amount = 0L;

        public static EjectOperation of(class_1937 world, class_2338 pos, class_2350 out, @Nullable PipeItemMemory memory) {
            return new EjectOperation(world, pos, out, memory);
        }

        public static EjectOperation of(class_1937 world, class_2338 pos, class_2350 out) {
            return EjectOperation.of(world, pos, out, null);
        }

        private EjectOperation(class_1937 world, class_2338 pos, class_2350 out, @Nullable PipeItemMemory memory) {
            this.world = (class_3218)world;
            this.pos = pos;
            this.out = out;
            this.memory = memory;
            this.pathfinding = new PipeRouteFinder(this.world, pos.method_10093(out));
        }

        public EjectOperation useRouting(boolean route) {
            this.pathfinding = !route ? null : new PipeRouteFinder(this.world, this.pos.method_10093(this.out));
            return this;
        }

        public EjectOperation pipeToAny(ItemInPipe item, TransactionContext transaction) {
            this.amount = this.pipeToAnyInternal(item, transaction);
            return this;
        }

        public EjectOperation stackToAny(ItemVariant resource, long amount, TransactionContext transaction) {
            this.amount = this.stackToAnyInternal(resource, amount, transaction);
            return this;
        }

        public long amount() {
            return this.amount;
        }

        private long pipeToAnyInternal(ItemInPipe item, TransactionContext transaction) {
            class_2338 toPos = this.pos.method_10093(this.out);
            class_2680 toState = this.world.method_8320(toPos);
            class_2248 toBlock = toState.method_26204();
            long amountInserted = 0L;
            if (toBlock instanceof ItemPipe) {
                ItemPipe pipe = (ItemPipe)toBlock;
                amountInserted = ItemPipeUtil.itemToPipe(item, pipe, this.world, toPos, toState, this.out, this.pathfinding, this.memory, this.exclude, transaction);
            } else if (ItemPipeUtil.canDumpInto((class_1937)this.world, toPos, toState)) {
                amountInserted = ItemPipeUtil.itemToWorld(item, 0.2, item.speed, (class_1937)this.world, toPos, this.out, transaction);
            } else {
                Storage storage = (Storage)ItemStorage.SIDED.find((class_1937)this.world, toPos, (Object)this.out.method_10153());
                if (storage != null) {
                    amountInserted = ItemPipeUtil.itemToStorage(item, (Storage<ItemVariant>)storage, transaction);
                }
            }
            if (amountInserted != item.amount()) {
                item.decrement((int)amountInserted);
            }
            return amountInserted;
        }

        private int stackToAnyInternal(ItemVariant variant, long amount, TransactionContext transaction) {
            if (variant.isBlank() || amount == 0L) {
                return 0;
            }
            class_2338 offset = this.pos.method_10093(this.out);
            class_2680 facingState = this.world.method_8320(offset);
            long transferred = 0L;
            try (Transaction nested = transaction.openNested();){
                if (ItemPipeUtil.canDumpInto((class_1937)this.world, offset, facingState)) {
                    transferred = ItemPipeUtil.itemToWorld(new ItemInPipe(variant, (int)amount), 0.2, 0.05f, (class_1937)this.world, offset, this.out, (TransactionContext)nested);
                    nested.commit();
                } else {
                    class_2248 class_22482 = facingState.method_26204();
                    if (class_22482 instanceof ItemPipe) {
                        ItemPipe itemPipe = (ItemPipe)class_22482;
                        transferred = ItemPipeUtil.itemToPipe(new ItemInPipe((ResourceAmount<ItemVariant>)new ResourceAmount((Object)variant, amount), this.world.method_8510()), itemPipe, this.world, offset, facingState, this.out, this.pathfinding, this.memory, this.exclude, (TransactionContext)nested);
                        nested.commit();
                    } else {
                        Storage storage = (Storage)ItemStorage.SIDED.find((class_1937)this.world, offset, (Object)this.out.method_10153());
                        if (storage != null) {
                            transferred = storage.insert((Object)variant, amount, (TransactionContext)nested);
                            nested.commit();
                        } else {
                            nested.abort();
                        }
                    }
                }
            }
            return (int)transferred;
        }
    }
}

