/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.util;

import com.neep.meatweapons.mixin.BoxMixin;
import com.neep.neepmeat.transport.fluid_network.node.FluidNode;
import com.neep.neepmeat.util.NMVec2f;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;

public class NMMaths {
    public static boolean isWithin(float value, float target, float difference) {
        return Math.abs(target - value) < difference;
    }

    public static NMVec2f removeAxis(class_2350.class_2351 axis, class_243 vec) {
        return switch (axis) {
            case class_2350.class_2351.field_11048 -> new NMVec2f((float)vec.method_10214(), (float)vec.method_10215());
            case class_2350.class_2351.field_11052 -> new NMVec2f((float)vec.method_10216(), (float)vec.method_10215());
            case class_2350.class_2351.field_11051 -> new NMVec2f((float)vec.method_10216(), (float)vec.method_10214());
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(axis));
        };
    }

    public static class_2350 swapDirections(class_2350 direction) {
        switch (direction) {
            case field_11036: {
                return class_2350.field_11034;
            }
            case field_11033: {
                return class_2350.field_11039;
            }
            case field_11034: {
                return class_2350.field_11033;
            }
            case field_11039: {
                return class_2350.field_11036;
            }
        }
        throw new IllegalStateException("Unable to get X-rotated facing of " + String.valueOf(direction));
    }

    public static double manhattanDistance(class_243 v1, class_243 v2) {
        double d = Math.abs(v2.field_1352 - v1.field_1352);
        double e = Math.abs(v2.field_1351 - v1.field_1351);
        double f = Math.abs(v2.field_1350 - v1.field_1350);
        return d + e + f;
    }

    public static class_241 flattenY(class_243 vec) {
        return new class_241((float)vec.method_10216(), (float)vec.method_10215());
    }

    public static float getAngle(class_243 v1, class_243 v2) {
        return (float)Math.acos(v1.method_1026(v2) / (v1.method_1033() * v2.method_1033()));
    }

    public static float getAngle(class_241 v1) {
        return (float)((double)((float)Math.atan2(v1.field_1343, v1.field_1342)) + Math.PI);
    }

    public static float angleLerp(float delta, float x1, float x2) {
        float CS = (1.0f - delta) * class_3532.method_15362((float)x1) + delta * class_3532.method_15362((float)x2);
        float SN = (1.0f - delta) * class_3532.method_15374((float)x1) + delta * class_3532.method_15374((float)x2);
        double C = class_3532.method_15349((double)SN, (double)CS);
        return (float)C;
    }

    public static float lerpForwards(float dist, float current, float next) {
        float delta = dist * (next - current);
        if (delta < 0.0f) {
            return next;
        }
        return current + delta;
    }

    public static int wrap(int value, int min, int max) {
        if (value >= min && value < max) {
            return value;
        }
        int t = value - min;
        int s = max - min + 1;
        if (s <= 0) {
            return min;
        }
        if ((t %= s) < 0) {
            t += s;
        }
        return min + t;
    }

    public static float wrapDegreesPositive(float degrees) {
        float f = degrees % 360.0f;
        if (f < 0.0f) {
            f += 360.0f;
        }
        return f;
    }

    public static double exactDistance(FluidNode node1, FluidNode node2) {
        class_243 offset1 = new class_243(node1.getNodePos().face().method_23955()).method_1021(0.5);
        class_243 v1 = class_243.method_24953((class_2382)node1.getNodePos().pos()).method_1019(offset1);
        class_243 offset2 = new class_243(node2.getNodePos().face().method_23955()).method_1021(0.5);
        class_243 v2 = class_243.method_24953((class_2382)node2.getNodePos().pos()).method_1019(offset2);
        return NMMaths.manhattanDistance(v1, v2);
    }

    public static class_241 rectToPol(double u, double v, double w) {
        float xz = (float)Math.sqrt(w * w + u * u);
        return new class_241((float)Math.toDegrees(Math.atan(-v / (double)xz)), (float)Math.toDegrees(Math.atan2(-u, w)));
    }

    public static class_241 rectToPol(class_243 vec) {
        return NMMaths.rectToPol(vec.field_1352, vec.field_1351, vec.field_1350);
    }

    public static float sin(long time, float tickDelta, float timeFactor) {
        return (float)Math.sin(((double)time + (double)tickDelta) * (double)timeFactor);
    }

    public static long wrapDegrees(long degrees) {
        long l = degrees % 360L;
        if (l >= 180L) {
            l -= 360L;
        }
        if (l < -180L) {
            l += 360L;
        }
        return l;
    }

    public static int wrapIndex(int idx, int length) {
        if ((idx %= length) < 0) {
            return length + idx % length;
        }
        return idx;
    }

    @Nullable
    public static class_243 raycast(class_238 box, class_243 min, class_243 max) {
        double[] ds = new double[]{1.0};
        double d = max.field_1352 - min.field_1352;
        double e = max.field_1351 - min.field_1351;
        double f = max.field_1350 - min.field_1350;
        class_2350 direction = BoxMixin.traceCollisionSide(box, min, ds, null, d, e, f);
        if (direction == null) {
            if (box.method_1006(min)) {
                return min;
            }
            return null;
        }
        double g = ds[0];
        return min.method_1031(g * d, g * e, g * f);
    }

    public static class_243 getRotationVector(double pitchRad, double yawRad) {
        float f = (float)pitchRad;
        float g = (float)(-yawRad);
        float h = class_3532.method_15362((float)g);
        float i = class_3532.method_15374((float)g);
        float j = class_3532.method_15362((float)f);
        float k = class_3532.method_15374((float)f);
        return new class_243((double)(i * j), (double)(-k), (double)(h * j));
    }

    public static float inverseSqrt(float r) {
        return 1.0f / (float)Math.sqrt(r);
    }

    public static int clamp(int value, int min, int max) {
        return Math.min(Math.max(value, min), max);
    }

    public static double distance2D(double x0, double y0, double x1, double y1) {
        double dx = x1 - x0;
        double dy = y1 - y0;
        return Math.sqrt(dx * dx + dy * dy);
    }

    public static float wrapRadians(float radians) {
        return radians - (float)Math.PI * 2 * (float)class_3532.method_15357((double)(((double)radians + Math.PI) / 6.2831854820251465));
    }

    public static float moveTowards(float current, float target, float speed) {
        float difference = target - current;
        if (Math.abs(difference) > 0.0f) {
            return current + Math.signum(difference) * Math.min(speed, Math.abs(difference));
        }
        return target;
    }

    public static float deltaAngle(float radians1, float radians2) {
        float diff = (radians2 - radians1 + (float)Math.PI) % ((float)Math.PI * 2) - (float)Math.PI;
        return diff < (float)(-Math.PI) ? diff + (float)Math.PI * 2 : diff;
    }

    public static float moveTowardsAngle(float current, float target, float speed) {
        float difference = NMMaths.deltaAngle(current, target);
        if (Math.abs(difference) > 1.0E-5f) {
            return current + Math.signum(difference) * Math.min(speed, Math.abs(difference));
        }
        return target;
    }
}

