---
id: pid_controller
---
# 比例-积分-微分控制器

比例-积分-微分（PID）控制器是一类NEEP总线机器，可用作动态系统的离散时间反馈控制器。

本质上来说，它会更改*PID输出量*，力求让输入的*测量值*信号尽可能靠近输入的*目标值*信号。

### 端口

输入：
- 测量值（Measurement）
- 目标值（Setpoint）

输出：
- PID输出量（PID Output）

## 描述

PID控制器每*dt*刻进行更新，此值由*更新时间间隔*（*Loop time interval*）参数控制。

如方块图中所示，PID控制器会读取*测量值*和*目标值*端口，并计算*目标值*与*测量值*的差，得到误差信号。所得误差信号会分别传入比例、积分、微分单元，并根据各单元可调增益进行调整。三个单元的加权和会发至输出端口。

## 用途

PID控制器所控制的对象称作“受控体”（Plant）。

如方块图中所示，测量值输入信号应当由受控体输出端口提供，控制器的输出信号则应送至受控体的输入端口，建立反馈回路。

### kp

*kp*是比例单元的增益。

将*ki*和*kd*均设为零，即变成简单的比例增益控制器。

### ki

*ki*是积分单元的增益，积分单元的输出就是过往所有误差的总和。

若目标值剧烈变动，积分单元可能会积累到很大的误差。可通过饱和上限参数限制积分单元的绝对值，以控制此误差。

### kd

*kd*是微分单元的增益，微分单元的输出就是过往误差的变化率。

增大*kd*后输入值变动时受到的阻碍会更大，相当于为系统加上了阻尼。

此数据可用来减少振荡，或是降低系统的变化率。

## 方块图

\image[width=256,height=128,scale=0.9]{neepmeat:guide/images/pid_block_diagram.png}
