/*
 * Decompiled with CFR 0.152.
 */
package com.neep.meatlib.client.screen.widget;

import com.neep.meatlib.client.screen.primitive.Rectangle;
import com.neep.meatlib.client.screen.widget.AbstractNumberTextField;
import com.neep.neepbus.NeepBus;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_437;

public class FloatNumberTextField
extends AbstractNumberTextField<Float>
implements Rectangle.Mutable {
    private final Consumer<FloatNumberTextField> update;
    private final float min;
    private final float max;
    private final float minIncrement;
    private final float maxIncrement;

    public FloatNumberTextField(class_327 textRenderer, int x, int y, int width, int height, class_2561 prefix, Consumer<FloatNumberTextField> update, float min, float max) {
        this(textRenderer, x, y, width, height, prefix, update, min, max, 1.0f, 16.0f);
    }

    public FloatNumberTextField(class_327 textRenderer, int x, int y, int width, int height, class_2561 prefix, Consumer<FloatNumberTextField> update, float min, float max, float minIncrement, float maxIncrement) {
        super(textRenderer, x, y, width, height, prefix);
        this.update = update;
        this.min = min;
        this.max = max;
        this.minIncrement = minIncrement;
        this.maxIncrement = maxIncrement;
    }

    @Override
    protected void update() {
        this.update.accept(this);
    }

    @Override
    protected boolean isValidString(String text) {
        return text.matches("[+\\-0-9E.]*");
    }

    @Override
    protected String valueToString(Float value) {
        return NeepBus.formatFloat(value.floatValue(), true);
    }

    protected float parseValue(String text) {
        try {
            return class_3532.method_15363((float)Float.parseFloat(text), (float)this.min, (float)this.max);
        }
        catch (NumberFormatException e) {
            return 0.0f;
        }
    }

    private float scrollMultiplier() {
        return class_437.method_25442() ? this.minIncrement : this.maxIncrement;
    }

    @Override
    protected Float applyScroll(String text, double amount) {
        return Float.valueOf(class_3532.method_15363((float)(this.parseValue(text) + (float)amount * this.scrollMultiplier()), (float)this.min, (float)this.max));
    }

    public float parse() {
        return this.parseValue(this.text());
    }
}

