/*
 * Decompiled with CFR 0.152.
 */
package com.neep.meatlib.larkdown.parser;

import com.neep.meatlib.larkdown.LarkdownParser;
import com.neep.meatlib.larkdown.content.TextLarkdownContent;
import com.neep.meatlib.larkdown.parser.Alignment;
import com.neep.meatlib.larkdown.parser.Format;
import com.neep.meatlib.util.StringTokenView;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class TextContentParser
implements LarkdownParser.ContentParser {
    @Override
    public boolean matches(String line) {
        return true;
    }

    @Override
    public void parse(BufferedReader reader, LarkdownParser.ContentAcceptor acceptor) throws IOException {
        String text = reader.readLine();
        if (text.isBlank()) {
            acceptor.accept(new TextLarkdownContent(List.of(new TextLarkdownContent.Entry(" ", Format.NONE)), Alignment.LEFT));
            return;
        }
        StringTokenView view = new StringTokenView(text);
        ObjectArrayList entries = new ObjectArrayList();
        StringBuilder chunk = new StringBuilder();
        do {
            char c;
            for (Format format : Format.values()) {
                if (format.signifier == null) continue;
                boolean matched = true;
                for (int i = 0; i < format.signifier.length(); ++i) {
                    char c2;
                    char c1 = view.peek(i);
                    if (c1 == (c2 = format.signifier.charAt(i))) continue;
                    matched = false;
                    break;
                }
                if (!matched) continue;
                view.next(format.signifier.length());
                String ahead = this.lookAhead(view, format.signifier);
                if (ahead == null) continue;
                entries.add(new TextLarkdownContent.Entry(chunk.toString(), Format.NONE));
                entries.add(new TextLarkdownContent.Entry(ahead, format));
                chunk = new StringBuilder();
                break;
            }
            if ((c = view.peek()) != '\u0000') {
                chunk.append(c);
            }
            view.next();
        } while (!view.eof());
        if (!chunk.isEmpty()) {
            entries.add(new TextLarkdownContent.Entry(chunk.toString(), Format.NONE));
        }
        acceptor.accept(new TextLarkdownContent((List<TextLarkdownContent.Entry>)entries, Alignment.LEFT));
    }

    @Nullable
    private String lookAhead(StringTokenView view, String signifier) {
        StringBuilder sb = new StringBuilder();
        try (StringTokenView.Mark mark = view.mark();){
            do {
                char c;
                if ((c = view.peek()) == signifier.charAt(0)) {
                    boolean matched = true;
                    for (int i = 0; i < signifier.length(); ++i) {
                        char c1 = view.peek(i);
                        if (c1 == signifier.charAt(i)) continue;
                        matched = false;
                    }
                    if (matched) {
                        mark.commit();
                        view.next(signifier.length());
                        String string = sb.toString();
                        return string;
                    }
                }
                sb.append(c);
                view.next();
            } while (!view.eof());
        }
        return null;
    }
}

