/*
 * Decompiled with CFR 0.152.
 */
package com.neep.meatlib.recipe;

import com.neep.meatlib.mixin.RecipeManagerAccessor;
import com.neep.meatlib.recipe.MeatRecipeType;
import com.neep.meatlib.recipe.MeatlibRecipe;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_1263;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.server.MinecraftServer;

public interface MeatlibRecipes {
    public static final MeatlibRecipes EMPTY = new MeatlibRecipes(){

        @Override
        public Optional<? extends MeatlibRecipe<?>> get(class_2960 id) {
            return Optional.empty();
        }

        @Override
        public <C, T extends MeatlibRecipe<C>> Optional<T> get(class_3956<T> type, class_2960 id) {
            return Optional.empty();
        }

        @Override
        public <C extends class_1263, T extends class_1860<C>> Optional<T> getVanilla(class_3956<T> type, class_2960 id) {
            return Optional.empty();
        }

        @Override
        public <C, T extends MeatlibRecipe<C>> Optional<T> getFirstMatch(MeatRecipeType<T> type, C context) {
            return Optional.empty();
        }

        @Override
        public <C, T extends MeatlibRecipe<C>> Map<class_2960, T> getAllOfTypeSafe(MeatRecipeType<T> type) {
            return Map.of();
        }

        @Override
        public <C, T extends MeatlibRecipe<C>> Stream<T> getAllValuesOfType(MeatRecipeType<T> type) {
            return Stream.empty();
        }
    };

    public static void init() {
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            MeatlibRecipesImpl.INSTANCE = new MeatlibRecipesImpl(() -> ((MinecraftServer)server).method_3772());
        });
        ServerLifecycleEvents.SERVER_STOPPED.register(server -> {
            MeatlibRecipesImpl.INSTANCE = EMPTY;
        });
    }

    @Environment(value=EnvType.CLIENT)
    public static void initClient() {
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> {
            if (!client.method_1496()) {
                MeatlibRecipesImpl.INSTANCE = new MeatlibRecipesImpl(() -> client.method_1562().method_2877());
            }
        });
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> {
            if (!client.method_1542()) {
                MeatlibRecipesImpl.INSTANCE = EMPTY;
            }
        });
    }

    public static MeatlibRecipes getInstance() {
        return MeatlibRecipesImpl.INSTANCE;
    }

    public Optional<? extends MeatlibRecipe<?>> get(class_2960 var1);

    public <C, T extends MeatlibRecipe<C>> Optional<T> get(class_3956<T> var1, class_2960 var2);

    public <C extends class_1263, T extends class_1860<C>> Optional<T> getVanilla(class_3956<T> var1, class_2960 var2);

    public <C, T extends MeatlibRecipe<C>> Optional<T> getFirstMatch(MeatRecipeType<T> var1, C var2);

    public <C, T extends MeatlibRecipe<C>> Map<class_2960, T> getAllOfTypeSafe(MeatRecipeType<T> var1);

    public <C, T extends MeatlibRecipe<C>> Stream<T> getAllValuesOfType(MeatRecipeType<T> var1);

    public static class MeatlibRecipesImpl
    implements MeatlibRecipes {
        public static MeatlibRecipes INSTANCE = EMPTY;
        private final Supplier<class_1863> recipeManager;

        private MeatlibRecipesImpl(Supplier<class_1863> recipeManagerSupplier) {
            this.recipeManager = recipeManagerSupplier;
        }

        @Override
        public Optional<? extends MeatlibRecipe<?>> get(class_2960 id) {
            Object t;
            Optional recipe = this.recipeManager.get().method_8130(id);
            if (recipe.isPresent() && (t = recipe.get()) instanceof MeatlibRecipe) {
                MeatlibRecipe mlr = (MeatlibRecipe)t;
                return Optional.of(mlr);
            }
            return Optional.empty();
        }

        @Override
        public <C, T extends MeatlibRecipe<C>> Optional<T> get(class_3956<T> type, class_2960 id) {
            class_1860<?> recipe = ((RecipeManagerAccessor)this.recipeManager.get()).getRecipesById().get(id);
            if (recipe == null || recipe.method_17716() != type) {
                return Optional.empty();
            }
            return Optional.ofNullable((MeatlibRecipe)recipe);
        }

        @Override
        public <C extends class_1263, T extends class_1860<C>> Optional<T> getVanilla(class_3956<T> type, class_2960 id) {
            class_1860<?> recipe = ((RecipeManagerAccessor)this.recipeManager.get()).getRecipesById().get(id);
            if (recipe == null || recipe.method_17716() != type) {
                return Optional.empty();
            }
            return Optional.ofNullable(recipe);
        }

        @Override
        public <C, T extends MeatlibRecipe<C>> Optional<T> getFirstMatch(MeatRecipeType<T> type, C context) {
            return this.getAllValuesOfType(type).flatMap(recipe -> type.match(recipe, context).stream()).findFirst();
        }

        @Override
        public <C, T extends MeatlibRecipe<C>> Map<class_2960, T> getAllOfTypeSafe(MeatRecipeType<T> type) {
            Map map = ((RecipeManagerAccessor)this.recipeManager.get()).getRecipes().getOrDefault(type, Collections.emptyMap());
            return map.entrySet().stream().filter(e -> e.getValue() instanceof MeatlibRecipe).collect(Collectors.toMap(Map.Entry::getKey, e -> (MeatlibRecipe)e.getValue()));
        }

        @Override
        public <C, T extends MeatlibRecipe<C>> Stream<T> getAllValuesOfType(MeatRecipeType<T> type) {
            Map map = ((RecipeManagerAccessor)this.recipeManager.get()).getRecipes().getOrDefault(type, Collections.emptyMap());
            return map.values().stream().filter(recipe -> recipe instanceof MeatlibRecipe).map(recipe -> (MeatlibRecipe)recipe);
        }
    }
}

