/*
 * Decompiled with CFR 0.152.
 */
package com.neep.meatlib.util;

import java.util.Objects;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public interface LazySupplier<T>
extends Supplier<T> {
    @Override
    @NotNull
    public T get();

    public boolean isInitialised();

    public void invalidate();

    public static <T> LazySupplier<T> of(Supplier<T> supplier) {
        return new LazySupplierImpl<T>(supplier);
    }

    public static class LazySupplierImpl<T>
    implements LazySupplier<T> {
        protected final Supplier<T> supplier;
        protected T object;

        public LazySupplierImpl(Supplier<T> supplier) {
            this.supplier = supplier;
        }

        @Override
        @NotNull
        public T get() {
            if (this.object == null) {
                this.object = this.supplier.get();
                Objects.requireNonNull(this.object);
            }
            return this.object;
        }

        @Override
        public boolean isInitialised() {
            return this.object != null;
        }

        @Override
        public void invalidate() {
            this.object = null;
        }
    }
}

