/*
 * Decompiled with CFR 0.152.
 */
package com.neep.meatweapons.item;

import com.neep.meatlib.item.MeatlibItem;
import com.neep.meatlib.item.MeatlibItemSettings;
import com.neep.meatweapons.MeatWeapons;
import com.neep.meatweapons.Util;
import com.neep.meatweapons.client.renderer.BaseGunRenderer;
import com.neep.meatweapons.entity.BulletDamageSource;
import com.neep.meatweapons.item.BeamEffectProvider;
import com.neep.meatweapons.item.GunItem;
import com.neep.neepmeat.api.item.OverrideSwingItem;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import net.minecraft.class_756;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.animatable.client.RenderProvider;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.util.GeckoLibUtil;

public abstract class BaseGunItem
extends class_1792
implements MeatlibItem,
GunItem,
GeoItem,
OverrideSwingItem {
    protected final AnimatableInstanceCache instanceCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    protected final Supplier<Object> renderProvider = GeoItem.makeRenderer((GeoItem)this);
    protected Map<GunItem.GunSounds, class_3414> sounds = new EnumMap<GunItem.GunSounds, class_3414>(GunItem.GunSounds.class);
    public class_1792 ammunition;
    public boolean hasLore;
    public final int maxShots;
    public final int cooldown;
    protected final Random random = new Random(0L);
    protected final String controllerName = "controller";

    public BaseGunItem(class_1792 ammunition, int maxShots, int cooldown, boolean hasLore, MeatlibItemSettings settings) {
        super((class_1792.class_1793)settings.maxCount(1).maxDamage(maxShots).maxDamageIfAbsent(maxShots).group(MeatWeapons.WEAPONS));
        this.ammunition = ammunition;
        this.maxShots = maxShots;
        this.hasLore = hasLore;
        this.cooldown = cooldown;
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    public Random getRandom() {
        return this.random;
    }

    public void method_7851(class_1799 itemStack, class_1937 world, List<class_2561> tooltip, class_1836 tooltipContext) {
        if (this.hasLore) {
            tooltip.add((class_2561)class_2561.method_43471((String)(this.method_7876() + ".lore")));
        }
    }

    public boolean allowNbtUpdateAnimation(class_1657 player, class_1268 hand, class_1799 oldStack, class_1799 newStack) {
        return false;
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8952;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 itemStack = user.method_5998(hand);
        return class_1271.method_22431((Object)itemStack);
    }

    public boolean method_31566(class_1799 stack, class_1799 otherStack, class_1735 slot, class_5536 clickType, class_1657 player, class_5630 cursorStackReference) {
        if (cursorStackReference.method_32327().method_7909().equals(this.ammunition) && stack.method_7919() != 0) {
            this.reload(player, stack, cursorStackReference.method_32327());
            return true;
        }
        return false;
    }

    @Override
    public int getShots(class_1799 stack, int trigger) {
        return trigger == 0 ? this.maxShots - stack.method_7919() : -1;
    }

    public void reload(class_1657 user, class_1799 stack, @Nullable class_1799 ammoStack) {
        user.method_7357().method_7906((class_1792)this, 7);
        class_1799 class_17992 = ammoStack = ammoStack == null ? GunItem.removeStack(this.ammunition, user) : ammoStack;
        if (ammoStack != null) {
            stack.method_7974(0);
            ammoStack.method_7934(1);
            class_1937 class_19372 = user.method_37908();
            if (class_19372 instanceof class_3218) {
                class_3218 serverWorld = (class_3218)class_19372;
                long id = GeoItem.getOrAssignId((class_1799)stack, (class_3218)serverWorld);
                this.triggerAnim((class_1297)user, id, "Activation", "activate");
                this.playSound((class_1937)serverWorld, (class_1309)user, GunItem.GunSounds.RELOAD);
            }
        }
    }

    protected void fireBeam(class_1937 world, class_1657 player, class_1799 stack) {
        Random random = this.getRandom();
        double yaw = Math.toRadians(player.method_5791()) + 0.1 * ((double)random.nextFloat() - 0.5);
        double pitch = Math.toRadians(player.method_5695(0.1f)) + 0.1 * ((double)random.nextFloat() - 0.5);
        class_243 pos = new class_243(player.method_23317(), player.method_23318() + 1.4, player.method_23321());
        class_243 transform = this.getMuzzleOffset((class_1309)player, stack).method_1037((float)(-pitch)).method_1024((float)(-yaw));
        pos = pos.method_1019(transform);
        double d = 0.2;
        class_243 perturb = new class_243((double)random.nextFloat() - 0.5, (double)random.nextFloat() - 0.5, (double)random.nextFloat() - 0.5).method_1021(d);
        class_243 end = pos.method_1019(player.method_5828(1.0f).method_1019(perturb).method_1021(40.0));
        Optional<class_3966> target = BaseGunItem.hitScan((class_1309)player, pos, end, 40.0, this);
        if (target.isPresent()) {
            class_1297 entity = target.get().method_17782();
            entity.method_5643((class_1282)BulletDamageSource.create(world, (class_1309)player, 0.1f), 2.0f);
            entity.field_6008 = 0;
        }
        this.playSound(world, (class_1309)player, GunItem.GunSounds.FIRE_PRIMARY);
        this.syncAnimation(world, (class_1309)player, stack, "fire", true);
    }

    protected void fireShell(class_1937 world, class_1657 player, class_1799 stack, double speed, ProjectileFactory factory) {
        double yaw = Math.toRadians(player.method_5791());
        double pitch = Math.toRadians(player.method_5695(0.1f));
        double vx = speed * -Math.sin(yaw) * Math.cos(pitch) + player.method_18798().method_10216();
        double vy = speed * -Math.sin(pitch) + player.method_18798().method_10214();
        double vz = speed * Math.cos(yaw) * Math.cos(pitch) + player.method_18798().method_10215();
        class_243 pos = new class_243(player.method_23317(), player.method_23318() + 1.4, player.method_23321());
        if (!player.method_5715()) {
            class_243 transform = this.getMuzzleOffset((class_1309)player, stack).method_1024((float)(-yaw));
            pos = pos.method_1019(transform);
        }
        class_1665 shell = factory.create(world, pos.field_1352, pos.field_1351, pos.field_1350, vx, vy, vz);
        shell.method_7432((class_1297)player);
        world.method_8649((class_1297)shell);
        this.playSound(world, (class_1309)player, GunItem.GunSounds.FIRE_SECONDARY);
        this.syncAnimation(world, (class_1309)player, stack, "fire", true);
    }

    public static Optional<class_3966> hitScan(@NotNull class_1309 caster, class_243 start, class_243 end, double distance, BeamEffectProvider gunItem) {
        return BaseGunItem.hitScan(caster, start, end, distance, e -> true, gunItem, 0.1f);
    }

    public static Optional<class_3966> hitScan(@NotNull class_1309 caster, class_243 start, class_243 end, double distance, Predicate<class_1297> predicate, BeamEffectProvider gunItem, float margin) {
        class_1937 world = caster.method_37908();
        if (!world.field_9236) {
            class_3959 ctx = new class_3959(start, end, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)caster);
            class_3965 blockResult = world.method_17742(ctx);
            Predicate<class_1297> entityFilter = entity -> !entity.method_7325() && entity.method_5863() && predicate.test((class_1297)entity);
            double minDistance = distance;
            class_3966 entityResult = null;
            for (class_3966 result : Util.getRayTargets(caster, start, blockResult.method_17784(), entityFilter, margin)) {
                if (!(result.method_17784().method_1022(start) < minDistance)) continue;
                minDistance = result.method_17784().method_1022(start);
                entityResult = result;
            }
            class_243 hitPos = ((class_239)Objects.requireNonNullElse(entityResult, blockResult)).method_17784();
            gunItem.syncBeamEffect((class_3218)world, start, hitPos, 0.2f, 9, 100.0);
            return Optional.ofNullable(entityResult);
        }
        return Optional.empty();
    }

    @Override
    public void syncAnimation(class_1937 world, class_1309 player, class_1799 stack, String animation, boolean broadcast) {
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            if (player instanceof class_1657) {
                class_1657 playerEntity = (class_1657)player;
                long id = GeoItem.getOrAssignId((class_1799)stack, (class_3218)((class_3218)world));
                this.triggerAnim((class_1297)player, id, "controller", animation);
                if (broadcast) {
                    for (class_1657 otherPlayer : PlayerLookup.tracking((class_1297)player)) {
                        this.triggerAnim((class_1297)otherPlayer, id, "controller", animation);
                    }
                }
            }
        } else {
            this.triggerAnim((class_1297)player, GeoItem.getId((class_1799)stack), "controller", animation);
        }
    }

    @Override
    public void playSound(class_1937 world, class_1309 entity, GunItem.GunSounds sound) {
        if (this.sounds.containsKey((Object)sound)) {
            world.method_8396(null, entity.method_24515(), this.sounds.get((Object)sound), class_3419.field_15248, 1.0f, 1.0f);
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", this::fireController)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.instanceCache;
    }

    public Supplier<Object> getRenderProvider() {
        return this.renderProvider;
    }

    public void createRenderer(Consumer<Object> consumer) {
        consumer.accept(new RenderProvider(){
            private BaseGunRenderer<? extends BaseGunItem> renderer;

            public class_756 getCustomRenderer() {
                if (this.renderer == null) {
                    this.renderer = new BaseGunRenderer<BaseGunItem>(BaseGunItem.this.createModel());
                }
                return this.renderer;
            }
        });
    }

    protected abstract GeoModel<? extends BaseGunItem> createModel();

    protected <P extends BaseGunItem> PlayState fireController(AnimationState<P> event) {
        return PlayState.CONTINUE;
    }

    public static interface ProjectileFactory {
        public class_1665 create(class_1937 var1, double var2, double var4, double var6, double var8, double var10, double var12);
    }
}

