/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepbus.block.entity;

import com.neep.meatlib.blockentity.SyncableBlockEntity;
import com.neep.neepbus.block.entity.Button;
import com.neep.neepbus.block.entity.ConfigProvider;
import com.neep.neepbus.util.CachingSender;
import com.neep.neepbus.util.ConfigEntry;
import com.neep.neepbus.util.DirectReadPort;
import com.neep.neepbus.util.NeepBusConfig;
import com.neep.neepbus.util.SimpleEntry;
import com.neep.neepbus.util.message.DataVariant;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;

public class LargeButtonBlockEntity
extends SyncableBlockEntity
implements ConfigProvider,
Button {
    private DataVariant highValue = DataVariant.of(1.0f);
    private DataVariant value = DataVariant.NULL;
    private int fallDelay = 0;
    private final CachingSender sender = new CachingSender(() -> ((LargeButtonBlockEntity)this).method_10997(), this.field_11867);
    private final ConfigEntry outputEntry = new SimpleEntry("Button output");
    private final DirectReadPort output = new DirectReadPort(this.outputEntry, () -> this.value, this.sender::send);
    private final NeepBusConfig config = NeepBusConfig.builder(this::sync).output(this.outputEntry, this.output).build();

    public LargeButtonBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public void invalidate() {
        this.sender.invalidate();
    }

    @Override
    public NeepBusConfig getConfig() {
        return this.config;
    }

    public void trigger() {
        this.value = this.highValue;
        this.output.send();
        if (this.fallDelay > 0) {
            this.field_11863.method_39279(this.field_11867, this.method_11010().method_26204(), this.fallDelay);
        }
    }

    public void onScheduledTick() {
        this.value = DataVariant.NULL;
        this.output.send();
    }

    @Override
    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        this.config.writeNbt(nbt);
        nbt.method_10582("current_value", this.value.stringValue());
        nbt.method_10582("value", this.highValue.stringValue());
        nbt.method_10569("fall_delay", this.fallDelay);
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.config.readNbt(nbt);
        this.value = DataVariant.of(nbt.method_10558("current_value"));
        this.highValue = DataVariant.of(nbt.method_10558("value"));
        this.fallDelay = nbt.method_10550("fall_delay");
    }

    @Override
    public void setValues(DataVariant value, int fallDelay) {
        this.highValue = value;
        this.fallDelay = fallDelay;
        this.method_5431();
    }

    @Override
    public DataVariant getHighValue() {
        return this.highValue;
    }

    @Override
    public int getFallDelay() {
        return this.fallDelay;
    }
}

