/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.api.live_machine;

import com.neep.meatlib.util.NbtSerialisable;
import net.minecraft.class_2487;
import net.minecraft.class_3532;
import net.minecraft.class_5819;

public class DegradationManager
implements NbtSerialisable {
    private final RateFunction degradationRate;
    private final Runnable zeroCross;
    private double degradation = 0.0;

    public DegradationManager(RateFunction degradationRate, class_5819 random, Runnable zeroCross) {
        this.degradationRate = degradationRate;
        this.zeroCross = zeroCross;
    }

    public float getDegradation() {
        return (float)this.degradation;
    }

    public long estimateRul() {
        double rate = this.degradationRate.get(this.degradation);
        if (rate <= 0.0) {
            return -1L;
        }
        return (long)((1.0 - this.degradation) / rate);
    }

    public void tick() {
        double rate = this.degradationRate.get(this.degradation);
        this.degradation = class_3532.method_15350((double)(this.degradation + rate), (double)0.0, (double)1.0);
    }

    @Override
    public class_2487 writeNbt(class_2487 nbt) {
        nbt.method_10549("degradation", this.degradation);
        return nbt;
    }

    @Override
    public void readNbt(class_2487 nbt) {
        this.degradation = nbt.method_10583("degradation");
    }

    public void subtract(float amount) {
        this.degradation = class_3532.method_15350((double)(this.degradation - (double)amount), (double)0.0, (double)1.0);
    }

    @FunctionalInterface
    public static interface RateFunction {
        public double get(double var1);
    }
}

