/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.client.screen.plc.edit;

import com.google.common.collect.Lists;
import com.neep.meatlib.client.screen.GUIUtil;
import com.neep.meatlib.client.screen.TooltipHelper;
import com.neep.neepmeat.api.plc.PLCCols;
import com.neep.neepmeat.init.NMSounds;
import com.neep.neepmeat.plc.Instructions;
import com.neep.neepmeat.plc.instruction.InstructionProvider;
import com.neep.neepmeat.plc.instruction.gui.InstructionAttributes;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1144;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4069;
import net.minecraft.class_5348;
import net.minecraft.class_6379;
import net.minecraft.class_6382;
import org.jetbrains.annotations.Nullable;

public class InstructionBrowserWidget
implements class_364,
class_4068,
class_4069,
class_6379 {
    private final class_310 client = class_310.method_1551();
    private final class_327 textRenderer;
    private final Supplier<InstructionProvider> selected;
    private final Predicate<InstructionProvider> predicate;
    private final Consumer<InstructionProvider> action;
    private final TooltipHelper tooltipHelper;
    private float scrollAmount;
    private int x;
    private int y;
    private int width;
    private int height;
    private int screenWidth;
    private int screenHeight;
    private final int pad = 1;
    private final List<DropWidget> entries;
    private final List<class_364> children;
    @Nullable
    private class_364 focused;

    public InstructionBrowserWidget(Supplier<InstructionProvider> selected, Predicate<InstructionProvider> predicate, Consumer<InstructionProvider> action) {
        this.textRenderer = this.client.field_1772;
        this.tooltipHelper = new TooltipHelper(false, PLCCols.TEXT.col, false);
        this.scrollAmount = 0.0f;
        this.pad = 1;
        this.entries = Lists.newArrayList();
        this.children = Lists.newArrayList();
        this.selected = selected;
        this.predicate = predicate;
        this.action = action;
    }

    public void init(int screenWidth, int screenHeight) {
        this.children.clear();
        this.screenHeight = screenHeight;
        this.screenWidth = screenWidth;
        this.width = 100;
        this.height = 200;
        this.x = screenWidth - this.width;
        this.y = screenHeight - this.height;
        if (this.entries.isEmpty()) {
            this.addEntries();
        }
    }

    protected void addEntries() {
        this.entries.clear();
        int elementWidth = this.width - 3;
        Map<InstructionAttributes.Category, List<InstructionProvider>> map = Instructions.REGISTRY.values().stream().filter(this.predicate).collect(Collectors.groupingBy(p -> InstructionAttributes.get(p).category()));
        for (InstructionAttributes.Category category : InstructionAttributes.Category.values()) {
            List<InstructionProvider> list = map.get((Object)category);
            if (list == null) continue;
            this.entries.add(new DropWidget(elementWidth, category, list.stream().map(p -> new OperationWidget(elementWidth - 2, (InstructionProvider)p, this.action)).collect(Collectors.toList())));
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        context.method_25294(this.x, this.y, this.x + this.width, this.y + this.height, -1879048192);
        GUIUtil.renderBorder(context, this.x, this.y, this.width - 1, this.height - 1, PLCCols.BORDER.col, 0);
        context.method_51448().method_22903();
        int yOffset = (int)((float)(this.y + 2) + this.scrollAmount);
        int xOffset = this.x + 2;
        this.enableScissor(context);
        for (DropWidget entry : this.entries) {
            yOffset = (int)((float)yOffset + (entry.render(context, xOffset, yOffset, mouseX, mouseY, delta) + 1.0f));
        }
        this.disableScissor(context);
        context.method_51448().method_22909();
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        if (this.isInBounds(mouseX, mouseY)) {
            this.scrollAmount = (float)Math.min(0.0, (double)this.scrollAmount + amount * 6.0);
            return true;
        }
        return false;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.isInBounds(mouseX, mouseY)) {
            for (DropWidget entry : this.entries) {
                entry.onClick(mouseX, mouseY);
            }
            return true;
        }
        return false;
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return this.isInBounds(mouseX, mouseY);
    }

    public boolean isInBounds(double mx, double my) {
        return (double)this.x <= mx && (double)this.y <= my && (double)(this.x + this.width) >= mx && (double)(this.y + this.height) >= my;
    }

    public List<? extends class_364> method_25396() {
        return this.children;
    }

    public boolean method_25397() {
        return false;
    }

    public void method_25398(boolean dragging) {
    }

    @Nullable
    public class_364 method_25399() {
        return this.focused;
    }

    public void method_25395(@Nullable class_364 focused) {
        this.focused = focused;
    }

    public void method_37020(class_6382 builder) {
    }

    public class_6379.class_6380 method_37018() {
        return class_6379.class_6380.field_33784;
    }

    private void enableScissor(class_332 context) {
        context.method_44379(this.x + 1, this.y + 1, this.x + this.width - 1, this.y + this.height - 1);
    }

    private void disableScissor(class_332 context) {
        context.method_44380();
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    private class DropWidget {
        private final InstructionAttributes.Category category;
        private final List<OperationWidget> operationWidgets;
        private final int width;
        private final int headerHeight;
        private boolean unfolded;
        private int prevX;
        private int prevY;

        public DropWidget(int elementWidth, InstructionAttributes.Category category, List<OperationWidget> operationWidgets) {
            Objects.requireNonNull(InstructionBrowserWidget.this.textRenderer);
            this.headerHeight = 9 + 4;
            this.unfolded = false;
            this.width = elementWidth;
            this.category = category;
            this.operationWidgets = operationWidgets;
        }

        public float render(class_332 context, int x, int y, double mouseX, double mouseY, float delta) {
            this.prevX = x;
            this.prevY = y;
            String arrow = this.unfolded ? "\u2193" : "\u2192";
            context.method_51433(InstructionBrowserWidget.this.textRenderer, arrow, x + 2, y + 2, PLCCols.TEXT.col, false);
            context.method_51439(InstructionBrowserWidget.this.textRenderer, this.category.name, x + 2 + 9, y + 2, PLCCols.TEXT.col, false);
            int yOffset = this.headerHeight;
            if (this.unfolded) {
                for (OperationWidget widget : this.operationWidgets) {
                    widget.render(context, x, y + yOffset, mouseX, mouseY, delta);
                    yOffset += widget.height + 1;
                }
            }
            return yOffset;
        }

        private boolean isMouseOver(int x, int y, double mouseX, double mouseY) {
            return (double)x <= mouseX && (double)y <= mouseY && (double)(x + this.width) >= mouseX && (double)(y + this.headerHeight) >= mouseY;
        }

        public void onClick(double mouseX, double mouseY) {
            if (this.isMouseOver(this.prevX, this.prevY, mouseX, mouseY)) {
                this.unfolded = !this.unfolded;
                InstructionBrowserWidget.this.client.method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)NMSounds.UI_BEEP, (float)1.0f));
            }
            if (this.unfolded) {
                this.operationWidgets.forEach(w -> {
                    if (w.isMouseOver(mouseX, mouseY)) {
                        w.onClick(mouseX, mouseY);
                    }
                });
            }
        }
    }

    private class OperationWidget {
        private final InstructionProvider provider;
        private final Consumer<InstructionProvider> action;
        private final int width;
        private final int height;
        private final class_2561 message;
        private int prevX;
        private int prevY;

        public OperationWidget(int width, InstructionProvider provider, Consumer<InstructionProvider> action) {
            this.message = class_2561.method_30163((String)provider.getShortName());
            this.width = width;
            Objects.requireNonNull(InstructionBrowserWidget.this.textRenderer);
            this.height = 9 + 1;
            this.provider = provider;
            this.action = action;
        }

        public void render(class_332 context, int x, int y, double mouseX, double mouseY, float delta) {
            this.prevX = x;
            this.prevY = y;
            int col = InstructionBrowserWidget.this.selected.get() == this.provider ? PLCCols.SELECTED.col : PLCCols.BORDER.col;
            GUIUtil.drawHorizontalLine1(context, x, x + this.width, y, col);
            class_327 textRenderer = class_310.method_1551().field_1772;
            context.method_51439(textRenderer, this.message, x + 2, y + 2, col, false);
            if (this.isMouseOver(mouseX, mouseY)) {
                this.renderTooltip(context, x, y, (int)mouseX, (int)mouseY);
            }
        }

        private boolean isMouseOver(double mouseX, double mouseY) {
            return InstructionBrowserWidget.this.method_25405(mouseX, mouseY) && (double)this.prevX <= mouseX && (double)this.prevY <= mouseY && (double)(this.prevX + this.width) >= mouseX && (double)(this.prevY + this.height) >= mouseY;
        }

        public void renderTooltip(class_332 matrices, int x, int y, int mouseX, int mouseY) {
            InstructionBrowserWidget.this.disableScissor(matrices);
            InstructionAttributes.InstructionTooltip tooltip = InstructionAttributes.get(this.provider);
            int width = 230;
            int tx = x - width - 5;
            if (tooltip != InstructionAttributes.InstructionTooltip.EMPTY) {
                List wrapped = InstructionBrowserWidget.this.textRenderer.method_1728((class_5348)tooltip.description(), width);
                InstructionBrowserWidget.this.tooltipHelper.drawOrdered(matrices, tx, y, wrapped, width);
            }
            InstructionBrowserWidget.this.enableScissor(matrices);
        }

        public void onClick(double mouseX, double mouseY) {
            this.action.accept(this.provider);
            this.playDownSound(InstructionBrowserWidget.this.client.method_1483());
        }

        public void playDownSound(class_1144 soundManager) {
            soundManager.method_4873((class_1113)class_1109.method_4758((class_3414)NMSounds.UI_BEEP, (float)1.0f));
        }

        public int height() {
            return this.height;
        }
    }
}

