/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.compat.emi.recipe;

import com.neep.neepmeat.NeepMeat;
import com.neep.neepmeat.api.processing.PowerUtils;
import com.neep.neepmeat.compat.emi.NMEmiPlugin;
import com.neep.neepmeat.compat.emi.helper.EmiIngredientHelper;
import com.neep.neepmeat.recipe.FluidHeatingRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.TextWidget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import org.jetbrains.annotations.Nullable;

public class HeatingEmiRecipe
implements EmiRecipe {
    private final class_2960 id;
    private final List<EmiIngredient> input;
    private final List<EmiStack> output;
    private final FluidHeatingRecipe recipe;

    public HeatingEmiRecipe(FluidHeatingRecipe recipe) {
        this.id = recipe.method_8114();
        this.input = EmiIngredientHelper.inputToIngredient(recipe.getFluidInput());
        this.output = List.of(EmiStack.of((class_3611)recipe.getFluidOutput().resource(), (long)recipe.getFluidOutput().minAmount()));
        this.recipe = recipe;
    }

    public EmiRecipeCategory getCategory() {
        return NMEmiPlugin.HEATING;
    }

    @Nullable
    public class_2960 getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return this.input;
    }

    public List<EmiStack> getOutputs() {
        return this.output;
    }

    public int getDisplayWidth() {
        return 150;
    }

    public int getDisplayHeight() {
        return 55;
    }

    public void addWidgets(WidgetHolder widgets) {
        int startX = this.getDisplayWidth() / 2 - 41;
        int startY = 10;
        widgets.addTexture(EmiTexture.EMPTY_ARROW, startX + 24, startY + 8);
        widgets.addText((class_2561)NeepMeat.translationKey("category", "general.energy", PowerUtils.energyForRecipe(this.recipe.getTime())), this.getDisplayWidth() - 5, 3, -12566464, false).horizontalAlign(TextWidget.Alignment.END);
        widgets.addSlot(this.input.get(0), startX + 1, startY + 9);
        widgets.addSlot((EmiIngredient)this.output.get(0), startX + 61, startY + 9).recipeContext((EmiRecipe)this);
    }
}

