/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.compat.rei.display;

import com.neep.neepmeat.api.processing.BlockCrushingRegistry;
import com.neep.neepmeat.recipe.BlockCrushingRecipe;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.class_1935;
import net.minecraft.class_2561;

public class BlockCrushingDisplay
implements Display {
    private final CategoryIdentifier<? extends BlockCrushingDisplay> category;
    private final BlockCrushingRecipe recipe;
    private final Supplier<Collection<BlockCrushingRegistry.Entry>> entrySupplier;

    public BlockCrushingDisplay(CategoryIdentifier<? extends BlockCrushingDisplay> category, BlockCrushingRecipe recipe, Supplier<Collection<BlockCrushingRegistry.Entry>> entrySupplier) {
        this.category = category;
        this.recipe = recipe;
        this.entrySupplier = entrySupplier;
    }

    public static <T extends BlockCrushingRecipe> Function<T, BlockCrushingDisplay> filler(CategoryIdentifier<? extends BlockCrushingDisplay> categoryIdentifier, Supplier<Collection<BlockCrushingRegistry.Entry>> entrySupplier) {
        return r -> new BlockCrushingDisplay(categoryIdentifier, (BlockCrushingRecipe)r, entrySupplier);
    }

    public List<EntryIngredient> getInputEntries() {
        return List.of(EntryIngredients.ofItems((Collection)this.entrySupplier.get().stream().flatMap(e -> e.input().getAll().stream()).collect(Collectors.toUnmodifiableList()), (int)1));
    }

    public List<EntryIngredient> getOutputEntries() {
        EntryIngredient main = EntryIngredient.of(this.entrySupplier.get().stream().map(entry -> EntryStacks.of((class_1935)((class_1935)entry.output().resource()), (int)((int)this.recipe.getBaseAmount()))).toList());
        EntryIngredient extra = EntryIngredient.of(this.entrySupplier.get().stream().map(entry -> EntryStacks.of((class_1935)((class_1935)entry.extra().resource()), (int)((int)this.recipe.getExtraAmount())).tooltip(new class_2561[]{class_2561.method_30163((String)("Chance: " + this.recipe.getChance()))})).toList());
        return List.of(main, extra);
    }

    public CategoryIdentifier<?> getCategoryIdentifier() {
        return this.category;
    }

    public double processTime() {
        return this.recipe.getTime();
    }
}

