/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.machine.heater;

import com.neep.meatlib.block.BaseFacingBlock;
import com.neep.neepmeat.api.processing.PowerUtils;
import com.neep.neepmeat.api.storage.DynamicLazyBlockApiCache;
import com.neep.neepmeat.api.storage.LazyBlockApiCache;
import com.neep.neepmeat.init.NMBlockEntities;
import com.neep.neepmeat.init.NMFluids;
import com.neep.neepmeat.machine.Heatable;
import com.neep.neepmeat.machine.heater.HeaterBlock;
import com.neep.neepmeat.machine.motor.LiquidFuelMachine;
import com.neep.neepmeat.transport.api.pipe.BloodAcceptor;
import java.util.Optional;
import java.util.Random;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2400;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5955;

public class HeaterBlockEntity
extends LiquidFuelMachine
implements BloodAcceptor {
    private float influx;
    private float liquidInflux;
    private final LazyBlockApiCache<Heatable, Void> cache = DynamicLazyBlockApiCache.of(() -> ((HeaterBlockEntity)this).method_10997(), Heatable.LOOKUP, () -> pos.method_10093((class_2350)this.method_11010().method_11654((class_2769)HeaterBlock.field_10927)), () -> null);
    private int copperTime;

    protected HeaterBlockEntity(class_2591<HeaterBlockEntity> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public HeaterBlockEntity(class_2338 pos, class_2680 state) {
        this(NMBlockEntities.HEATER, pos, state);
        this.addListener(this.cache);
    }

    public static void serverTick(class_1937 world, class_2338 pos, class_2680 state, HeaterBlockEntity blockEntity) {
        blockEntity.tick();
    }

    public void tick() {
        Heatable heatable;
        if (!this.fluidStorage.isResourceBlank()) {
            try (Transaction transaction = Transaction.openOuter();){
                long extracted = this.extractEnergy(this.maxPower(), (TransactionContext)transaction);
                this.liquidInflux = extracted > 0L ? (float)extracted / (float)PowerUtils.BASE_POWER : 0.0f;
                transaction.commit();
            }
        } else {
            this.liquidInflux = 0.0f;
        }
        if ((heatable = this.cache.find()) != null) {
            double runningRate = this.getPUPower();
            if (this.getPUPower() >= 0.04) {
                heatable.setBurning();
                heatable.setHeat((float)runningRate);
                this.heatBlock();
            }
            class_2350 facing = (class_2350)this.method_11010().method_11654((class_2769)HeaterBlock.field_10927);
            class_2338 furnacePos = this.field_11867.method_10093(facing);
            class_2680 state = this.method_10997().method_8320(furnacePos);
            heatable.updateState(this.method_10997(), furnacePos, state);
        } else if (this.getPUPower() > 0.05) {
            this.heatBlock();
        }
    }

    public double getPUPower() {
        return Math.max(this.influx, this.liquidInflux);
    }

    public void onRemove() {
        Heatable heatable = this.cache.find();
        if (heatable != null) {
            heatable.setHeat(0.0f);
        }
    }

    public void heatBlock() {
        class_2338 facingPos = this.method_11016().method_10093((class_2350)this.method_11010().method_11654((class_2769)BaseFacingBlock.field_10927));
        class_2680 facingState = this.field_11863.method_8320(facingPos);
        class_2248 class_22482 = facingState.method_26204();
        if (class_22482 instanceof class_5955) {
            class_5955 oxidizable = (class_5955)class_22482;
            ++this.copperTime;
            if (this.copperTime == 100) {
                this.copperTime = 0;
                Optional nextBlock = oxidizable.method_31639(facingState);
                if (HeaterBlockEntity.canOxidise(this.field_11863, facingPos) && nextBlock.isPresent()) {
                    this.field_11863.method_8501(facingPos, (class_2680)nextBlock.get());
                }
            }
        } else {
            this.copperTime = 0;
        }
    }

    public static boolean canOxidise(class_1937 world, class_2338 pos) {
        for (class_2350 direction : class_2350.values()) {
            class_2338 offset = pos.method_10093(direction);
            if (!world.method_8320(offset).method_27852(NMFluids.PATINA_TREATMENT)) continue;
            return true;
        }
        return false;
    }

    protected static void spawnOxidationParticles(class_3218 world, class_2400 particle, class_2338 pos, Random random, int amount, int radius) {
        for (class_3222 player : PlayerLookup.around((class_3218)world, (class_2382)pos, (double)radius)) {
            double dx = random.nextDouble() * 1.1;
            double dy = random.nextDouble() * 1.1;
            double d = random.nextDouble() * 1.1;
        }
    }

    @Override
    public float updateInflux(float influx) {
        this.influx = influx;
        return influx;
    }

    @Override
    public BloodAcceptor.Mode getMode() {
        return BloodAcceptor.Mode.SINK;
    }
}

