/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.machine.live_machine.block.entity;

import com.neep.meatlib.blockentity.SyncableBlockEntity;
import com.neep.neepbus.block.entity.ConfigProvider;
import com.neep.neepbus.util.NeepBusConfig;
import com.neep.neepbus.util.SimpleEntry;
import com.neep.neepbus.util.WritePort;
import com.neep.neepmeat.api.live_machine.ComponentType;
import com.neep.neepmeat.api.live_machine.LivingMachineComponent;
import com.neep.neepmeat.entity.skyworm.SkywormAnimationTimes;
import com.neep.neepmeat.entity.skyworm.SkywormCollectParcelAction;
import com.neep.neepmeat.entity.skyworm.SkywormEntity;
import com.neep.neepmeat.machine.live_machine.LivingMachineComponents;
import com.neep.neepmeat.machine.live_machine.block.DistributorPointBlock;
import com.neep.neepmeat.machine.live_machine.block.entity.DistributorPoint;
import com.neep.neepmeat.transport.worm.DistributorParcel;
import com.neep.neepmeat.transport.worm.GlobalDistributorRouting;
import com.neep.neepmeat.transport.worm.RouteLock;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import org.jetbrains.annotations.Nullable;

public class DistributorPointBlockEntity
extends SyncableBlockEntity
implements DistributorPoint,
ConfigProvider {
    public static final String NULL_ADDRESS = "";
    public static final int MIN_COOLDOWN = 300;
    private String address = "";
    private Mode mode = Mode.RECEIVE;
    private int maxCooldown = 300;
    private boolean autoSend = true;
    private boolean powered = false;
    public int timeUntilPickup = 0;
    @Nullable
    public RouteLock routeLock;
    public boolean sendNext;
    private final WritePort sendPort = f -> {
        this.sendNext = true;
    };
    private final WritePort addressPoint = f -> this.setAddress(f.stringValue());
    private final NeepBusConfig config = NeepBusConfig.builder(this::method_5431).applyChanges(this).input(new SimpleEntry("Send"), this.sendPort).input(new SimpleEntry("Set address"), this.addressPoint).build();
    private final List<DistributorParcel> queuedParcels = new ObjectArrayList();

    public DistributorPointBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Override
    public void setController(class_2338 pos) {
        boolean newPowered;
        boolean bl = newPowered = pos != null;
        if (this.powered != newPowered) {
            this.powered = newPowered;
            GlobalDistributorRouting.updatePoint(this);
            this.method_5431();
        }
    }

    @Override
    public boolean componentRemoved() {
        return this.method_11015();
    }

    @Override
    public ComponentType<? extends LivingMachineComponent> getComponentType() {
        return LivingMachineComponents.DISTRIBUTOR_POINT;
    }

    @Override
    public boolean isPowered() {
        return this.powered;
    }

    public void method_31662(class_1937 world) {
        super.method_31662(world);
    }

    @Override
    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10582("address", this.address);
        nbt.method_10569("mode", this.mode.ordinal());
        nbt.method_10569("max_cooldown", this.maxCooldown);
        nbt.method_10556("auto_send", this.autoSend);
        nbt.method_10566("config", (class_2520)this.config.writeNbt(new class_2487()));
        class_2499 parcels = new class_2499();
        for (DistributorParcel parcel : this.queuedParcels) {
            parcels.add((Object)parcel.toNbt());
        }
        nbt.method_10566("parcels", (class_2520)parcels);
        if (this.routeLock != null) {
            nbt.method_10566("route", (class_2520)this.routeLock.toNbt());
        }
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.address = nbt.method_10558("address");
        this.mode = Mode.values()[nbt.method_10550("mode")];
        this.maxCooldown = nbt.method_10550("max_cooldown");
        this.autoSend = nbt.method_10577("auto_send");
        this.config.readNbt(nbt.method_10562("config"));
        this.queuedParcels.clear();
        class_2499 parcels = nbt.method_10554("parcels", 10);
        for (int i = 0; i < parcels.size(); ++i) {
            class_2487 compound = parcels.method_10602(i);
            this.queuedParcels.add(DistributorParcel.fromNbt(compound));
        }
        this.routeLock = RouteLock.fromNbt(nbt.method_10562("route"));
    }

    @Override
    public String getAddress() {
        return this.address;
    }

    @Override
    public void setAddress(String addr, Mode mode, int maxCooldown, boolean autoSend) {
        this.address = addr;
        this.mode = mode;
        this.maxCooldown = Math.max(maxCooldown, 300);
        this.autoSend = autoSend;
        GlobalDistributorRouting.updatePoint(this);
        this.method_5431();
    }

    public void setAddress(String addr) {
        this.address = addr;
        GlobalDistributorRouting.updatePoint(this);
        this.method_5431();
    }

    @Override
    public Mode getMode() {
        return this.mode;
    }

    public void onBroken() {
        GlobalDistributorRouting.unregisterPoint(this.method_10997(), this.field_11867);
    }

    public void onPlaced() {
        GlobalDistributorRouting.updatePoint(this);
    }

    @Override
    public void receive(DistributorParcel parcel) {
        this.queuedParcels.add(parcel);
        this.method_5431();
    }

    @Override
    public List<DistributorParcel> getQueuedParcels() {
        return this.queuedParcels;
    }

    @Override
    public class_1937 getPointWorld() {
        return this.method_10997();
    }

    @Override
    public class_2338 getPointPos() {
        return this.method_11016();
    }

    @Override
    public void scheduleSend(RouteLock routeReference, SkywormAnimationTimes times) {
        this.timeUntilPickup = times.descend();
        this.routeLock = routeReference;
        this.method_5431();
        DistributorPointBlockEntity.createWorm(this.method_10997(), this.method_11010(), this.method_11016(), times);
    }

    public static void createWorm(class_1937 world, class_2680 state, class_2338 pos, SkywormAnimationTimes times) {
        class_2350 facing = (class_2350)state.method_11654((class_2769)DistributorPointBlock.VERTICAL_DIRECTION);
        boolean fromBelow = facing == class_2350.field_11033;
        class_243 targetPosition = pos.method_10079(facing, 1).method_46558();
        class_243 position = targetPosition.method_1031(0.0, (double)(facing.method_10164() * 200), 0.0);
        SkywormEntity worm = SkywormEntity.setup(world, position);
        worm.setFromBelow(fromBelow);
        worm.setAllowWobble(false);
        worm.setAction(new SkywormCollectParcelAction(worm, position.field_1351, targetPosition.field_1351, times));
        world.method_8649((class_1297)worm);
    }

    @Override
    public class_2338 getDumpPos() {
        return this.method_11016().method_10093((class_2350)this.method_11010().method_11654((class_2769)DistributorPointBlock.VERTICAL_DIRECTION));
    }

    @Override
    public int getMaxCooldown() {
        return this.maxCooldown;
    }

    @Override
    public int getCooldown() {
        return this.timeUntilPickup;
    }

    @Override
    public boolean shouldAutoSend() {
        return this.autoSend;
    }

    public void invalidateNetwork() {
    }

    @Override
    public NeepBusConfig getConfig() {
        return this.config;
    }

    public static enum Mode {
        SEND,
        RECEIVE,
        SEND_AND_RECEIVE;


        public static Mode fromNbt(int mode) {
            return Mode.values()[mode];
        }

        public boolean canReceive() {
            return this == RECEIVE || this == SEND_AND_RECEIVE;
        }

        public boolean canSend() {
            return this == SEND || this == SEND_AND_RECEIVE;
        }
    }
}

