/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.plc.instruction;

import com.neep.neepmeat.neepasm.NeepASM;
import com.neep.neepmeat.neepasm.vm.DataStack;
import com.neep.neepmeat.neepasm.vm.VM;
import com.neep.neepmeat.plc.instruction.Instruction;
import com.neep.neepmeat.plc.instruction.InstructionProvider;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public class BinaryInstruction
implements Instruction {
    private final Supplier<InstructionProvider> provider;
    private final BinaryOperation operation;

    public BinaryInstruction(Supplier<InstructionProvider> provider, BinaryOperation operation) {
        this.provider = provider;
        this.operation = operation;
    }

    @Override
    public void start(VM plc) throws NeepASM.RuntimeException {
        DataStack.Entry last = plc.dataStack().pop();
        DataStack.Entry first = plc.dataStack().pop();
        plc.dataStack().push(this.operation.apply(first.value(), last.value()), first.pointer() || last.pointer());
        plc.advanceCounter();
    }

    @Override
    @NotNull
    public InstructionProvider getOpcode() {
        return this.provider.get();
    }

    @FunctionalInterface
    public static interface BinaryOperation {
        public int apply(int var1, int var2);
    }
}

