/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.neep.meatlib.recipe.MeatRecipeSerialiser;
import com.neep.meatlib.recipe.MeatlibRecipe;
import com.neep.meatlib.recipe.ingredient.Ingredients;
import com.neep.meatlib.recipe.ingredient.RecipeInputs;
import com.neep.meatlib.recipe.ingredient.RecipeOutput;
import com.neep.meatlib.recipe.ingredient.RecipeOutputImpl;
import com.neep.meatlib.recipe.ingredient.RecipeOutputs;
import com.neep.meatlib.recipe.ingredient.entity.EntityRecipeInput;
import com.neep.meatlib.util.MeatLibCodecs;
import com.neep.neepmeat.init.NMParticles;
import com.neep.neepmeat.init.NMrecipeTypes;
import com.neep.neepmeat.machine.hydraulic_press.MobSqueezeContext;
import com.neep.neepmeat.mixin.client.LivingEntityAccessor;
import com.neep.neepmeat.transport.block.fluid_transport.entity.FluidDrainBlockEntity;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3956;
import net.minecraft.class_7923;

public class MobSqueezingRecipe
implements MeatlibRecipe<MobSqueezeContext> {
    protected final class_2960 id;
    protected final EntityRecipeInput entityInput;
    protected final RecipeOutput<?> output;

    public MobSqueezingRecipe(class_2960 id, EntityRecipeInput entityInput, RecipeOutput<?> output) {
        this.entityInput = entityInput;
        this.output = output;
        this.id = id;
    }

    @Override
    public boolean matches(MobSqueezeContext context) {
        return context.entity().stream().anyMatch(this.entityInput);
    }

    @Override
    public boolean takeInputs(MobSqueezeContext context, TransactionContext transaction) {
        return true;
    }

    @Override
    public boolean ejectOutputs(MobSqueezeContext context, TransactionContext transaction) {
        if (context.entity().isEmpty()) {
            return false;
        }
        class_1937 world = context.world();
        if (this.output.getType() == Ingredients.FLUID) {
            class_2586 class_25862 = world.method_8321(context.pos().method_10087(2));
            if (class_25862 instanceof FluidDrainBlockEntity) {
                FluidDrainBlockEntity be = (FluidDrainBlockEntity)class_25862;
                this.output.insertInto(be.getBuffer(null), FluidVariant::of, transaction);
            }
        } else if (this.output.getType() == Ingredients.ITEM) {
            class_2338 pos = context.pos();
            class_1799 stack = new class_1799((class_1935)this.output.resource(), (int)this.output.randomAmount(0.0f));
            class_1542 entity = new class_1542(world, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.1, (double)pos.method_10260() + 0.5, stack);
            world.method_8649((class_1297)entity);
        }
        class_1297 entity = context.entity().get(0);
        if (entity instanceof class_1309) {
            class_1309 livingEntity = (class_1309)entity;
            world.method_43128(null, (double)context.pos().method_10263(), (double)context.pos().method_10264(), (double)context.pos().method_10260(), ((LivingEntityAccessor)livingEntity).getHurtSound(world.method_48963().method_48830()), class_3419.field_15256, 1.0f, 1.0f);
        }
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            serverWorld.method_14199((class_2394)NMParticles.MILK_SPLASH, (double)context.pos().method_10263() + 0.5, (double)context.pos().method_10264() + 0.5, (double)context.pos().method_10260() + 0.5, 10, 0.25, 0.25, 0.25, 1.0E-4);
        }
        return true;
    }

    @Override
    public class_2960 method_8114() {
        return this.id;
    }

    @Override
    public MeatRecipeSerialiser<?> getSerializer() {
        return NMrecipeTypes.MOB_SQUEEZING_SERIALIZER;
    }

    public class_3956<?> method_17716() {
        return NMrecipeTypes.MOB_SQUEEZING;
    }

    public static class Serializer
    implements MeatRecipeSerialiser<MobSqueezingRecipe> {
        private final Codec<MeatRecipeSerialiser.RecipeFunction<MobSqueezingRecipe>> codec = RecordCodecBuilder.create(instance -> instance.group((App)RecipeInputs.ENTITY.codec().fieldOf("entity").forGetter(MeatLibCodecs::notImplemented), (App)RecipeOutputs.FLUID.fieldOf("output").forGetter(MeatLibCodecs::notImplemented)).apply((Applicative)instance, (i, o) -> id -> new MobSqueezingRecipe(id, (EntityRecipeInput)i, (RecipeOutput<?>)o)));

        @Override
        public Codec<MeatRecipeSerialiser.RecipeFunction<MobSqueezingRecipe>> codec() {
            return this.codec;
        }

        @Override
        public MobSqueezingRecipe read(class_2960 id, class_2540 buf) {
            EntityRecipeInput entityType = RecipeInputs.ENTITY.fromBuffer(buf);
            RecipeOutputImpl itemOutput = RecipeOutputImpl.read(class_7923.field_41173, buf);
            return new MobSqueezingRecipe(id, entityType, itemOutput);
        }

        @Override
        public void write(class_2540 buf, MobSqueezingRecipe recipe) {
            RecipeInputs.ENTITY.write(buf, recipe.entityInput);
            recipe.output.write(buf);
        }
    }
}

