/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.transport.block.fluid_transport.machine;

import com.neep.meatlib.blockentity.SyncableBlockEntity;
import com.neep.neepmeat.api.FluidPump;
import com.neep.neepmeat.api.storage.WritableSingleFluidStorage;
import com.neep.neepmeat.init.NMBlockEntities;
import com.neep.neepmeat.transport.api.FluidTransportConstants;
import com.neep.neepmeat.transport.block.fluid_transport.PumpBlock;
import com.neep.neepmeat.transport.fluid_network.node.AcceptorModes;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiCache;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiLookup;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantStorage;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;

public class PumpBlockEntity
extends SyncableBlockEntity {
    protected final WritableSingleFluidStorage buffer;
    public static final String FRONT_MODE = "front_mode";
    public static final String BACK_MODE = "back_mode";
    public AcceptorModes frontMode = AcceptorModes.NONE;
    public AcceptorModes backMode = AcceptorModes.NONE;
    protected FluidPump frontPump = FluidPump.of(-0.5f, () -> this.frontMode, FluidTransportConstants.INSTANCE.basicPumpHeight());
    protected FluidPump backPump = FluidPump.of(0.5f, () -> this.backMode, FluidTransportConstants.INSTANCE.basicPumpHeight());
    protected boolean activeWithoutRedstone = false;
    BlockApiCache<Storage<FluidVariant>, class_2350> frontCache;
    BlockApiCache<Storage<FluidVariant>, class_2350> rearCache;
    protected boolean hasFrontStorage;
    protected boolean hasRearStorage;

    public PumpBlockEntity(class_2338 pos, class_2680 state) {
        super(NMBlockEntities.PUMP, pos, state);
        this.buffer = new WritableSingleFluidStorage(81000L, this::method_5431);
    }

    public void method_11012() {
        super.method_11012();
    }

    public void method_31662(class_1937 world) {
        super.method_31662(world);
    }

    public boolean isActive() {
        return (Boolean)this.method_11010().method_11654((class_2769)PumpBlock.ACTIVE);
    }

    public void updatePowered(boolean powered) {
        boolean active = powered != this.activeWithoutRedstone;
        this.updateActive(active);
    }

    private void updateActive(boolean active) {
        this.field_11863.method_8501(this.field_11867, (class_2680)this.method_11010().method_11657((class_2769)PumpBlock.ACTIVE, (Comparable)Boolean.valueOf(active)));
        if (active) {
            this.frontMode = AcceptorModes.PUSH;
            this.backMode = AcceptorModes.PULL;
        } else {
            this.frontMode = AcceptorModes.NONE;
            this.backMode = AcceptorModes.NONE;
        }
        this.method_5431();
    }

    @Override
    public void method_11007(class_2487 tag) {
        super.method_11007(tag);
        this.buffer.toNbt(tag);
        tag.method_10569(FRONT_MODE, this.frontMode.getId());
        tag.method_10569(BACK_MODE, this.backMode.getId());
        tag.method_10556("hasFrontStorage", this.hasFrontStorage);
        tag.method_10556("hasRearStorage", this.hasRearStorage);
        tag.method_10556("activeWithoutRedstone", this.activeWithoutRedstone);
    }

    @Override
    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.buffer.readNbt(tag);
        this.frontMode = AcceptorModes.byId(tag.method_10550(FRONT_MODE));
        this.backMode = AcceptorModes.byId(tag.method_10550(BACK_MODE));
        this.hasFrontStorage = tag.method_10577("hasFrontStorage");
        this.hasRearStorage = tag.method_10577("hasRearStorage");
        this.activeWithoutRedstone = tag.method_10577("activeWithoutRedstone");
    }

    @Nullable
    public SingleVariantStorage<FluidVariant> getBuffer(class_2350 direction) {
        class_2350 facing = (class_2350)this.method_11010().method_11654((class_2769)PumpBlock.field_10927);
        if (direction == facing || direction == facing.method_10153() || direction == null) {
            return this.buffer;
        }
        return null;
    }

    @Override
    public void sync() {
        super.sync();
    }

    public FluidPump getPump(class_2350 direction) {
        class_2350 facing = (class_2350)this.method_11010().method_11654((class_2769)PumpBlock.field_10927);
        return direction == facing ? this.frontPump : (direction == facing.method_10153() ? this.backPump : null);
    }

    public void updateCache() {
        class_2350 facing = (class_2350)this.method_11010().method_11654((class_2769)PumpBlock.field_10927);
        this.frontCache = BlockApiCache.create((BlockApiLookup)FluidStorage.SIDED, (class_3218)((class_3218)this.field_11863), (class_2338)this.field_11867.method_10093(facing));
        this.rearCache = BlockApiCache.create((BlockApiLookup)FluidStorage.SIDED, (class_3218)((class_3218)this.field_11863), (class_2338)this.field_11867.method_10093(facing.method_10153()));
        Storage frontStorage = (Storage)this.frontCache.find((Object)facing.method_10153());
        Storage rearStorage = (Storage)this.rearCache.find((Object)facing);
        this.hasFrontStorage = frontStorage != null;
        this.hasRearStorage = rearStorage != null;
    }

    public void tick() {
        class_2350 facing = (class_2350)this.method_11010().method_11654((class_2769)PumpBlock.field_10927);
        long transfer = FluidTransportConstants.INSTANCE.maxTransfer();
        if (this.hasFrontStorage && this.frontCache == null || this.hasRearStorage && this.rearCache == null) {
            this.updateCache();
        }
        if (this.rearCache != null && this.frontCache != null) {
            long l;
            Storage frontStorage = (Storage)this.frontCache.find((Object)facing.method_10153());
            Storage rearStorage = (Storage)this.rearCache.find((Object)facing);
            if (rearStorage != null && this.backMode.isDriving()) {
                l = StorageUtil.move((Storage)rearStorage, (Storage)this.buffer, v -> true, (long)transfer, null);
            }
            if (frontStorage != null && this.frontMode.isDriving()) {
                l = StorageUtil.move((Storage)this.buffer, (Storage)frontStorage, v -> true, (long)transfer, null);
            }
        }
    }

    public void changeMode() {
        this.activeWithoutRedstone = !this.activeWithoutRedstone;
        this.updatePowered(this.method_10997().method_49803(this.field_11867));
        this.method_5431();
    }
}

