/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.transport.blood_network;

import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import com.neep.neepmeat.NeepMeat;
import com.neep.neepmeat.transport.api.pipe.VascularConduitEntity;
import com.neep.neepmeat.transport.api.pipe.VascularConduitEntityProvider;
import com.neep.neepmeat.transport.blood_network.BloodNetwork;
import dev.onyxstudios.cca.api.v3.component.Component;
import dev.onyxstudios.cca.api.v3.component.tick.ServerTickingComponent;
import it.unimi.dsi.fastutil.Pair;
import java.util.Collections;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2791;
import net.minecraft.class_2839;
import org.jetbrains.annotations.NotNull;

public class BloodNetworkChunkComponent
implements Component,
ServerTickingComponent {
    private final class_2791 chunk;
    private final Set<VascularConduitEntity> pipes = Collections.newSetFromMap(new WeakHashMap());
    private final Multimap<UUID, VascularConduitEntity> loadedPipes = Multimaps.newSetMultimap((Map)Maps.newHashMap(), Sets::newHashSet);
    private final Queue<Pair<UUID, class_2338>> pipesToLoad = Queues.newArrayDeque();
    public boolean loaded = false;

    public BloodNetworkChunkComponent(class_2791 chunk) {
        this.chunk = chunk;
    }

    public void serverTick() {
    }

    public void readFromNbt(@NotNull class_2487 nbt) {
        class_2499 list = nbt.method_10554("pipes", 10);
        for (int i = 0; i < list.size(); ++i) {
            class_2487 compound = list.method_10602(i);
            UUID uuid = compound.method_25926("uuid");
            class_2338 pos = class_2338.method_10092((long)compound.method_10537("pos"));
            this.pipesToLoad.add((Pair<UUID, class_2338>)Pair.of((Object)uuid, (Object)pos));
        }
    }

    public void writeToNbt(@NotNull class_2487 nbt) {
        if (this.chunk instanceof class_2839) {
            return;
        }
        class_2499 list = new class_2499();
        if (this.loaded) {
            this.saveLoadedPipes(list);
        } else {
            this.savePipesToLoad(list);
        }
        nbt.method_10566("pipes", (class_2520)list);
    }

    void saveLoadedPipes(class_2499 list) {
        for (VascularConduitEntity pipe : this.pipes) {
            BloodNetwork network = pipe.getNetwork();
            if (network == null) {
                NeepMeat.LOGGER.warn("Vascular Conduit at " + String.valueOf(pipe.getBlockPos()) + "has a null network. This indicates that saving or loading has failed.");
                continue;
            }
            UUID uuid = network.getUUID();
            class_2487 entry = new class_2487();
            entry.method_10544("pos", pipe.getBlockPos().method_10063());
            entry.method_25927("uuid", uuid);
            list.add((Object)entry);
        }
    }

    void savePipesToLoad(class_2499 list) {
        for (Pair pair : this.pipesToLoad) {
            class_2487 compound = new class_2487();
            compound.method_25927("uuid", (UUID)pair.first());
            compound.method_10544("pos", ((class_2338)pair.second()).method_10063());
            list.add((Object)compound);
        }
    }

    public boolean equals(Object o) {
        return false;
    }

    public Multimap<UUID, VascularConduitEntity> getPipes() {
        if (!this.pipesToLoad.isEmpty()) {
            this.pipes.clear();
            while (!this.pipesToLoad.isEmpty()) {
                Pair<UUID, class_2338> pair = this.pipesToLoad.poll();
                VascularConduitEntity entity = ((VascularConduitEntityProvider)this.chunk.method_8321((class_2338)pair.second())).get();
                if (entity == null) continue;
                this.loadedPipes.put((Object)((UUID)pair.first()), (Object)entity);
                this.pipes.add(entity);
            }
            this.chunk.method_12008(true);
        }
        return this.loadedPipes;
    }

    public void register(VascularConduitEntity vascularConduitEntity) {
        this.pipes.add(vascularConduitEntity);
        this.chunk.method_12008(true);
    }

    public void unregister(VascularConduitEntity vascularConduitEntity) {
        this.pipes.remove(vascularConduitEntity);
        this.chunk.method_12008(true);
    }
}

