/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.transport.fluid_network.node;

import com.neep.meatlib.api.event.InitialTicks;
import com.neep.neepmeat.api.FluidPump;
import com.neep.neepmeat.transport.fluid_network.FluidPipeVertex;
import com.neep.neepmeat.transport.fluid_network.PipeFlowComponent;
import com.neep.neepmeat.transport.fluid_network.node.AcceptorModes;
import com.neep.neepmeat.transport.fluid_network.node.NodePos;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiCache;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiLookup;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;

public class FluidNode
implements PipeFlowComponent {
    private final NodePos pos;
    @Nullable
    private FluidPump pump;
    public boolean hasPump;
    @Nullable
    private BlockApiCache<Storage<FluidVariant>, class_2350> storage;
    public boolean isStorage;
    public boolean needsDeferredLoading;
    protected float pumpHeight;

    public FluidNode(NodePos nodePos, class_3218 world) {
        this.pos = nodePos;
        this.isStorage = this.findStorage(world);
        this.hasPump = this.findPump(world);
    }

    protected FluidNode(NodePos pos, class_3218 world, boolean isStorage, boolean hasPump) {
        this.pos = pos;
        this.storage = null;
        this.pump = null;
        this.isStorage = isStorage;
        this.hasPump = hasPump;
        this.needsDeferredLoading = true;
        InitialTicks.getInstance(world).queue(this::loadDeferred);
    }

    public String toString() {
        return "\n" + this.pos.toString() + " " + String.valueOf(this.pos.face()) + " storage: " + String.valueOf(this.storage);
    }

    public static FluidNode fromNbt(class_2487 nbt, class_3218 world) {
        class_2487 posNbt = nbt.method_10562("pos");
        NodePos pos = NodePos.fromNbt(posNbt);
        boolean isStorage = nbt.method_10577("is_storage");
        boolean hasPump = nbt.method_10577("hasPump");
        return new FluidNode(pos, world, isStorage, hasPump);
    }

    public class_2487 writeNbt(class_2487 nbt) {
        nbt.method_10566("pos", (class_2520)this.pos.toNbt(new class_2487()));
        nbt.method_10556("is_storage", this.isStorage);
        nbt.method_10556("hasPump", this.hasPump);
        return nbt;
    }

    public void loadDeferred(class_3218 world) {
        this.load(world);
        if (this.hasPump && this.pump == null) {
            this.hasPump = false;
        }
        this.needsDeferredLoading = false;
    }

    private void load(class_3218 world) {
        if (!this.needsDeferredLoading || this.storage != null || !world.method_8503().method_18854()) {
            return;
        }
        boolean bl1 = this.findStorage(world);
        boolean bl2 = this.findPump(world);
    }

    public boolean findPump(class_3218 world) {
        FluidPump pump = (FluidPump)FluidPump.SIDED.find((class_1937)world, this.pos.facingBlock(), (Object)this.pos.face().method_10153());
        if (pump != null) {
            this.pump = pump;
            return true;
        }
        return false;
    }

    public boolean findStorage(class_3218 world) {
        this.storage = BlockApiCache.create((BlockApiLookup)FluidStorage.SIDED, (class_3218)world, (class_2338)this.pos.facingBlock());
        return this.storage.find((Object)this.pos.face().method_10153()) != null;
    }

    public NodePos getNodePos() {
        return this.pos;
    }

    public float getFlow() {
        if (this.hasPump) {
            return this.getPump().getFlow();
        }
        return this.getMode().getFlow();
    }

    public Storage<FluidVariant> getStorage(class_3218 world) {
        if (this.storage == null) {
            this.load(world);
        }
        if (this.storage == null) {
            return Storage.empty();
        }
        return (Storage)this.storage.find((Object)this.pos.face().method_10153());
    }

    public FluidPump getPump() {
        if (!this.hasPump) {
            return null;
        }
        return this.pump;
    }

    public AcceptorModes getMode() {
        if (this.hasPump) {
            return this.getPump().getMode();
        }
        return AcceptorModes.INSERT_EXTRACT;
    }

    public void setPumpHeight(float height) {
        this.pumpHeight = height;
    }

    public float getPumpHeight() {
        if (!this.hasPump || !this.getPump().getMode().isDriving()) {
            return this.pumpHeight;
        }
        return this.getPump().getPumpHeight();
    }

    @Override
    public long insert(int fromDir, int toDir, long maxAmount, class_3218 world, FluidVariant variant, TransactionContext transaction) {
        if (!variant.isBlank() && this.getStorage(world) != null) {
            return this.getStorage(world).insert((Object)variant, maxAmount, transaction);
        }
        return 0L;
    }

    @Override
    public int getConnectionDir(FluidPipeVertex from) {
        return this.pos.face().method_10153().ordinal();
    }
}

