/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.transport.item_network;

import com.neep.meatlib.util.NbtSerialisable;
import com.neep.meatlib.util.graph.ConnectablePipe;
import com.neep.meatlib.util.graph.PipeGraphUtil;
import com.neep.meatlib.util.graph.PipeVertex;
import com.neep.neepmeat.NeepMeat;
import com.neep.neepmeat.api.storage.WorldSupplier;
import com.neep.neepmeat.transport.api.pipe.ItemPipe;
import com.neep.neepmeat.transport.block.item_transport.entity.ItemPipeBlockEntity;
import com.neep.neepmeat.transport.item_network.ItemPipeGraphHelperImpl;
import com.neep.neepmeat.transport.item_network.ItemPipeVertex;
import it.unimi.dsi.fastutil.ints.IntArrays;
import java.util.Arrays;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.ResourceAmount;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;

public class ItemPipeVertexImpl
extends ItemPipeGraphHelperImpl
implements ItemPipeVertex,
NbtSerialisable {
    public static final int[] NORMAL_INDICES = new int[]{0, 1, 2, 3, 4, 5};
    private final ItemPipeVertex[] adjacentVertices = new ItemPipeVertex[6];
    private final int[] sortedIndices = Arrays.copyOf(NORMAL_INDICES, NORMAL_INDICES.length);
    protected final class_2586 parent;
    public boolean needsMigration;
    @Nullable
    private Long[] queuedPositions = null;

    public ItemPipeVertexImpl(class_2586 parent) {
        super(WorldSupplier.of(parent), () -> ((class_2586)parent).method_11010(), (ConnectablePipe)parent.method_11010().method_26204(), parent.method_11016());
        this.parent = parent;
    }

    @Override
    public ItemPipeVertex[] getAdjVertices() {
        if (this.needsMigration) {
            this.needsMigration = false;
            NeepMeat.LOGGER.info("Migrating ItemPipeVertex");
            if (!this.canSimplify()) {
                this.updateConnectionChange(this.getCachedState(), this.getCachedState());
            }
        }
        if (this.queuedPositions != null) {
            for (int dir = 0; dir < 6; ++dir) {
                if (this.queuedPositions[dir] == null) continue;
                this.adjacentVertices[dir] = ItemPipeVertex.find((class_3218)this.parent.method_10997(), class_2338.method_10092((long)this.queuedPositions[dir]));
            }
            this.queuedPositions = null;
            this.sort();
        }
        return this.adjacentVertices;
    }

    @Override
    public int[] getSortedIndices() {
        return this.sortedIndices;
    }

    @Override
    public boolean canSimplify() {
        class_2680 state = this.getCachedState();
        return this.numEdges() <= 2 && this.pipe.countConnections(state) <= 2 && !this.connectsToEndpoint();
    }

    private boolean connectsToEndpoint() {
        for (class_2350 face : this.pipe.getConnections(this.getCachedState()).directions()) {
            ItemPipe otherPipe = ItemPipe.findItemPipe(this.parent.method_10997().method_8320(this.getPos().method_10093(face)));
            if (otherPipe != null && otherPipe.endPoint()) {
                return true;
            }
            if (otherPipe != null) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setAdjVertex(int dir, PipeVertex vertex) {
        this.setAdjVertex(dir, (ItemPipeVertex)vertex);
    }

    private void sort() {
        this.getAdjVertices();
        IntArrays.quickSort((int[])this.sortedIndices, (i1, i2) -> Boolean.compare(this.adjacentVertices[i2] != null && this.adjacentVertices[i2].prioritise(), this.adjacentVertices[i1] != null && this.adjacentVertices[i1].prioritise()));
    }

    @Override
    public void setAdjVertex(int dir, ItemPipeVertex vertex) {
        this.adjacentVertices[dir] = vertex;
        this.sort();
    }

    @Override
    public void clearEdges() {
        for (int dir = 0; dir < 6; ++dir) {
            ItemPipeVertex adj = this.getAdjVertex(dir);
            if (adj == null) continue;
            for (int outDir = 0; outDir < 6; ++outDir) {
                if (adj.getAdjVertex(outDir) != this) continue;
                adj.setAdjVertex(outDir, null);
                PipeGraphUtil.jankParticles((class_3218)this.parent.method_10997(), adj, false);
            }
            this.setAdjVertex(dir, null);
        }
    }

    @Override
    @Nullable
    public ItemPipe getPipe() {
        return (ItemPipe)this.pipe;
    }

    @Override
    public boolean canItemEnter(ItemVariant variant, long amount, class_2350 inFace) {
        return this.getPipe().canItemEnter(variant, amount, (class_1937)this.world.get(), this.getPos(), this.getCachedState(), inFace);
    }

    @Override
    public boolean canItemLeave(ResourceAmount<ItemVariant> resource, class_2350 face) {
        return this.getPipe().canItemLeave(resource, (class_1937)this.world.get(), this.getPos(), this.getCachedState(), face);
    }

    @Override
    public boolean isConnected(class_2350 face) {
        return this.pipe.isConnected((class_1922)this.world.get(), this.getPos(), this.getCachedState(), face);
    }

    @Override
    public class_2350 getDirection(ItemPipeVertex vertex) {
        this.getAdjVertices();
        for (int i = 0; i < 6; ++i) {
            if (this.adjacentVertices[i] != vertex) continue;
            return class_2350.values()[i];
        }
        return class_2350.field_11043;
    }

    @Override
    @Nullable
    public Storage<ItemVariant> getStorage(class_2350 direction) {
        class_2586 class_25862 = this.parent;
        if (class_25862 instanceof ItemPipeBlockEntity) {
            ItemPipeBlockEntity ipbe = (ItemPipeBlockEntity)class_25862;
            return ipbe.getStorage(direction);
        }
        return null;
    }

    @Override
    public boolean prioritise() {
        return ((ItemPipe)this.pipe).prioritise();
    }

    @Override
    public int getCurrentOutput(class_2350 inFace) {
        class_2586 class_25862 = this.parent;
        if (class_25862 instanceof ItemPipeBlockEntity) {
            ItemPipeBlockEntity be = (ItemPipeBlockEntity)class_25862;
            return be.getCurrentOutput(this.connections.with(inFace, false));
        }
        return -1;
    }

    @Override
    public void nextOutput(class_2350 inFace) {
        class_2586 class_25862 = this.parent;
        if (class_25862 instanceof ItemPipeBlockEntity) {
            ItemPipeBlockEntity be = (ItemPipeBlockEntity)class_25862;
            be.nextOutput(this.connections.with(inFace, false));
        }
    }

    protected int numEdges() {
        if (this.needsMigration) {
            return 0;
        }
        int edges = 0;
        for (ItemPipeVertex vertex : this.getAdjVertices()) {
            if (vertex == null) continue;
            ++edges;
        }
        return edges;
    }

    @Override
    public class_2487 writeNbt(class_2487 nbt) {
        class_2499 adjacent = new class_2499();
        for (int dir = 0; dir < 6; ++dir) {
            class_2487 adjNbt = new class_2487();
            adjacent.add((Object)adjNbt);
            if (this.queuedPositions != null) {
                if (this.queuedPositions[dir] == null) continue;
                adjNbt.method_10544("pos", this.queuedPositions[dir].longValue());
                continue;
            }
            ItemPipeVertex adj = this.getAdjVertex(dir);
            if (adj == null) continue;
            adjNbt.method_10544("pos", adj.getPos().method_10063());
        }
        nbt.method_10566("adjacent", (class_2520)adjacent);
        return nbt;
    }

    @Override
    public void readNbt(class_2487 nbt) {
        class_2499 adjacent = nbt.method_10554("adjacent", 10);
        this.queuedPositions = new Long[6];
        for (int dir = 0; dir < 6; ++dir) {
            class_2487 adjNbt = adjacent.method_10602(dir);
            if (!adjNbt.method_10545("pos")) continue;
            this.queuedPositions[dir] = adjNbt.method_10537("pos");
        }
    }
}

