/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.transport.item_network;

import com.neep.neepmeat.transport.api.PipeCache;
import com.neep.neepmeat.transport.item_network.ItemInPipe;
import com.neep.neepmeat.transport.item_network.ItemPipeVertex;
import com.neep.neepmeat.transport.item_network.ItemRoute;
import com.neep.neepmeat.transport.item_network.PipeRouteFinder;
import com.neep.neepmeat.transport.util.ItemPipeUtil;
import com.neep.neepmeat.transport.util.PipePathfinding;
import it.unimi.dsi.fastutil.objects.ObjectHeapPriorityQueue;
import java.util.HashMap;
import java.util.HashSet;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.ResourceAmount;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_3218;

public class PipeCacheImpl
implements PipeCache {
    protected final class_3218 world;

    public PipeCacheImpl(class_3218 world) {
        this.world = world;
    }

    @Override
    public boolean retrieve(class_2338 to, class_2350 in, ItemVariant variant, long amount, TransactionContext transaction) {
        return false;
    }

    @Override
    public long eject(class_2338 from, class_2350 out, ItemVariant variant, long amount, TransactionContext transaction) {
        return 0L;
    }

    @Override
    public long route(class_2338 from, class_2350 in, class_2338 to, class_2350 out, ItemVariant variant, long amount, TransactionContext transaction) {
        ItemInPipe item = new ItemInPipe(null, null, variant, (int)amount, this.world.method_8510());
        class_2338 fromPos = from.method_10093(in);
        ItemRoute route = this.findPath((ResourceAmount<ItemVariant>)new ResourceAmount((Object)variant, amount), fromPos, to, out);
        item.setRoute(route);
        return ItemPipeUtil.EjectOperation.of((class_1937)this.world, from, in).useRouting(false).pipeToAny(item, transaction).amount();
    }

    public long route(class_2338 from, class_2350 in, ItemRoute route, ItemVariant variant, long amount, TransactionContext transaction) {
        ItemInPipe item = new ItemInPipe(null, null, variant, (int)amount, this.world.method_8510());
        item.setRoute(route);
        return ItemPipeUtil.EjectOperation.of((class_1937)this.world, from, in).useRouting(false).pipeToAny(item, transaction).amount();
    }

    public ItemRoute findPath(ResourceAmount<ItemVariant> item, class_2338 startPos, class_2338 endPos, class_2350 endFace) {
        ItemPipeVertex startVertex = ItemPipeVertex.find(this.world, startPos);
        HashMap<ItemPipeVertex, PipeRouteFinder.Node> vertexToNode = new HashMap<ItemPipeVertex, PipeRouteFinder.Node>();
        HashSet<ItemPipeVertex> visited = new HashSet<ItemPipeVertex>();
        ObjectHeapPriorityQueue frontier = new ObjectHeapPriorityQueue();
        PipeRouteFinder.Node startNode = vertexToNode.computeIfAbsent(startVertex, PipeRouteFinder.Node::new);
        visited.add(startVertex);
        frontier.enqueue((Object)startNode);
        while (!frontier.isEmpty()) {
            PipeRouteFinder.Node node = (PipeRouteFinder.Node)frontier.dequeue();
            if (node.vertex.getPos().equals((Object)endPos)) {
                return PipePathfinding.makeRoute(this.world, node, endFace);
            }
            for (int dir = 0; dir < 6; ++dir) {
                ItemPipeVertex adj;
                class_2350 face = class_2350.values()[dir];
                if (!node.vertex.canItemLeave(item, face) || (adj = node.vertex.getAdjVertex(dir)) == null) continue;
                PipeRouteFinder.Node child = vertexToNode.computeIfAbsent(adj, PipeRouteFinder.Node::new);
                if (visited.contains(adj)) continue;
                visited.add(adj);
                class_2350 enterDirection = adj.getDirection(node.vertex);
                if (!adj.canItemEnter((ItemVariant)item.resource(), item.amount(), enterDirection)) continue;
                child.cost = node.cost;
                if (child.vertex.prioritise()) {
                    --child.cost;
                }
                child.parent = node;
                child.parentOutFace = face;
                frontier.enqueue((Object)child);
            }
        }
        return ItemRoute.EMPTY;
    }
}

