/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.util;

import net.minecraft.class_243;
import net.minecraft.class_3532;

public class Bezier {
    protected static long[][] PASCAL_TRIANGLE = Bezier.pascal(10);

    protected static long[][] pascal(int rows) {
        long[][] triangle = new long[rows][];
        for (int row = 1; row <= rows; ++row) {
            triangle[row - 1] = new long[row];
            int k = 1;
            for (int col = 1; col <= row; ++col) {
                triangle[row - 1][col - 1] = k;
                k = k * (row - col) / col;
            }
        }
        return triangle;
    }

    public static double bezier(int n, double t, double ... weights) {
        int sum = 0;
        for (int k = 0; k < n; ++k) {
            sum = (int)((double)sum + (double)Bezier.binomial(n, k) * Math.pow(1.0 - t, n - k) * Math.pow(t, k) * weights[k]);
        }
        return sum;
    }

    public static double bezier2(double t, double ... weights) {
        double t2 = t * t;
        double mt = 1.0 - t;
        double mt2 = mt * mt;
        return weights[0] * mt2 + weights[1] * 2.0 * mt * t + weights[2] * t2;
    }

    public static double bezier3(double t, double ... weights) {
        double t2 = t * t;
        double t3 = t2 * t;
        double mt = 1.0 - t;
        double mt2 = mt * mt;
        double mt3 = mt2 * mt;
        return weights[0] * mt3 + weights[1] * 3.0 * mt2 * t + weights[2] * 3.0 * mt * t2 + weights[3] * t3;
    }

    public static double derivative3(double t, double ... weights) {
        return Bezier.bezier2(t, 3.0 * (weights[1] - weights[0]), 3.0 * (weights[2] - weights[1]), 3.0 * (weights[3] - weights[2]));
    }

    protected static long binomial(int n, int r) {
        if (n >= PASCAL_TRIANGLE.length || r >= PASCAL_TRIANGLE[n].length) {
            throw new IllegalArgumentException();
        }
        return PASCAL_TRIANGLE[n][r];
    }

    public static class Cubic3 {
        protected double[][] points = new double[][]{{0.0, 0.0, 0.0}, {0.0, 0.0, 0.0}, {0.0, 0.0, 0.0}, {0.0, 0.0, 0.0}};
        protected boolean sampled = false;
        protected double length;
        protected int samples;
        protected class_243[] distanceSamples;
        private double[] distanceToT;

        public Cubic3(int samples) {
            this.samples = samples;
        }

        public void setPoint(int point, double ... weights) {
            this.points[point] = weights;
            this.sampled = false;
        }

        public class_243 value(double t) {
            return new class_243(Bezier.bezier3(t, this.points[0][0], this.points[1][0], this.points[2][0], this.points[3][0]), Bezier.bezier3(t, this.points[0][1], this.points[1][1], this.points[2][1], this.points[3][1]), Bezier.bezier3(t, this.points[0][2], this.points[1][2], this.points[2][2], this.points[3][2]));
        }

        public double tForDistance(double distance) {
            return this.arrayInterpolate(this.distanceToT, (double)this.samples * distance / this.length());
        }

        public class_243 derivative(double t) {
            return new class_243(Bezier.derivative3(t, this.points[0][0], this.points[1][0], this.points[2][0], this.points[3][0]), Bezier.derivative3(t, this.points[0][1], this.points[1][1], this.points[2][1], this.points[3][1]), Bezier.derivative3(t, this.points[0][2], this.points[1][2], this.points[2][2], this.points[3][2]));
        }

        public double length() {
            if (!this.sampled) {
                this.estimateLength();
            }
            return this.length;
        }

        protected void estimateLength() {
            this.distanceToT = new double[this.samples + 1];
            double[] ts = new double[this.samples + 1];
            double[] lengths = new double[this.samples + 1];
            double tInterval = 1.0 / (double)this.samples;
            int i = 0;
            class_243 prevPoint = this.value(0.0);
            for (double t = 0.0; t <= 1.0; t += tInterval) {
                class_243 nextPoint = this.value(t);
                ts[i] = t;
                this.length += prevPoint.method_1022(nextPoint);
                lengths[i] = this.length;
                prevPoint = nextPoint;
                ++i;
            }
            double s = 0.0;
            double sInterval = this.length / (double)this.samples;
            int j = 0;
            while (j < ts.length) {
                this.distanceToT[j] = this.thingy(lengths, ts, s);
                ++j;
                s += sInterval;
            }
            this.sampled = true;
        }

        protected double thingy(double[] xs, double[] ys, double x) {
            int j = 0;
            for (int i = 0; i < xs.length; ++i) {
                if (!(Math.abs(xs[i] - x) < Math.abs(xs[j] - x))) continue;
                j = i;
            }
            double fraction = j < xs.length - 1 ? (x - xs[j]) / (xs[j + 1] - xs[j]) : 0.0;
            return this.arrayInterpolate(ys, (double)j + fraction);
        }

        protected double arrayInterpolate(double[] array, double index) {
            int lowerIndex = (int)Math.floor(index);
            if (lowerIndex == array.length - 1) {
                return array[lowerIndex];
            }
            int higherIndex = (int)Math.ceil(index);
            return class_3532.method_16436((double)(index - (double)lowerIndex), (double)array[lowerIndex], (double)array[higherIndex]);
        }
    }
}

