/*
 * Decompiled with CFR 0.152.
 */
package group.aelysium.rustyconnector;

import group.aelysium.rustyconnector.RustyConnector;
import group.aelysium.rustyconnector.common.RCAdapter;
import group.aelysium.rustyconnector.common.RCKernel;
import group.aelysium.rustyconnector.common.errors.Error;
import group.aelysium.rustyconnector.common.errors.ErrorRegistry;
import group.aelysium.rustyconnector.common.events.EventManager;
import group.aelysium.rustyconnector.common.haze.HazeDatabase;
import group.aelysium.rustyconnector.common.haze.HazeProvider;
import group.aelysium.rustyconnector.common.lang.LangLibrary;
import group.aelysium.rustyconnector.common.lang.LangNode;
import group.aelysium.rustyconnector.common.magic_link.MagicLinkCore;
import group.aelysium.rustyconnector.common.modules.Module;
import group.aelysium.rustyconnector.proxy.ProxyAdapter;
import group.aelysium.rustyconnector.proxy.ProxyKernel;
import group.aelysium.rustyconnector.proxy.family.Family;
import group.aelysium.rustyconnector.proxy.family.FamilyRegistry;
import group.aelysium.rustyconnector.proxy.family.Server;
import group.aelysium.rustyconnector.proxy.player.Player;
import group.aelysium.rustyconnector.proxy.player.PlayerRegistry;
import group.aelysium.rustyconnector.server.ServerAdapter;
import group.aelysium.rustyconnector.server.ServerKernel;
import group.aelysium.rustyconnector.shaded.group.aelysium.ara.Flux;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;

public interface RC {
    public static RCKernel<? extends RCAdapter> Kernel() throws NoSuchElementException {
        try {
            return S.Kernel();
        }
        catch (Exception exception) {
            try {
                return P.Kernel();
            }
            catch (Exception exception2) {
                throw new NoSuchElementException("No RustyConnector kernels currently exist.");
            }
        }
    }

    public static void Error(@NotNull Error error) throws NoSuchElementException {
        try {
            RC.Errors().register(error);
        }
        catch (Exception ignore) {
            if (error.throwable() != null) {
                error.throwable().printStackTrace();
                return;
            }
            System.out.println(error.message());
        }
    }

    public static ErrorRegistry Errors() throws NoSuchElementException {
        try {
            return S.Errors();
        }
        catch (Exception exception) {
            try {
                return P.Errors();
            }
            catch (Exception exception2) {
                throw new NoSuchElementException("The requested ErrorRegistry doesn't exist.");
            }
        }
    }

    public static LangLibrary Lang() throws NoSuchElementException {
        try {
            return S.Lang();
        }
        catch (Exception exception) {
            try {
                return P.Lang();
            }
            catch (Exception exception2) {
                throw new NoSuchElementException("The requested LangLibrary doesn't exist.");
            }
        }
    }

    public static LangNode Lang(String id) throws NoSuchElementException {
        return RC.Lang().lang(id);
    }

    public static EventManager EventManager() throws NoSuchElementException {
        try {
            return S.EventManager();
        }
        catch (Exception exception) {
            try {
                return P.EventManager();
            }
            catch (Exception exception2) {
                throw new NoSuchElementException("The requested EventManager doesn't exist.");
            }
        }
    }

    public static MagicLinkCore MagicLink() throws NoSuchElementException {
        try {
            return S.MagicLink();
        }
        catch (Exception exception) {
            try {
                return P.MagicLink();
            }
            catch (Exception exception2) {
                throw new NoSuchElementException("The requested MagicLink provider doesn't exist.");
            }
        }
    }

    public static RCAdapter Adapter() throws NoSuchElementException {
        try {
            return S.Adapter();
        }
        catch (Exception exception) {
            try {
                return P.Adapter();
            }
            catch (Exception exception2) {
                throw new NoSuchElementException("The requested adapter doesn't exist.");
            }
        }
    }

    public static HazeProvider Haze() throws NoSuchElementException {
        try {
            return S.Haze();
        }
        catch (Exception exception) {
            try {
                return P.Haze();
            }
            catch (Exception exception2) {
                throw new NoSuchElementException("The requested Haze provider doesn't exist.");
            }
        }
    }

    public static Optional<? extends HazeDatabase> Haze(String name) throws NoSuchElementException {
        try {
            return S.Haze(name);
        }
        catch (Exception exception) {
            try {
                return P.Haze(name);
            }
            catch (Exception exception2) {
                throw new NoSuchElementException("The requested Haze database doesn't exist.");
            }
        }
    }

    public static <M extends Module> M Module(@NotNull String moduleName) throws NoSuchElementException {
        return (M)((Module)RC.ModuleFlux(moduleName).orElseThrow(() -> new NoSuchElementException(moduleName + " is not currently available. It might be rebooting.")));
    }

    public static <M extends Module> Flux<M> ModuleFlux(@NotNull String moduleName) throws NoSuchElementException {
        Flux f = RC.Kernel().fetchModule(moduleName);
        if (f == null) {
            throw new NoSuchElementException(moduleName + " is not currently available. It might be rebooting.");
        }
        return f;
    }

    public static boolean checkAvailability(@NotNull String moduleName) {
        try {
            RC.Kernel().fetchModule(moduleName).orElseThrow();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static interface S {
        public static ServerKernel Kernel() throws NoSuchElementException {
            Flux<RCKernel<? extends RCAdapter>> flux = RustyConnector.kernel.get();
            if (flux == null) {
                throw new NoSuchElementException("No Server Kernel has been registered for RustyConnector.");
            }
            if (flux.isEmpty()) {
                throw new NoSuchElementException("The RustyConnector Server Kernel is currently unavailable. It might be rebooting.");
            }
            return (ServerKernel)flux.orElseThrow();
        }

        public static MagicLinkCore.Server MagicLink() throws NoSuchElementException {
            return (MagicLinkCore.Server)RC.Module("MagicLink");
        }

        public static ServerAdapter Adapter() throws NoSuchElementException {
            return (ServerAdapter)S.Kernel().Adapter();
        }

        public static LangLibrary Lang() throws NoSuchElementException {
            return (LangLibrary)RC.Module("LangLibrary");
        }

        public static EventManager EventManager() throws NoSuchElementException {
            return (EventManager)RC.Module("EventManager");
        }

        public static ErrorRegistry Errors() {
            return (ErrorRegistry)RC.Module("ErrorRegistry");
        }

        public static HazeProvider Haze() throws NoSuchElementException {
            return (HazeProvider)RC.Module("Haze");
        }

        public static Optional<HazeDatabase> Haze(String name) throws NoSuchElementException {
            Flux<HazeDatabase> flux = S.Haze().fetchDatabase(name);
            if (flux == null) {
                return Optional.empty();
            }
            return Optional.of(flux.orElseThrow());
        }
    }

    public static interface P {
        public static ProxyKernel Kernel() throws NoSuchElementException {
            Flux<RCKernel<? extends RCAdapter>> flux = RustyConnector.kernel.get();
            if (flux == null) {
                throw new NoSuchElementException("No Proxy Kernel has been registered for RustyConnector.");
            }
            if (flux.isEmpty()) {
                throw new NoSuchElementException("The RustyConnector Proxy Kernel is currently unavailable. It might be rebooting.");
            }
            return (ProxyKernel)flux.orElseThrow();
        }

        public static FamilyRegistry Families() throws NoSuchElementException {
            return (FamilyRegistry)RC.Module("FamilyRegistry");
        }

        public static PlayerRegistry Players() throws NoSuchElementException {
            return (PlayerRegistry)RC.Module("PlayerRegistry");
        }

        public static MagicLinkCore.Proxy MagicLink() throws NoSuchElementException {
            return (MagicLinkCore.Proxy)RC.Module("MagicLink");
        }

        public static EventManager EventManager() throws NoSuchElementException {
            return (EventManager)RC.Module("EventManager");
        }

        public static HazeProvider Haze() throws NoSuchElementException {
            return (HazeProvider)RC.Module("Haze");
        }

        public static ProxyAdapter Adapter() throws NoSuchElementException {
            return (ProxyAdapter)P.Kernel().Adapter();
        }

        public static LangLibrary Lang() throws NoSuchElementException {
            return (LangLibrary)RC.Module("LangLibrary");
        }

        public static ErrorRegistry Errors() {
            return (ErrorRegistry)RC.Module("ErrorRegistry");
        }

        public static Optional<Family> Family(String id) throws NoSuchElementException {
            try {
                return Optional.ofNullable((Family)P.Families().find(id).orElseThrow(() -> new NoSuchElementException("The family " + id + " is not currently available. it might be rebooting.")));
            }
            catch (NullPointerException nullPointerException) {
                throw new NoSuchElementException("No family with the id " + id + " exists.");
            }
        }

        public static Optional<Family> Family(Server server) throws NoSuchElementException {
            for (Flux<Family> f : P.Families().modules().values()) {
                try {
                    Family family = f.orElseThrow();
                    if (!family.containsServer(server.id())) continue;
                    return Optional.of(family);
                }
                catch (Exception exception) {
                }
            }
            return Optional.empty();
        }

        public static Optional<Server> Server(String id) throws NoSuchElementException {
            AtomicReference<Object> server = new AtomicReference<Object>(null);
            P.Families().modules().values().forEach(flux -> flux.ifPresent(f -> f.fetchServer(id).ifPresent(server::set)));
            return Optional.ofNullable(server.get());
        }

        public static List<Server> Servers() throws NoSuchElementException {
            ArrayList servers = new ArrayList();
            P.Families().modules().values().forEach(flux -> flux.ifPresent(f -> servers.addAll(f.servers())));
            return Collections.unmodifiableList(servers);
        }

        public static Optional<Player> PlayerFromID(String id) throws NoSuchElementException {
            return P.Players().fetchByID(id);
        }

        public static Optional<Player> PlayerFromUsername(String username) throws NoSuchElementException {
            return P.Players().fetchByUsername(username);
        }

        public static Optional<HazeDatabase> Haze(String name) throws NoSuchElementException {
            Flux<HazeDatabase> flux = P.Haze().fetchDatabase(name);
            if (flux == null) {
                return Optional.empty();
            }
            return Optional.of(flux.orElseThrow());
        }
    }
}

