/*
 * Decompiled with CFR 0.152.
 */
package group.aelysium.rustyconnector;

import group.aelysium.rustyconnector.common.RCAdapter;
import group.aelysium.rustyconnector.common.RCKernel;
import group.aelysium.rustyconnector.common.modules.Module;
import group.aelysium.rustyconnector.shaded.group.aelysium.ara.Flux;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class RustyConnector {
    private static final List<Consumer<Flux<RCKernel<? extends RCAdapter>>>> onStartHandlers = new Vector<Consumer<Flux<RCKernel<? extends RCAdapter>>>>();
    protected static final AtomicReference<Flux<RCKernel<? extends RCAdapter>>> kernel = new AtomicReference<Object>(null);

    public static void Kernel(Consumer<Flux<RCKernel<? extends RCAdapter>>> consumer) {
        onStartHandlers.add(consumer);
        if (kernel.get() == null) {
            return;
        }
        try {
            consumer.accept(kernel.get());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Flux<RCKernel<? extends RCAdapter>> Kernel() throws NoSuchElementException {
        return Optional.ofNullable(kernel.get()).orElseThrow();
    }

    public static void registerAndIgnite(@NotNull Flux<RCKernel<? extends RCAdapter>> flux) throws IllegalAccessError, Exception {
        Flux<RCKernel<? extends RCAdapter>> kernelInstance = kernel.get();
        if (kernelInstance != null) {
            throw new IllegalAccessError("The RustyConnector kernel has already been established.");
        }
        kernel.set(flux);
        flux.build();
        onStartHandlers.forEach(t -> {
            try {
                t.accept(flux);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    public static void unregister() throws Exception {
        Flux<RCKernel<? extends RCAdapter>> kernelInstance = kernel.get();
        if (kernelInstance == null) {
            return;
        }
        kernelInstance.close();
        kernel.set(null);
    }

    public static Class<?> getGenericType(Flux<Module> flux) {
        Type type = flux.getClass().getGenericSuperclass();
        if (!(type instanceof ParameterizedType)) {
            return null;
        }
        ParameterizedType type2 = (ParameterizedType)type;
        return (Class)type2.getActualTypeArguments()[0];
    }
}

