/*
 * Decompiled with CFR 0.152.
 */
package group.aelysium.rustyconnector.common.algorithm;

import group.aelysium.rustyconnector.proxy.family.load_balancing.ISortable;
import java.util.List;

public class QuickSort {
    static <I extends ISortable> void swap(List<I> array, int i, int j) {
        ISortable temp = (ISortable)array.get(i);
        array.set(i, (ISortable)array.get(j));
        array.set(j, temp);
    }

    static int partition(List<? extends ISortable> array, int low, int high) {
        double pivot = array.get(high).sortIndex();
        int i = low - 1;
        for (int j = low; j <= high - 1; ++j) {
            if (!(array.get(j).sortIndex() < pivot)) continue;
            QuickSort.swap(array, ++i, j);
        }
        QuickSort.swap(array, i + 1, high);
        return i + 1;
    }

    static void innerSort(List<? extends ISortable> array, int start, int end) {
        if (start < end) {
            int partitionIndex = QuickSort.partition(array, start, end);
            QuickSort.innerSort(array, start, partitionIndex - 1);
            QuickSort.innerSort(array, partitionIndex + 1, end);
        }
    }

    public static void sort(List<? extends ISortable> array) {
        QuickSort.innerSort(array, 0, array.size() - 1);
    }
}

