/*
 * Decompiled with CFR 0.152.
 */
package group.aelysium.rustyconnector.common.algorithm;

import group.aelysium.rustyconnector.proxy.family.load_balancing.ISortable;
import java.util.Collections;
import java.util.List;

public class WeightOnlyQuickSort {
    static <I extends ISortable> void swap(List<I> array, int i, int j) {
        ISortable temp = (ISortable)array.get(i);
        array.set(i, (ISortable)array.get(j));
        array.set(j, temp);
    }

    static int partition(List<? extends ISortable> array, int low, int high) {
        int pivot = array.get(high).weight();
        int i = low - 1;
        for (int j = low; j <= high - 1; ++j) {
            if (array.get(j).weight() >= pivot) continue;
            WeightOnlyQuickSort.swap(array, ++i, j);
        }
        WeightOnlyQuickSort.swap(array, i + 1, high);
        return i + 1;
    }

    static void innerSort(List<? extends ISortable> array, int start, int end) {
        if (start < end) {
            int partitionIndex = WeightOnlyQuickSort.partition(array, start, end);
            WeightOnlyQuickSort.innerSort(array, start, partitionIndex - 1);
            WeightOnlyQuickSort.innerSort(array, partitionIndex + 1, end);
            Collections.reverse(array);
        }
    }

    public static void sort(List<? extends ISortable> array) {
        WeightOnlyQuickSort.innerSort(array, 0, array.size() - 1);
    }
}

