/*
 * Decompiled with CFR 0.152.
 */
package group.aelysium.rustyconnector.common.crypt;

import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.EncodedKeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import javax.crypto.Cipher;
import org.jetbrains.annotations.NotNull;

public class ECC {
    private final PublicKey publicKey;
    private final PrivateKey privateKey;

    protected ECC(PublicKey publicKey, PrivateKey privateKey) {
        this.publicKey = publicKey;
        this.privateKey = privateKey;
    }

    public String encrypt(String value) throws Exception {
        Cipher cipher = Cipher.getInstance("ECIES", "BC");
        cipher.init(1, this.publicKey);
        return new String(cipher.doFinal(value.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
    }

    public String decrypt(String value) throws Exception {
        Cipher cipher = Cipher.getInstance("ECIES", "BC");
        cipher.init(2, this.privateKey);
        return new String(cipher.doFinal(value.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
    }

    public static ECC fromResource(@NotNull String resourcePath) {
        PrivateKey privateKey;
        PublicKey publicKey;
        try {
            KeyFactory keyFactory;
            EncodedKeySpec spec;
            byte[] decoded;
            String keyString;
            byte[] keyBytes;
            try (InputStream is = ECC.class.getResourceAsStream(resourcePath);){
                keyBytes = is.readAllBytes();
                keyString = new String(keyBytes, StandardCharsets.UTF_8).replaceAll("-----[A-Za-z\\s]*-----", "").replaceAll("\\s+", "");
                decoded = Base64.getDecoder().decode(keyString);
                spec = new X509EncodedKeySpec(decoded);
                keyFactory = KeyFactory.getInstance("EC");
                publicKey = keyFactory.generatePublic(spec);
            }
            is = ECC.class.getResourceAsStream(resourcePath);
            try {
                keyBytes = is.readAllBytes();
                keyString = new String(keyBytes, StandardCharsets.UTF_8).replaceAll("-----[A-Za-z\\s]*-----", "").replaceAll("\\s+", "");
                decoded = Base64.getDecoder().decode(keyString);
                spec = new PKCS8EncodedKeySpec(decoded);
                keyFactory = KeyFactory.getInstance("EC");
                privateKey = keyFactory.generatePrivate(spec);
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return new ECC(publicKey, privateKey);
    }
}

