/*
 * Decompiled with CFR 0.152.
 */
package group.aelysium.rustyconnector.common.crypt;

import group.aelysium.rustyconnector.shaded.com.aventrix.jnanoid.jnanoid.jnanoid.NanoIdUtils;
import java.util.Objects;
import java.util.Random;

public class NanoID {
    private static final Random random = new Random();
    private static final int LENGTH = 16;
    private static final String ALPHABET = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private final String value;

    protected NanoID(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NanoID id = (NanoID)o;
        return Objects.equals(this.value, id.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public static NanoID fromString(String value) {
        String regex2 = "[0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ]+";
        if (value.length() > 16) {
            throw new IllegalArgumentException("Couldn't parse value as NanoID! Value was to long!");
        }
        if (!value.matches(regex2)) {
            throw new IllegalArgumentException("Couldn't parse value as NanoID! Value contained invalid characters.");
        }
        return new NanoID(value);
    }

    public static NanoID randomNanoID() {
        return NanoID.randomNanoID(16, ALPHABET);
    }

    public static NanoID randomNanoID(int length) {
        return NanoID.randomNanoID(length, ALPHABET);
    }

    public static NanoID randomNanoID(int length, String alphabet) {
        return new NanoID(NanoIdUtils.randomNanoId(random, alphabet.toCharArray(), length));
    }
}

