/*
 * Decompiled with CFR 0.152.
 */
package group.aelysium.rustyconnector.common.errors;

import group.aelysium.rustyconnector.RC;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.JoinConfiguration;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.event.KeyValuePair;

public class Error {
    private final UUID uuid = UUID.randomUUID();
    private final Instant createdAt = Instant.now();
    private final Throwable throwable;
    private final String message;
    private final String hint;
    private final String solution;
    private final List<KeyValuePair> details = new ArrayList<KeyValuePair>();
    private boolean urgent = false;

    protected Error(@NotNull String message, @Nullable String hint, @Nullable String solution) {
        this.throwable = null;
        this.message = message;
        this.hint = hint;
        this.solution = solution;
    }

    protected Error(@NotNull Throwable throwable, @Nullable String hint, @Nullable String solution) {
        this.throwable = throwable;
        this.message = throwable.getMessage() == null ? "No message was provided by the causing exception." : throwable.getMessage();
        this.causedBy(throwable.getClass().getName());
        this.hint = hint;
        this.solution = solution;
    }

    @NotNull
    public UUID uuid() {
        return this.uuid;
    }

    @NotNull
    public Instant createdAt() {
        return this.createdAt;
    }

    @Nullable
    public Throwable throwable() {
        return this.throwable;
    }

    @NotNull
    public String message() {
        return this.message;
    }

    @Nullable
    public String hint() {
        return this.hint;
    }

    @Nullable
    public String solution() {
        return this.solution;
    }

    @NotNull
    public List<KeyValuePair> details() {
        return Collections.unmodifiableList(this.details);
    }

    public Error detail(@NotNull String key, @NotNull Object value) {
        this.details.removeAll(this.details.stream().filter(e -> e.key.equals(key)).toList());
        this.details.add(new KeyValuePair(key, value));
        return this;
    }

    public Error wrongValue(@NotNull Object expectedValue, @NotNull Object providedValue) {
        this.detail("Expected Value", expectedValue);
        this.detail("Provided Value", providedValue);
        return this;
    }

    public Error causedBy(@NotNull String causedBy) {
        this.detail("Caused By", causedBy);
        return this;
    }

    public Error whileAttempting(@NotNull String whileAttempting) {
        this.detail("While Attempting", whileAttempting);
        return this;
    }

    public Error exampleUsage(@NotNull String exampleUssage) {
        this.detail("Example Usage", exampleUssage);
        return this;
    }

    public Error urgent(boolean urgent) {
        this.urgent = urgent;
        return this;
    }

    public boolean urgent() {
        return this.urgent;
    }

    public Component toComponent() {
        try {
            return RC.Lang("rustyconnector-error").generate(this);
        }
        catch (Exception ignore) {
            return Error.serializeError(this);
        }
    }

    public static Error from(@NotNull String message) {
        return new Error(message, null, null);
    }

    public static Error withHint(@NotNull String message, @NotNull String hint) {
        return new Error(message, hint, null);
    }

    public static Error withSolution(@NotNull String message, @NotNull String solution) {
        return new Error(message, null, solution);
    }

    public static Error from(@NotNull Throwable throwable) {
        return new Error(throwable, null, null);
    }

    public static Error withHint(@NotNull Throwable throwable, @NotNull String hint) {
        return new Error(throwable, hint, null);
    }

    public static Error withSolution(@NotNull Throwable throwable, @NotNull String solution) {
        return new Error(throwable, null, solution);
    }

    private static Component serializeError(Error error) {
        try {
            ArrayList<Object> extras = new ArrayList<Object>();
            ZonedDateTime zonedDateTime = error.createdAt().atZone(ZoneId.systemDefault());
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            String formattedDateTime = zonedDateTime.format(formatter);
            extras.add(Component.join((JoinConfiguration)JoinConfiguration.newlines(), (ComponentLike[])new ComponentLike[]{Component.text((String)"RustyConnector", (TextColor)NamedTextColor.BLUE).append((Component)Component.text((String)(" [" + formattedDateTime + "]"), (TextColor)NamedTextColor.DARK_GRAY)), Component.text((String)error.message(), (TextColor)NamedTextColor.GRAY)}));
            TextComponent hintOrSolution = Component.space();
            if (error.hint() != null) {
                hintOrSolution = hintOrSolution.appendNewline().append(Component.text((String)"Hint: ", (TextColor)NamedTextColor.BLUE).append((Component)Component.text((String)error.hint(), (TextColor)NamedTextColor.GRAY)));
            }
            if (error.solution() != null) {
                hintOrSolution = hintOrSolution.appendNewline().append(Component.text((String)"Solution: ", (TextColor)NamedTextColor.BLUE).append((Component)Component.text((String)error.solution(), (TextColor)NamedTextColor.GRAY)));
            }
            extras.add(hintOrSolution);
            if (error.throwable() != null) {
                error.causedBy(error.throwable().getClass().getSimpleName());
            }
            if (!error.details().isEmpty()) {
                extras.add(Component.text((String)"Details: ", (TextColor)NamedTextColor.BLUE));
                extras.add(Component.join((JoinConfiguration)JoinConfiguration.newlines(), error.details().stream().map(e -> (TextComponent)Component.text((String)" \u2022 ", (TextColor)NamedTextColor.DARK_GRAY).append((Component)Component.text((String)(e.key + ": " + String.valueOf(e.value)), (TextColor)NamedTextColor.BLUE))).toList()));
            }
            return Component.join((JoinConfiguration)JoinConfiguration.newlines(), (ComponentLike[])new ComponentLike[]{Component.space(), Component.space(), Component.join((JoinConfiguration)JoinConfiguration.newlines(), extras), Component.space()});
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return Component.space();
        }
    }
}

