/*
 * Decompiled with CFR 0.152.
 */
package group.aelysium.rustyconnector.common.errors;

import group.aelysium.rustyconnector.RC;
import group.aelysium.rustyconnector.common.errors.Error;
import group.aelysium.rustyconnector.common.modules.Module;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.Vector;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.JoinConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ErrorRegistry
implements Module {
    private final boolean logErrors;
    private final int cacheSize;
    private final Vector<Error> errors = new Vector<Error>(){

        @Override
        public synchronized boolean add(Error element) {
            if (this.size() >= ErrorRegistry.this.cacheSize) {
                this.remove(0);
            }
            return super.add(element);
        }
    };

    public ErrorRegistry(boolean logErrors, int cacheSize) {
        this.logErrors = logErrors;
        this.cacheSize = cacheSize;
    }

    public boolean logErrors() {
        return this.logErrors;
    }

    public int cacheSize() {
        return this.cacheSize;
    }

    public void register(Error error) {
        this.errors.add(error);
        if (this.logErrors || error.urgent()) {
            RC.Adapter().log(error.toComponent());
        }
    }

    public Optional<Error> fetch(@NotNull UUID uuid) {
        return this.errors.stream().filter(e -> e.uuid().equals(uuid)).findFirst();
    }

    public List<Error> fetchAll() {
        return Collections.unmodifiableList(this.errors);
    }

    @Override
    public void close() throws Exception {
        this.errors.clear();
    }

    @Override
    @Nullable
    public Component details() {
        return Component.join((JoinConfiguration)JoinConfiguration.newlines(), (ComponentLike[])new ComponentLike[]{RC.Lang("rustyconnector-keyValue").generate("Log Errors", this.logErrors), RC.Lang("rustyconnector-keyValue").generate("Cache Size", this.cacheSize), RC.Lang("rustyconnector-keyValue").generate("Error Count", this.errors.size())});
    }
}

