/*
 * Decompiled with CFR 0.152.
 */
package group.aelysium.rustyconnector.common.events;

import group.aelysium.rustyconnector.RC;
import group.aelysium.rustyconnector.common.algorithm.QuickSort;
import group.aelysium.rustyconnector.common.errors.Error;
import group.aelysium.rustyconnector.common.events.Event;
import group.aelysium.rustyconnector.common.events.EventListener;
import group.aelysium.rustyconnector.common.modules.Module;
import group.aelysium.rustyconnector.proxy.family.load_balancing.ISortable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.JoinConfiguration;
import org.jetbrains.annotations.Nullable;

public class EventManager
implements Module {
    private final ThreadPoolExecutor executor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
    private final ConcurrentHashMap<Class<? extends Event>, Vector<SortableListener>> listeners = new ConcurrentHashMap();

    public void listen(Object listener) {
        boolean isInstance = !(listener instanceof Class);
        Class<?> objectClass = listener instanceof Class ? (Class<?>)listener : listener.getClass();
        for (Method method2 : objectClass.getMethods()) {
            EventListener annotation;
            if (isInstance && Modifier.isStatic(method2.getModifiers()) || !isInstance && !Modifier.isStatic(method2.getModifiers()) || !method2.isAnnotationPresent(EventListener.class) || (annotation = method2.getAnnotation(EventListener.class)) == null) continue;
            Class<?>[] parameters = method2.getParameterTypes();
            if (parameters[0] == null) {
                return;
            }
            try {
                Class<?> eventType = parameters[0];
                this.listeners.computeIfAbsent(eventType, k -> new Vector()).add(new SortableListener(annotation.order().getSlot(), annotation.ignoreCanceled(), event -> {
                    try {
                        try {
                            method2.invoke(isInstance ? listener : null, event);
                        }
                        catch (IllegalArgumentException ignore) {
                            method2.invoke(isInstance ? listener : null, new Object[0]);
                        }
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        RC.Error(Error.from(e));
                    }
                }));
            }
            catch (Exception e) {
                RC.Error(Error.from(e));
            }
        }
        this.listeners.forEach((k, v) -> QuickSort.sort(v));
    }

    public void fireEvent(Event event) {
        List listeners = this.listeners.get(event.getClass());
        if (listeners == null) {
            return;
        }
        this.executor.execute(() -> listeners.forEach(listener -> {
            try {
                listener.consumer().accept(event);
            }
            catch (Exception e) {
                RC.Error(Error.from(e));
            }
        }));
    }

    public CompletableFuture<Boolean> fireEvent(Event.Cancelable event) {
        List listeners = this.listeners.get(event.getClass());
        if (listeners == null) {
            return CompletableFuture.completedFuture(false);
        }
        if (listeners.isEmpty()) {
            return CompletableFuture.completedFuture(false);
        }
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        this.executor.execute(() -> {
            try {
                listeners.forEach(listener -> {
                    if (event.canceled() && !listener.ignoreCanceled()) {
                        return;
                    }
                    try {
                        listener.consumer().accept(event);
                    }
                    catch (Exception e) {
                        RC.Error(Error.from(e));
                    }
                });
                future.complete(event.canceled());
            }
            catch (Exception e) {
                RC.Error(Error.from(e));
                future.complete(false);
            }
        });
        return future;
    }

    @Override
    public void close() {
        this.listeners.clear();
        this.executor.shutdown();
    }

    @Override
    @Nullable
    public Component details() {
        return Component.join((JoinConfiguration)JoinConfiguration.newlines(), (ComponentLike[])new ComponentLike[]{RC.Lang("rustyconnector-keyValue").generate("Current Thread Pool Size", this.executor.getPoolSize()), RC.Lang("rustyconnector-keyValue").generate("Busy Threads", this.executor.getActiveCount()), RC.Lang("rustyconnector-keyValue").generate("Highest Concurrent Threads", this.executor.getLargestPoolSize()), RC.Lang("rustyconnector-keyValue").generate("Pending Events", this.executor.getQueue().size()), RC.Lang("rustyconnector-keyValue").generate("Total Listeners Per Event", Component.text((String)String.join((CharSequence)", ", this.listeners.entrySet().stream().map(e -> ((Class)e.getKey()).getSimpleName() + " (" + ((Vector)e.getValue()).size() + ")").toList())))});
    }

    protected static class SortableListener
    implements ISortable {
        private final int index;
        private final boolean ignoreCanceled;
        private final Consumer<Event> consumer;

        public SortableListener(int index, boolean ignoreCanceled, Consumer<Event> consumer) {
            this.index = index;
            this.ignoreCanceled = ignoreCanceled;
            this.consumer = consumer;
        }

        public Consumer<Event> consumer() {
            return this.consumer;
        }

        public boolean ignoreCanceled() {
            return this.ignoreCanceled;
        }

        @Override
        public double sortIndex() {
            return this.index;
        }

        @Override
        public int weight() {
            return 0;
        }
    }
}

