/*
 * Decompiled with CFR 0.152.
 */
package group.aelysium.rustyconnector.common.lang;

import group.aelysium.rustyconnector.RC;
import group.aelysium.rustyconnector.common.errors.Error;
import group.aelysium.rustyconnector.common.lang.ASCIIAlphabet;
import group.aelysium.rustyconnector.common.lang.EnglishAlphabet;
import group.aelysium.rustyconnector.common.lang.Lang;
import group.aelysium.rustyconnector.common.lang.LangNode;
import group.aelysium.rustyconnector.common.modules.Module;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.JoinConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LangLibrary
implements Module {
    private final Map<String, LangNode> nodes = new ConcurrentHashMap<String, LangNode>();
    private final ASCIIAlphabet asciiAlphabet;
    public static ASCIIAlphabet DEFAULT_ASCII_ALPHABET = new EnglishAlphabet();

    public LangLibrary(@NotNull ASCIIAlphabet asciiAlphabet) {
        this.asciiAlphabet = asciiAlphabet;
    }

    public void registerLangNode(String id, LangNode node) {
        this.nodes.put(id, node);
    }

    public void registerLangNode(Field field) throws RuntimeException {
        if (!field.isAnnotationPresent(Lang.class)) {
            throw new RuntimeException("The field " + field.getName() + " isn't annotated with @Lang.");
        }
        Lang annotation = field.getAnnotation(Lang.class);
        if (this.nodes.containsKey(annotation.value()) && annotation.strict()) {
            return;
        }
        if (!this.nodes.containsKey(annotation.value()) && annotation.required()) {
            return;
        }
        Class<?> clazz = field.getType();
        Type type = field.getGenericType();
        LangNode node = null;
        if (Component.class.isAssignableFrom(clazz)) {
            node = LangLibrary.createNode(annotation.value(), arguments -> {
                try {
                    return (Component)field.get(Component.class);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }
        if (String.class.isAssignableFrom(clazz)) {
            node = LangLibrary.createNode(annotation.value(), arguments -> {
                try {
                    return Component.text((String)((String)field.get(String.class)));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }
        if (String[].class.isAssignableFrom(clazz)) {
            node = LangLibrary.createNode(annotation.value(), arguments -> {
                try {
                    return Component.join((JoinConfiguration)JoinConfiguration.separator((ComponentLike)Component.newline()), Arrays.stream((String[])field.get(String[].class)).map(Component::text).toList());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }
        if (type instanceof ParameterizedType) {
            Class entryClass;
            ParameterizedType parameterizedType = (ParameterizedType)type;
            if (List.class.isAssignableFrom(clazz) && String.class.isAssignableFrom(entryClass = (Class)parameterizedType.getActualTypeArguments()[0])) {
                node = LangLibrary.createNode(annotation.value(), arguments -> {
                    try {
                        return Component.join((JoinConfiguration)JoinConfiguration.separator((ComponentLike)Component.newline()), ((List)field.get(List.class)).stream().map(Component::text).toList());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                });
            }
        }
        if (node == null) {
            throw new RuntimeException("Fields annotated with @Lang must be of type: String, String[], List<String>, or Component.");
        }
        this.nodes.put(annotation.value(), node);
    }

    public void registerLangNode(Method method2) throws RuntimeException {
        if (!method2.isAnnotationPresent(Lang.class)) {
            throw new RuntimeException("The method " + method2.getName() + " isn't annotated with @Lang.");
        }
        Lang annotation = method2.getAnnotation(Lang.class);
        if (this.nodes.containsKey(annotation.value()) && annotation.strict()) {
            return;
        }
        if (!this.nodes.containsKey(annotation.value()) && annotation.required()) {
            return;
        }
        Class<?> clazz = method2.getReturnType();
        Class[] parameters = method2.getParameterTypes();
        LangNode node = null;
        if (Component.class.isAssignableFrom(clazz)) {
            node = LangLibrary.createNode(annotation.value(), arguments -> {
                if (parameters.length != ((Object[])arguments).length) {
                    throw new IllegalArgumentException("Incorrect number of arguments provided for the lang node: " + annotation.value());
                }
                for (int i = 0; i < parameters.length; ++i) {
                    Class currentParameter = parameters[i];
                    Object currentArgument = arguments[i];
                    if (currentArgument == null) {
                        throw new IllegalArgumentException("Incorrect number of arguments provided for the lang node: " + annotation.value());
                    }
                    if (currentParameter.isAssignableFrom(currentArgument.getClass())) continue;
                    throw new IllegalArgumentException("Incorrect type provided for argument " + (i + 1) + ". Expected " + currentParameter.getSimpleName() + " but got " + currentArgument.getClass().getSimpleName());
                }
                try {
                    return (Component)method2.invoke(null, arguments);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }
        if (String.class.isAssignableFrom(clazz)) {
            node = LangLibrary.createNode(annotation.value(), arguments -> {
                if (parameters.length != ((Object[])arguments).length) {
                    throw new IllegalArgumentException("Incorrect number of arguments provided for the lang node: " + annotation.value());
                }
                for (int i = 0; i < parameters.length; ++i) {
                    Class currentParameter = parameters[i];
                    Object currentArgument = arguments[i];
                    if (currentArgument == null) {
                        throw new IllegalArgumentException("Incorrect number of arguments provided for the lang node: " + annotation.value());
                    }
                    if (currentParameter.isAssignableFrom(currentArgument.getClass())) continue;
                    throw new IllegalArgumentException("Incorrect type provided for argument " + (i + 1) + ". Expected " + currentParameter.getSimpleName() + " but got " + currentArgument.getClass().getSimpleName());
                }
                try {
                    return Component.text((String)((String)method2.invoke(null, arguments)));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }
        if (node == null) {
            throw new RuntimeException("Methods annotated with @Lang must return either Component or String.");
        }
        this.registerLangNode(annotation.value(), node);
    }

    public void registerLangNodes(Class<?> clazz) {
        Method[] methods = clazz.getMethods();
        Field[] fields = clazz.getFields();
        Arrays.stream(methods).forEach(m -> {
            try {
                if (!Modifier.isStatic(m.getModifiers())) {
                    return;
                }
                this.registerLangNode((Method)m);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        Arrays.stream(fields).forEach(f -> {
            try {
                if (!Modifier.isStatic(f.getModifiers())) {
                    return;
                }
                this.registerLangNode((Field)f);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    public LangNode lang(String id) {
        return Optional.ofNullable(this.nodes.get(id)).orElse(LangLibrary.createNode(id, a -> Component.text((String)("[Missing: " + id + "]"))));
    }

    public ASCIIAlphabet asciiAlphabet() {
        return this.asciiAlphabet;
    }

    public Set<String> langNodes() {
        return Collections.unmodifiableSet(this.nodes.keySet());
    }

    @Override
    public void close() {
        this.nodes.clear();
    }

    private static LangNode createNode(@NotNull String name, final @NotNull Function<Object[], Component> function) {
        return new LangNode(name){

            @Override
            public Component generate(Object ... arguments) throws RuntimeException {
                try {
                    return (Component)function.apply(arguments);
                }
                catch (Exception e) {
                    Error error = Error.from(e).whileAttempting("To call the Lang tag: " + this.name);
                    RC.Error(error);
                    return Component.text((String)("[Error: " + this.name + "](" + String.valueOf(error.uuid()) + ")"));
                }
            }
        };
    }

    @Override
    @Nullable
    public Component details() {
        return Component.join((JoinConfiguration)JoinConfiguration.newlines(), (ComponentLike[])new ComponentLike[]{RC.Lang("rustyconnector-keyValue").generate("ASCII Alphabet - Supported Characters", "'" + String.join((CharSequence)"', '", this.asciiAlphabet().supportedCharacters().stream().map(Object::toString).toList()) + "'"), RC.Lang("rustyconnector-keyValue").generate("Registered Nodes", String.join((CharSequence)", ", this.langNodes()))});
    }
}

