/*
 * Decompiled with CFR 0.152.
 */
package group.aelysium.rustyconnector.common.magic_link;

import group.aelysium.rustyconnector.RC;
import group.aelysium.rustyconnector.common.cache.TimeoutCache;
import group.aelysium.rustyconnector.common.crypt.AES;
import group.aelysium.rustyconnector.common.crypt.NanoID;
import group.aelysium.rustyconnector.common.errors.Error;
import group.aelysium.rustyconnector.common.magic_link.PacketCache;
import group.aelysium.rustyconnector.common.magic_link.packet.Packet;
import group.aelysium.rustyconnector.common.magic_link.packet.PacketListener;
import group.aelysium.rustyconnector.common.magic_link.packet.PacketType;
import group.aelysium.rustyconnector.common.modules.Module;
import group.aelysium.rustyconnector.common.util.IPV6Broadcaster;
import group.aelysium.rustyconnector.proxy.util.LiquidTimestamp;
import group.aelysium.rustyconnector.shaded.com.google.code.gson.gson.JsonElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MagicLinkCore
implements Module {
    protected static final String endpoint = "bDaBMkmYdZ6r4iFExwW6UzJyNMDseWoS3HDa6FcyM7xNeCmtK98S3Mhp4o7g7oW6VB9CA6GuyH2pNhpQk3QvSmBUeCoUDZ6FXUsFCuVQC59CB2y22SBnGkMf9NMB9UWk";
    protected final TimeoutCache<NanoID, Packet.Local> packetsAwaitingReply = new TimeoutCache(LiquidTimestamp.from(15, TimeUnit.SECONDS));
    protected final Map<String, List<Consumer<Packet.Remote>>> listeners = new ConcurrentHashMap<String, List<Consumer<Packet.Remote>>>();
    protected final AES aes;
    protected final PacketCache cache;
    protected final Packet.SourceIdentifier self;

    protected MagicLinkCore(@NotNull Packet.SourceIdentifier self, @NotNull AES aes, @NotNull PacketCache cache) {
        this.self = self;
        this.aes = aes;
        this.cache = cache;
    }

    public void listen(Object listener) {
        for (Method method2 : listener.getClass().getDeclaredMethods()) {
            if (!method2.isAnnotationPresent(PacketListener.class)) continue;
            PacketListener annotation = method2.getAnnotation(PacketListener.class);
            try {
                Parameter firstParameter = method2.getParameters()[0];
                if (!annotation.value().equals(firstParameter.getType())) {
                    throw new NoSuchMethodException("Methods annotated with @PacketListener must contain a single parameter of the same class type as defined on @PacketListener. Expected " + annotation.value().getName() + " but got " + firstParameter.getType().getName());
                }
                if (!method2.getReturnType().equals(PacketListener.Response.class)) {
                    throw new NoSuchMethodException("Methods annotated with @PacketListener must have PacketListener.Response as the return type.");
                }
                Class<?> packetWrapper = firstParameter.getType();
                if (!packetWrapper.isAnnotationPresent(PacketType.class)) {
                    throw new NoSuchMethodException("Packet classes used for PacketListeners must be annotated with @PacketType. Caused by " + firstParameter.getType().getName());
                }
                String type = packetWrapper.getAnnotation(PacketType.class).value();
                Constructor<?> constructor = packetWrapper.getConstructor(Packet.class);
                this.listeners.computeIfAbsent(type, k -> new Vector()).add(packet -> {
                    block8: {
                        try {
                            PacketListener.Response response = (PacketListener.Response)method2.invoke(listener, constructor.newInstance(packet));
                            packet.status(response.successful, response.message);
                            if (response.shouldSendPacket() || annotation.responsesAsPacketReplies()) {
                                packet.reply(response);
                            }
                        }
                        catch (InvocationTargetException e) {
                            RC.Error(Error.from(e));
                            if (!annotation.responseFromExceptions()) {
                                return;
                            }
                            if (e.getCause() == null) {
                                packet.status(false, e.getMessage());
                                return;
                            }
                            packet.status(false, e.getMessage());
                            if (annotation.responsesAsPacketReplies()) {
                                packet.reply(PacketListener.Response.error(e.getMessage()));
                            }
                        }
                        catch (Exception e) {
                            RC.Error(Error.from(e));
                            if (!annotation.responseFromExceptions()) {
                                return;
                            }
                            packet.status(false, e.getMessage());
                            if (!annotation.responsesAsPacketReplies()) break block8;
                            packet.reply(PacketListener.Response.error(e.getMessage()));
                        }
                    }
                });
            }
            catch (Exception e) {
                RC.Error(Error.from(e).urgent(true));
            }
        }
    }

    public abstract void publish(Packet.Local var1) throws IllegalStateException;

    public void awaitReply(Packet.Local packet) {
        this.packetsAwaitingReply.putIfAbsent(packet.local().replyEndpoint().orElseThrow(), packet);
    }

    public void on(String identification, Consumer<Packet.Remote> handler) {
        this.listeners.computeIfAbsent(identification, k -> new ArrayList()).add(handler);
    }

    public PacketCache packetCache() {
        return this.cache;
    }

    @Override
    public void close() {
        this.listeners.clear();
        this.cache.close();
        this.packetsAwaitingReply.close();
    }

    protected void handleMessage(String rawMessage) {
        Packet.Remote packet;
        try {
            packet = Packet.parseIncoming(this.aes.decrypt(rawMessage));
        }
        catch (Exception e) {
            RC.Error(Error.from(e).whileAttempting("To decrypt a packet incoming into MagicLink."));
            return;
        }
        try {
            if (!this.self.isEquivalent(packet.remote())) {
                return;
            }
            this.cache.cache(packet);
            if (packet.replying()) {
                Packet.Local replyTarget = this.packetsAwaitingReply.get(packet.remote().replyEndpoint().orElseThrow());
                if (replyTarget == null) {
                    throw new Exception("This packet is a response to another packet, which isn't available to receive responses anymore.");
                }
                replyTarget.handleReply(packet);
                return;
            }
            List<Consumer<Packet.Remote>> listeners = this.listeners.get(packet.type().toString());
            if (listeners == null || listeners.isEmpty()) {
                throw new Exception("No listeners exist to handle this packet.");
            }
            listeners.forEach(l -> l.accept(packet));
        }
        catch (Exception e) {
            packet.status(false, e.getMessage());
        }
    }

    public static abstract class Proxy
    extends MagicLinkCore {
        protected IPV6Broadcaster broadcaster;

        protected Proxy(@NotNull @NotNull @NotNull Packet.SourceIdentifier self, @NotNull AES aes, @NotNull PacketCache cache, @Nullable IPV6Broadcaster broadcaster) {
            super(self, aes, cache);
            this.broadcaster = broadcaster;
        }
    }

    public static abstract class Server
    extends MagicLinkCore {
        protected final AtomicInteger delay = new AtomicInteger(5);
        protected IPV6Broadcaster broadcaster;

        protected Server(@NotNull @NotNull @NotNull Packet.SourceIdentifier self, @NotNull AES aes, @NotNull PacketCache cache, @Nullable IPV6Broadcaster broadcaster) {
            super(self, aes, cache);
            this.broadcaster = broadcaster;
        }

        public void setDelay(int delay) {
            this.delay.set(delay);
        }
    }

    public static interface Packets {

        @PacketType(value="RC-PS")
        public static class SendPlayer
        extends Packet.Remote {
            public Optional<String> targetServer() {
                try {
                    if (!this.flags().contains((Object)Flag.SERVER)) {
                        return Optional.empty();
                    }
                    return this.genericTarget();
                }
                catch (NullPointerException nullPointerException) {
                    return Optional.empty();
                }
            }

            public Optional<String> targetFamily() {
                try {
                    if (!this.flags().contains((Object)Flag.FAMILY)) {
                        return Optional.empty();
                    }
                    return this.genericTarget();
                }
                catch (NullPointerException nullPointerException) {
                    return Optional.empty();
                }
            }

            public Optional<String> genericTarget() {
                try {
                    return Optional.ofNullable(this.parameters().get("t").getAsString());
                }
                catch (NullPointerException nullPointerException) {
                    return Optional.empty();
                }
            }

            public List<Flag> flags() {
                try {
                    String flagString = this.parameters().get("f").getAsString();
                    String[] flagArray = flagString.split("");
                    ArrayList<Flag> flags = new ArrayList<Flag>();
                    String[] stringArray = flagArray;
                    int n = stringArray.length;
                    block16: for (int i = 0; i < n; ++i) {
                        String f;
                        switch (f = stringArray[i]) {
                            case "f": {
                                flags.add(Flag.FAMILY);
                                continue block16;
                            }
                            case "s": {
                                flags.add(Flag.SERVER);
                                continue block16;
                            }
                            case "i": {
                                flags.add(Flag.MINIMAL);
                                continue block16;
                            }
                            case "o": {
                                flags.add(Flag.MODERATE);
                                continue block16;
                            }
                            case "a": {
                                flags.add(Flag.AGGRESSIVE);
                            }
                        }
                    }
                    return Collections.unmodifiableList(flags);
                }
                catch (Exception exception) {
                    return List.of();
                }
            }

            public Optional<String> playerID() {
                try {
                    String player = this.parameters().get("p").getAsString();
                    if (!player.startsWith("id-")) {
                        return Optional.empty();
                    }
                    return Optional.of(player.substring(3));
                }
                catch (Exception exception) {
                    return Optional.empty();
                }
            }

            public Optional<String> playerUsername() {
                try {
                    String player = this.parameters().get("p").getAsString();
                    if (!player.startsWith("u-")) {
                        return Optional.empty();
                    }
                    return Optional.of(player.substring(2));
                }
                catch (Exception exception) {
                    return Optional.of(this.parameters().get("p").getAsString());
                }
            }

            public String player() {
                return this.parameters().get("p").getAsString();
            }

            public SendPlayer(Packet packet) {
                super(packet);
            }

            public static Packet.Local sendUsername(@NotNull String username, @NotNull String target, @NotNull Set<Flag> flags) {
                return Packet.New().identification(Packet.Type.from("RC", "PS")).parameter("p", "u-" + username).parameter("t", target).parameter("f", flags.stream().map(f -> switch (f.ordinal()) {
                    default -> throw new MatchException(null, null);
                    case 0 -> "f";
                    case 1 -> "s";
                    case 2 -> "i";
                    case 3 -> "o";
                    case 4 -> "a";
                }).collect(Collectors.joining())).addressTo(Packet.SourceIdentifier.allAvailableProxies()).send();
            }

            public static Packet.Local sendID(@NotNull String id, @NotNull String target, @NotNull Set<Flag> flags) {
                return Packet.New().identification(Packet.Type.from("RC", "PS")).parameter("p", "id-" + id).parameter("t", target).parameter("f", flags.stream().map(f -> switch (f.ordinal()) {
                    default -> throw new MatchException(null, null);
                    case 0 -> "f";
                    case 1 -> "s";
                    case 2 -> "i";
                    case 3 -> "o";
                    case 4 -> "a";
                }).collect(Collectors.joining())).addressTo(Packet.SourceIdentifier.allAvailableProxies()).send();
            }

            public static enum Flag {
                FAMILY,
                SERVER,
                MINIMAL,
                MODERATE,
                AGGRESSIVE;

            }

            public static interface Parameters {
                public static final String GENERIC_TARGET = "t";
                public static final String PLAYER = "p";
                public static final String FLAGS = "f";
            }
        }

        @PacketType(value="RC-R")
        public static class Response
        extends Packet.Remote {
            public Response(Packet packet) {
                super(packet);
            }

            @Override
            public boolean successful() {
                return this.parameters().get("s").getAsBoolean();
            }

            public String message() {
                return this.parameters().get("r").getAsString();
            }

            public static interface Parameters {
                public static final String SUCCESSFUL = "s";
                public static final String MESSAGE = "r";
            }
        }

        @PacketType(value="RC-SP")
        public static class StalePing
        extends Packet.Remote {
            public StalePing(Packet packet) {
                super(packet);
            }
        }

        @PacketType(value="RC-D")
        public static class Disconnect
        extends Packet.Remote {
            public Disconnect(Packet packet) {
                super(packet);
            }
        }

        @PacketType(value="RC-P")
        public static class Ping
        extends Packet.Remote {
            public String address() {
                return this.parameters().get("a").getAsString();
            }

            public String targetFamily() {
                return this.parameters().get("tf").getAsString();
            }

            public Integer playerCount() {
                return this.parameters().get("pc").getAsInt();
            }

            @NotNull
            public Map<String, Object> metadata() {
                try {
                    HashMap metadata = new HashMap();
                    this.parameters().get("m").getAsJsonObject().entrySet().forEach(e -> metadata.put((String)e.getKey(), group.aelysium.rustyconnector.common.util.Parameter.fromJSON((JsonElement)e.getValue()).getOriginalValue()));
                    return Collections.unmodifiableMap(metadata);
                }
                catch (Exception exception) {
                    return Map.of();
                }
            }

            public Ping(Packet packet) {
                super(packet);
            }

            public static interface Parameters {
                public static final String ADDRESS = "a";
                public static final String TARGET_FAMILY = "tf";
                public static final String PLAYER_COUNT = "pc";
                public static final String METADATA = "m";
            }
        }
    }
}

