/*
 * Decompiled with CFR 0.152.
 */
package group.aelysium.rustyconnector.common.magic_link;

import group.aelysium.rustyconnector.common.crypt.NanoID;
import group.aelysium.rustyconnector.common.magic_link.packet.Packet;
import group.aelysium.rustyconnector.shaded.group.aelysium.ara.Closure;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Vector;
import org.jetbrains.annotations.NotNull;

public class PacketCache
implements Closure {
    private final List<Packet.Type> ignoredTypes;
    protected final int max;
    protected final Map<NanoID, Packet> packets;
    protected final List<Packet> packetsOrdered;

    public PacketCache(int max, List<Packet.Type> ignoredTypes) {
        if (max <= 0) {
            max = 0;
        }
        if (max > 1000) {
            max = 1000;
        }
        this.max = max;
        this.ignoredTypes = ignoredTypes;
        this.packets = Collections.synchronizedMap(new LinkedHashMap<NanoID, Packet>(this.max){

            @Override
            protected boolean removeEldestEntry(Map.Entry eldest) {
                return this.size() > PacketCache.this.max;
            }
        });
        this.packetsOrdered = new Vector<Packet>(this.max){

            @Override
            public boolean add(Packet item) {
                if (this.size() >= PacketCache.this.max) {
                    this.remove(0);
                }
                return super.add(item);
            }
        };
    }

    public PacketCache(int max) {
        this(max, List.of());
    }

    public PacketCache() {
        this(100);
    }

    public void cache(Packet packet) {
        if (this.ignoredTypes.contains(packet.type())) {
            return;
        }
        this.packets.put(packet.local().replyEndpoint().orElseThrow(), packet);
        this.packetsOrdered.add(packet);
    }

    public boolean ignoredType(@NotNull Packet packet) {
        return this.ignoredTypes.contains(packet.type());
    }

    @NotNull
    public Optional<Packet> find(@NotNull NanoID id) {
        return Optional.ofNullable(this.packets.get(id));
    }

    @NotNull
    public List<Packet> packets() {
        return this.packetsOrdered;
    }

    public int size() {
        return this.packets.size();
    }

    public void empty() {
        this.packets.clear();
    }

    @Override
    public void close() {
        this.packets.clear();
    }
}

